/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.picketlink.json.jose.JWK;
import org.picketlink.json.jose.JWKBuilder;

public class JWKSet {
    private final Map<String, JWK> keys = new HashMap<String, JWK>();

    public JWKSet() {
    }

    public JWKSet(JWK ... keys) {
        for (JWK key : keys) {
            this.add(key);
        }
    }

    public JWKSet(JsonArray keys) {
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            this.add((JWK)new JWKBuilder().build((JsonObject)iterator.next()));
        }
    }

    public JWKSet(String jsonKeySet) {
        JsonObject jsonObject = Json.createReader((InputStream)new ByteArrayInputStream(jsonKeySet.getBytes())).readObject();
        JsonArray keys = jsonObject.getJsonArray("keys");
        for (JsonObject jsonKey : keys) {
            this.add((JWK)new JWKBuilder().build(jsonKey));
        }
    }

    public void add(JWK jwk) {
        this.keys.put(jwk.getKeyIdentifier(), jwk);
    }

    public JWK get(String kid) {
        return this.keys.get(kid);
    }

    public Map<String, JWK> getKeys() {
        return Collections.unmodifiableMap(this.keys);
    }

    public JsonObject getJsonObject() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        Iterator<JWK> iterator = this.keys.values().iterator();
        while (iterator.hasNext()) {
            arrayBuilder.add((JsonValue)iterator.next().getJsonObject());
        }
        return Json.createObjectBuilder().add("keys", (JsonValue)arrayBuilder.build()).build();
    }

    public String toString() {
        StringWriter claimsWriter = new StringWriter();
        Json.createWriter((Writer)claimsWriter).writeObject(this.getJsonObject());
        return claimsWriter.getBuffer().toString();
    }
}

