/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.crypto.HMACSignatureProvider;
import org.picketlink.json.jose.crypto.RSASignatureProvider;
import org.picketlink.json.jose.crypto.SignatureProvider;

public enum Algorithm {
    NONE("none", null),
    HS256("HMACSHA256", HMACSignatureProvider.instance()),
    HS384("HMACSHA384", HMACSignatureProvider.instance()),
    HS512("HMACSHA512", HMACSignatureProvider.instance()),
    RS256("SHA256withRSA", RSASignatureProvider.instance()),
    RS384("SHA384withRSA", RSASignatureProvider.instance()),
    RS512("SHA512withRSA", RSASignatureProvider.instance());

    private final String algorithm;
    private final SignatureProvider signatureProvider;

    private Algorithm(String algorithm, SignatureProvider signatureProvider) {
        this.algorithm = algorithm;
        this.signatureProvider = signatureProvider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean isNone() {
        return NONE.equals((Object)this);
    }

    public SignatureProvider getSignatureProvider() {
        return this.signatureProvider;
    }

    public static Algorithm resolve(String name) {
        try {
            return Algorithm.valueOf(name);
        }
        catch (IllegalArgumentException iae) {
            throw JsonMessages.MESSAGES.cryptoNoSuchAlgorithm(name, iae);
        }
    }
}

