/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.idp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.jboss.security.audit.AuditEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.IssuerNotTrustedException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.picketlink.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v1.SAML11ProtocolContext;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11ResponseWriter;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.STSCoreConfig;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityParticipantStack;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;

public abstract class AbstractIDPValve
extends ValveBase {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected boolean enableAudit = false;
    protected PicketLinkAuditHelper auditHelper = null;
    protected IDPType idpConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    private RoleGenerator roleGenerator = new TomcatRoleGenerator();
    private TrustKeyManager keyManager;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private final List<String> attributeKeys = new ArrayList<String>();
    private transient SAML2HandlerChain chain = null;
    protected SAMLConfigurationProvider configProvider = null;
    protected int timerInterval = -1;
    protected Timer timer = null;
    private String configFile;
    private final Lock chainLock = new ReentrantLock();
    private Map<String, SPSSODescriptorType> spSSOMetadataMap = new HashMap<String, SPSSODescriptorType>();
    private SSLAuthenticator sslAuthenticator;
    private Handlers handlers;

    public void setAttributeList(String attribList) {
        if (StringUtil.isNotNull((String)attribList)) {
            this.attributeKeys.clear();
            this.attributeKeys.addAll(StringUtil.tokenize((String)attribList));
        }
    }

    public void setTimerInterval(String value) {
        if (StringUtil.isNotNull((String)value)) {
            this.timerInterval = Integer.parseInt(value);
        }
    }

    public void setConfigProvider(String cp) {
        if (cp == null) {
            throw logger.nullArgumentError("configProvider");
        }
        Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), cp);
        if (clazz == null) {
            throw new RuntimeException(logger.classNotLoadedError(cp));
        }
        try {
            this.configProvider = (SAMLConfigurationProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(logger.couldNotCreateInstance(cp, (Throwable)e));
        }
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigProvider(SAMLConfigurationProvider configurationProvider) {
        this.configProvider = configurationProvider;
    }

    @Deprecated
    public void setRoleGenerator(String rgName) {
        logger.warn("Option 'roleGenerator' is deprecated and should not be used. This configuration is now set in picketlink.xml.");
    }

    @Deprecated
    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        logger.warn("Option 'samlHandlerChainClass' is deprecated and should not be used. This configuration is now set in picketlink.xml.");
    }

    @Deprecated
    public void setIdentityParticipantStack(String fqn) {
        logger.warn("Option 'identityParticipantStack' is deprecated and should not be used. This configuration is now set in picketlink.xml.");
    }

    @Deprecated
    public void setStrictPostBinding(Boolean strictPostBinding) {
        logger.warn("Option 'strictPostBinding' is deprecated and should not be used. This configuration is now set in picketlink.xml.");
    }

    @Deprecated
    public Boolean getIgnoreIncomingSignatures() {
        logger.warn("Option 'ignoreIncomingSignatures' is deprecated and should not be used. Signatures are verified if SAML2SignatureValidationHandler is available.");
        return false;
    }

    @Deprecated
    public void setIgnoreIncomingSignatures(Boolean ignoreIncomingSignature) {
        logger.warn("Option 'ignoreIncomingSignatures' is deprecated and not used. Signatures are verified if SAML2SignatureValidationHandler is available.");
    }

    @Deprecated
    public void setValidatingAliasToTokenIssuer(Boolean validatingAliasToTokenIssuer) {
        logger.warn("Option 'validatingAliasToTokenIssuer' is deprecated and not used. The IDP will always use the issuer host to validate signatures.");
    }

    public void setIgnoreAttributesGeneration(Boolean ignoreAttributes) {
        if (ignoreAttributes == Boolean.TRUE) {
            this.attribManager = null;
        }
    }

    @Deprecated
    public Boolean getSignOutgoingMessages() {
        logger.warn("Option signOutgoingMessages is used for signing of error messages. Normal SAML messages are signed by SAML2SignatureGenerationHandler.");
        return true;
    }

    @Deprecated
    public void setSignOutgoingMessages(Boolean signOutgoingMessages) {
        logger.warn("Option signOutgoingMessages is used for signing of error messages. Normal SAML messages are signed by SAML2SignatureGenerationHandler.");
    }

    public PicketLinkType getConfiguration() {
        return this.picketLinkConfiguration;
    }

    public TrustKeyManager getKeyManager() {
        return this.keyManager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.isUnauthorized(response)) {
            this.handleUnauthorizedResponse(request, response);
            return;
        }
        this.populateSessionWithSAMLParameters(request);
        Principal userPrincipal = this.getUserPrincipal(request, response);
        if (userPrincipal != null) {
            this.handleSAMLMessage(request, response);
        }
    }

    private void handleSAMLMessage(Request request, Response response) throws IOException, ServletException {
        if (this.isUnsolicitedResponse(request)) {
            String samlVersion = request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_SAML_VERSION.get());
            if (samlVersion != null && JBossSAMLConstants.VERSION_2_0.get().equals(samlVersion)) {
                this.handleSAML2UnsolicitedResponse(request, response);
            } else {
                this.handleSAML11UnsolicitedResponse(request, response);
            }
        } else {
            Session session = request.getSessionInternal();
            String samlRequestMessage = (String)session.getNote("SAMLRequest");
            String samlResponseMessage = (String)session.getNote("SAMLResponse");
            String relayState = (String)session.getNote("RelayState");
            String signature = (String)session.getNote("Signature");
            String sigAlg = (String)session.getNote("SigAlg");
            if (logger.isTraceEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Retrieved saml messages and relay state from session");
                builder.append("saml Request message=").append(samlRequestMessage);
                builder.append("::").append("SAMLResponseMessage=");
                builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                logger.trace(builder.toString());
            }
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                this.processSAMLRequestMessage(request, response, null, false);
            } else if (StringUtil.isNotNull((String)samlResponseMessage)) {
                this.processSAMLResponseMessage(request, response);
            } else if (request.getRequestURI().equals(request.getContextPath() + "/")) {
                this.forwardHosted(request, response);
            }
        }
    }

    private boolean isUnsolicitedResponse(Request request) {
        return StringUtil.isNotNull((String)request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_TARGET.get()));
    }

    private void forwardHosted(Request request, Response response) throws ServletException, IOException {
        logger.trace("SAML 1.1::Proceeding to IDP index page");
        RequestDispatcher dispatch = this.getContext().getServletContext().getRequestDispatcher(this.idpConfiguration.getHostedURI());
        this.recycle(response);
        try {
            this.includeResource((ServletRequest)request, response, dispatch);
        }
        catch (ClassCastException cce) {
            this.includeResource((ServletRequest)request.getRequest(), response, dispatch);
        }
    }

    private void includeResource(ServletRequest request, Response response, RequestDispatcher dispatch) throws ServletException, IOException {
        dispatch.include(request, (ServletResponse)response);
        response.getCoyoteResponse().setContentLength(response.getContentCount());
    }

    private void populateSessionWithSAMLParameters(Request request) throws IOException {
        String samlRequestMessage = request.getParameter("SAMLRequest");
        String samlResponseMessage = request.getParameter("SAMLResponse");
        boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
        boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
        String signature = request.getParameter("Signature");
        String sigAlg = request.getParameter("SigAlg");
        String relayState = request.getParameter("RelayState");
        Session session = request.getSessionInternal();
        if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
            logger.trace("Storing the SAMLRequest/SAMLResponse and RelayState in session");
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                session.setNote("SAMLRequest", (Object)samlRequestMessage);
            }
            if (StringUtil.isNotNull((String)samlResponseMessage)) {
                session.setNote("SAMLResponse", (Object)samlResponseMessage);
            }
            if (StringUtil.isNotNull((String)relayState)) {
                session.setNote("RelayState", (Object)relayState.trim());
            }
            if (StringUtil.isNotNull((String)signature)) {
                session.setNote("Signature", (Object)signature.trim());
            }
            if (StringUtil.isNotNull((String)sigAlg)) {
                session.setNote("SigAlg", (Object)sigAlg.trim());
            }
        }
    }

    private void handleUnauthorizedResponse(Request request, Response response) throws IOException, ServletException {
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
        Document samlErrorResponse = null;
        String referer = request.getHeader("Referer");
        String relayState = request.getParameter("RelayState");
        try {
            samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlErrorResponse).setDestination(referer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response).setErrorResponse(true);
            holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
            if (this.idpConfiguration.isSupportsSignature()) {
                holder.setSupportSignature(true).setPrivateKey(this.keyManager.getSigningKey());
            }
            holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
            webRequestUtil.send(holder);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isUnauthorized(Response response) {
        return response.getStatus() == 403;
    }

    private Principal getUserPrincipal(Request request, Response response) throws IOException, ServletException {
        Principal userPrincipal = request.getPrincipal();
        if (userPrincipal == null) {
            if (this.idpConfiguration.isSSLClientAuthentication() && request.isSecure()) {
                this.getSSLAuthenticator().invoke(request, response);
                response.resetBuffer();
                response.recycle();
            }
            if ((userPrincipal = request.getPrincipal()) == null) {
                this.getNext().invoke(request, response);
            }
            userPrincipal = request.getPrincipal();
        }
        return userPrincipal;
    }

    public Principal authenticateSSL(Request request, Response response) throws IOException {
        X509Certificate[] certs;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Looking up certificates");
        }
        if ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            }
            catch (IllegalStateException ise) {
                response.sendError(401, sm.getString("authenticator.certificates"));
                return null;
            }
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  No certificates included with this request");
            }
            response.sendError(401, sm.getString("authenticator.certificates"));
            return null;
        }
        Principal principal = this.getContext().getRealm().authenticate(certs);
        if (principal == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"  Realm.authenticate() returned false");
            }
            response.sendError(401, sm.getString("authenticator.unauthorized"));
            return null;
        }
        return principal;
    }

    protected void handleSAML11UnsolicitedResponse(Request request, Response response) throws ServletException, IOException {
        try {
            GenericPrincipal genericPrincipal;
            String[] roles;
            SAML11AttributeStatementType attributeStatement;
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
            Principal userPrincipal = request.getPrincipal();
            String contextPath = this.getContextPath();
            String target = request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_TARGET.get());
            Session session = request.getSessionInternal();
            SAML11AssertionType saml11Assertion = (SAML11AssertionType)session.getNote("SAML11");
            if (saml11Assertion == null) {
                SAML11ProtocolContext saml11Protocol = new SAML11ProtocolContext();
                saml11Protocol.setIssuerID(this.getIdentityURL());
                SAML11SubjectType subject = new SAML11SubjectType();
                SAML11SubjectType.SAML11SubjectTypeChoice subjectChoice = new SAML11SubjectType.SAML11SubjectTypeChoice(new SAML11NameIdentifierType(userPrincipal.getName()));
                subject.setChoice(subjectChoice);
                saml11Protocol.setSubjectType(subject);
                PicketLinkCoreSTS.instance().issueToken((ProtocolContext)saml11Protocol);
                saml11Assertion = saml11Protocol.getIssuedAssertion();
                session.setNote("SAML11", (Object)saml11Assertion);
                if (AssertionUtil.hasExpired((SAML11AssertionType)saml11Assertion)) {
                    saml11Protocol.setIssuedAssertion(saml11Assertion);
                    PicketLinkCoreSTS.instance().renewToken((ProtocolContext)saml11Protocol);
                    saml11Assertion = saml11Protocol.getIssuedAssertion();
                    session.setNote("SAML11", (Object)saml11Assertion);
                }
            }
            if ((attributeStatement = this.createAttributeStatement(Arrays.asList(roles = (genericPrincipal = (GenericPrincipal)userPrincipal).getRoles()))) != null) {
                saml11Assertion.add((SAML11StatementAbstractType)attributeStatement);
            }
            String id = IDGenerator.create((String)"ID_");
            SAML11ResponseType saml11Response = new SAML11ResponseType(id, XMLTimeUtil.getIssueInstant());
            saml11Response.add(saml11Assertion);
            saml11Response.setStatus(SAML11StatusType.successType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SAML11ResponseWriter writer = new SAML11ResponseWriter(StaxUtil.getXMLStreamWriter((OutputStream)baos));
            writer.write(saml11Response);
            Document samlResponse = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(target).setRelayState("").setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                auditEvent.setDestination(target);
                auditEvent.setWhoIsAuditing(contextPath);
                this.auditHelper.audit((AuditEvent)auditEvent);
            }
            response.getCoyoteResponse().recycle();
            webRequestUtil.send(holder);
        }
        catch (GeneralSecurityException e) {
            logger.samlIDPHandlingSAML11Error((Throwable)e);
            throw new ServletException();
        }
    }

    private void handleSAML2UnsolicitedResponse(Request request, Response response) throws ServletException {
        SAML2Request samlRequest = new SAML2Request();
        String id = IDGenerator.create((String)"ID_");
        String assertionConsumerURL = request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_TARGET.get());
        try {
            AuthnRequestType authn = samlRequest.createAuthnRequestType(id, assertionConsumerURL, assertionConsumerURL, assertionConsumerURL);
            authn.setProtocolBinding(URI.create(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get()));
            request.setMethod("POST");
            this.processSAMLRequestMessage(request, response, (RequestAbstractType)authn, true);
        }
        catch (Exception e) {
            throw new ServletException("Could not handle SAML 2.0 Unsolicited Response.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSAMLRequestMessage(Request request, Response response, RequestAbstractType requestType, boolean ignoreSignatureValidation) throws IOException {
        Principal userPrincipal = request.getPrincipal();
        Session session = request.getSessionInternal();
        Document samlResponse = null;
        boolean isErrorResponse = false;
        String destination = null;
        String destinationQueryStringWithSignature = null;
        Boolean requestedPostProfile = null;
        String samlRequestMessage = (String)session.getNote("SAMLRequest");
        String relayState = (String)session.getNote("RelayState");
        String contextPath = this.getContextPath();
        boolean willSendRequest = false;
        String referer = request.getHeader("Referer");
        this.cleanUpSessionNote(request);
        boolean isSecure = request.isSecure();
        String loginType = this.determineLoginType(isSecure);
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
        SAMLDocumentHolder samlDocumentHolder = null;
        SAML2Object samlObject = null;
        try {
            if (requestType == null) {
                if (samlRequestMessage == null) {
                    throw logger.samlIDPValidationCheckFailed();
                }
                samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
            } else {
                samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)requestType);
                samlDocumentHolder.setSamlDocument(new SAML2Request().convert(requestType));
            }
            if (samlDocumentHolder == null) {
                return;
            }
            samlObject = samlDocumentHolder.getSamlObject();
            if (!(samlObject instanceof RequestAbstractType)) {
                throw logger.wrongTypeError(samlObject.getClass().getName());
            }
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            String issuer = requestAbstractType.getIssuer().getValue();
            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.getIdentityURL());
            HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.getContext().getServletContext());
            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
            saml2HandlerRequest.setRelayState(relayState);
            if (StringUtil.isNotNull((String)loginType)) {
                saml2HandlerRequest.addOption("LOGIN_TYPE", (Object)loginType);
            }
            String assertionID = (String)session.getSession().getAttribute("ASSERTION_ID");
            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
            Boolean ignoreSignatures = this.willIgnoreSignatureOfCurrentRequest(issuer);
            if (ignoreSignatureValidation) {
                ignoreSignatures = ignoreSignatureValidation;
            }
            requestOptions.put("IGNORE_SIGNATURES", ignoreSignatures);
            requestOptions.put("SP_SSO_METADATA_DESCRIPTOR", this.spSSOMetadataMap.get(issuer));
            requestOptions.put("ROLE_GENERATOR", this.roleGenerator);
            requestOptions.put("CONFIGURATION", this.idpConfiguration);
            requestOptions.put("SAML_IDP_STRICT_POST_BINDING", this.idpConfiguration.isStrictPostBinding());
            requestOptions.put("SUPPORTS_SIGNATURES", this.idpConfiguration.isSupportsSignature());
            if (assertionID != null) {
                requestOptions.put("ASSERTION_ID", assertionID);
            }
            if (this.keyManager != null) {
                PublicKey validatingKey = this.getIssuerPublicKey(request, issuer);
                requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
            }
            if (requestAbstractType instanceof AuthnRequestType) {
                List roles = this.roleGenerator.generateRoles(userPrincipal);
                session.getSession().setAttribute("picketlink.roles", (Object)roles);
                Map attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                requestOptions.put("ATTRIBUTES", attribs);
            }
            if (this.auditHelper != null) {
                requestOptions.put("AUDIT_HELPER", this.auditHelper);
                requestOptions.put("CONTEXT_PATH", contextPath);
            }
            saml2HandlerRequest.setOptions(requestOptions);
            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
            Set handlers = this.chain.handlers();
            logger.trace("Handlers are=" + handlers);
            if (handlers != null) {
                try {
                    if (this.getConfiguration().getHandlers().isLocking()) {
                        this.chainLock.lock();
                    }
                    for (SAML2Handler handler : handlers) {
                        handler.handleRequestType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                        willSendRequest = saml2HandlerResponse.getSendRequest();
                    }
                }
                finally {
                    if (this.getConfiguration().getHandlers().isLocking()) {
                        this.chainLock.unlock();
                    }
                }
            }
            samlResponse = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            destination = saml2HandlerResponse.getDestination();
            requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
            destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
        }
        catch (Exception e) {
            String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
            if (e instanceof IssuerNotTrustedException || e.getCause() instanceof IssuerNotTrustedException) {
                status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
            }
            logger.samlIDPRequestProcessingError((Throwable)e);
            samlResponse = webRequestUtil.getErrorResponse(referer, status, this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
            isErrorResponse = true;
        }
        try {
            if (destination == null && samlObject instanceof AuthnRequestType) {
                AuthnRequestType authRequest = (AuthnRequestType)samlObject;
                destination = authRequest.getAssertionConsumerServiceURL().toASCIIString();
            }
            if (destination == null) {
                response.sendRedirect(this.getIdentityURL());
            } else {
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse((HttpServletResponse)response).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                if (requestedPostProfile != null) {
                    holder.setPostBindingRequested(requestedPostProfile.booleanValue());
                } else {
                    holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                }
                if (this.idpConfiguration.isSupportsSignature()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                if (holder.isPostBinding()) {
                    this.recycle(response);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                    auditEvent.setDestination(destination);
                    auditEvent.setWhoIsAuditing(contextPath);
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                webRequestUtil.send(holder);
            }
        }
        catch (ParsingException e) {
            logger.samlAssertionPasingFailed((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            logger.trace("Security Exception:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private PublicKey getIssuerPublicKey(Request request, String issuer) throws ConfigurationException, ProcessingException {
        String issuerHost = null;
        PublicKey issuerPublicKey = null;
        try {
            issuerHost = new URL(issuer).getHost();
        }
        catch (MalformedURLException e) {
            logger.trace("Token issuer is not a valid URL: " + issuer, (Throwable)e);
            issuerHost = issuer;
        }
        logger.trace("Trying to find a PK for issuer: " + issuerHost);
        try {
            issuerPublicKey = CoreConfigUtil.getValidatingKey((TrustKeyManager)this.keyManager, (String)issuerHost);
        }
        catch (IllegalStateException ise) {
            logger.trace("Token issuer is not found for: " + issuer, (Throwable)ise);
        }
        if (issuerPublicKey == null) {
            issuerHost = request.getRemoteAddr();
            logger.trace("Trying to find a PK for issuer " + issuerHost);
            issuerPublicKey = CoreConfigUtil.getValidatingKey((TrustKeyManager)this.keyManager, (String)issuerHost);
        }
        logger.trace("Using Validating Alias=" + issuerHost + " to check signatures.");
        return issuerPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processSAMLResponseMessage(Request request, Response response) throws ServletException, IOException {
        block37: {
            boolean isValid;
            Session session = request.getSessionInternal();
            SAMLDocumentHolder samlDocumentHolder = null;
            SAML2Object samlObject = null;
            Document samlResponse = null;
            boolean isErrorResponse = false;
            String destination = null;
            String destinationQueryStringWithSignature = null;
            String contextPath = this.getContextPath();
            boolean requestedPostProfile = false;
            String samlResponseMessage = (String)session.getNote("SAMLResponse");
            String relayState = (String)session.getNote("RelayState");
            boolean willSendRequest = false;
            String referer = request.getHeader("Referer");
            this.cleanUpSessionNote(request);
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
            samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
            samlObject = samlDocumentHolder.getSamlObject();
            if (!(samlObject instanceof StatusResponseType)) {
                throw logger.wrongTypeError(samlObject.getClass().getName());
            }
            StatusResponseType statusResponseType = (StatusResponseType)samlObject;
            String issuer = statusResponseType.getIssuer().getValue();
            boolean bl = isValid = samlResponseMessage != null;
            if (!isValid) {
                throw logger.samlIDPValidationCheckFailed();
            }
            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.getIdentityURL());
            HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.getContext().getServletContext());
            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.idpConfiguration.isSupportsSignature() || this.idpConfiguration.isEncrypt()) {
                PublicKey publicKey = this.getIssuerPublicKey(request, issuer);
                options.put("SENDER_PUBLIC_KEY", publicKey);
            }
            options.put("SAML_IDP_STRICT_POST_BINDING", this.idpConfiguration.isStrictPostBinding());
            options.put("SUPPORTS_SIGNATURES", this.idpConfiguration.isSupportsSignature());
            if (this.auditHelper != null) {
                options.put("AUDIT_HELPER", this.auditHelper);
                options.put("CONTEXT_PATH", contextPath);
            }
            saml2HandlerRequest.setOptions(options);
            saml2HandlerRequest.setRelayState(relayState);
            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
            Set handlers = this.chain.handlers();
            if (handlers != null) {
                try {
                    this.chainLock.lock();
                    for (SAML2Handler handler : handlers) {
                        handler.reset();
                        handler.handleStatusResponseType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                        willSendRequest = saml2HandlerResponse.getSendRequest();
                    }
                }
                finally {
                    this.chainLock.unlock();
                }
            }
            samlResponse = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            destination = saml2HandlerResponse.getDestination();
            requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
            destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            try {
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                if (destination == null) {
                    throw new ServletException((Throwable)logger.nullValueError("Destination"));
                }
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                if (this.idpConfiguration.isSupportsSignature()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                if (holder.isPostBinding()) {
                    this.recycle(response);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                    auditEvent.setWhoIsAuditing(contextPath);
                    auditEvent.setDestination(destination);
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                webRequestUtil.send(holder);
            }
            catch (ParsingException e) {
                logger.samlAssertionPasingFailed((Throwable)e);
            }
            catch (GeneralSecurityException e) {
                logger.trace("Security Exception:", (Throwable)e);
            }
            break block37;
            catch (Exception e) {
                try {
                    String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
                    if (e instanceof IssuerNotTrustedException) {
                        status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
                    }
                    logger.samlIDPRequestProcessingError((Throwable)e);
                    samlResponse = webRequestUtil.getErrorResponse(referer, status, this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
                    isErrorResponse = true;
                }
                catch (Throwable throwable) {
                    try {
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        if (destination == null) {
                            throw new ServletException((Throwable)logger.nullValueError("Destination"));
                        }
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                        if (this.idpConfiguration.isSupportsSignature()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                        if (holder.isPostBinding()) {
                            this.recycle(response);
                        }
                        if (this.enableAudit) {
                            PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                            auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                            auditEvent.setWhoIsAuditing(contextPath);
                            auditEvent.setDestination(destination);
                            this.auditHelper.audit((AuditEvent)auditEvent);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e2) {
                        logger.samlAssertionPasingFailed((Throwable)e2);
                    }
                    catch (GeneralSecurityException e3) {
                        logger.trace("Security Exception:", (Throwable)e3);
                    }
                    throw throwable;
                }
                try {
                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                    if (destination == null) {
                        throw new ServletException((Throwable)logger.nullValueError("Destination"));
                    }
                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse((HttpServletResponse)response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                    if (this.idpConfiguration.isSupportsSignature()) {
                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                    }
                    holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                    if (holder.isPostBinding()) {
                        this.recycle(response);
                    }
                    if (this.enableAudit) {
                        PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                        auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                        auditEvent.setWhoIsAuditing(contextPath);
                        auditEvent.setDestination(destination);
                        this.auditHelper.audit((AuditEvent)auditEvent);
                    }
                    webRequestUtil.send(holder);
                }
                catch (ParsingException e4) {
                    logger.samlAssertionPasingFailed((Throwable)e4);
                }
                catch (GeneralSecurityException e5) {
                    logger.trace("Security Exception:", (Throwable)e5);
                }
            }
        }
    }

    protected void cleanUpSessionNote(Request request) {
        Session session = request.getSessionInternal();
        String samlRequestMessage = (String)session.getNote("SAMLRequest");
        String samlResponseMessage = (String)session.getNote("SAMLResponse");
        String relayState = (String)session.getNote("RelayState");
        String signature = (String)session.getNote("Signature");
        String sigAlg = (String)session.getNote("SigAlg");
        if (logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Retrieved saml messages and relay state from session");
            builder.append("saml Request message=").append(samlRequestMessage);
            builder.append("::").append("SAMLResponseMessage=");
            builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
            builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
            logger.trace(builder.toString());
        }
        if (StringUtil.isNotNull((String)samlRequestMessage)) {
            session.removeNote("SAMLRequest");
        }
        if (StringUtil.isNotNull((String)samlResponseMessage)) {
            session.removeNote("SAMLResponse");
        }
        if (StringUtil.isNotNull((String)relayState)) {
            session.removeNote("RelayState");
        }
        if (StringUtil.isNotNull((String)signature)) {
            session.removeNote("Signature");
        }
        if (StringUtil.isNotNull((String)sigAlg)) {
            session.removeNote("SigAlg");
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        logger.trace("About to send error response to SP:" + referrer);
        String contextPath = this.getContextPath();
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
        try {
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(referrer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
            holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
            if (this.idpConfiguration.isSupportsSignature()) {
                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
            }
            holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
            if (holder.isPostBinding()) {
                this.recycle(response);
            }
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.ERROR_RESPONSE_TO_SP);
                auditEvent.setWhoIsAuditing(contextPath);
                auditEvent.setDestination(referrer);
                this.auditHelper.audit((AuditEvent)auditEvent);
            }
            webRequestUtil.send(holder);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void initIdentityServer() {
        IdentityServer identityServer = (IdentityServer)this.getContext().getServletContext().getAttribute("IDENTITY_SERVER");
        if (identityServer == null) {
            identityServer = new IdentityServer();
            this.getContext().getServletContext().setAttribute("IDENTITY_SERVER", (Object)identityServer);
            if (StringUtil.isNotNull((String)this.idpConfiguration.getIdentityParticipantStack())) {
                try {
                    Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), this.idpConfiguration.getIdentityParticipantStack());
                    if (clazz == null) {
                        throw logger.classNotLoadedError(this.idpConfiguration.getIdentityParticipantStack());
                    }
                    identityServer.setStack((IdentityParticipantStack)clazz.newInstance());
                }
                catch (Exception e) {
                    logger.samlIDPUnableToSetParticipantStackUsingDefault((Throwable)e);
                }
            }
        }
    }

    protected void initHandlersChain() throws LifecycleException {
        try {
            if (this.picketLinkConfiguration != null) {
                this.handlers = this.picketLinkConfiguration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                this.handlers = ConfigurationUtil.getHandlers((InputStream)this.getContext().getServletContext().getResourceAsStream(handlerConfigFileName));
            }
            String handlerChainClass = this.handlers.getHandlerChainClass();
            if (StringUtil.isNullOrEmpty((String)handlerChainClass)) {
                this.chain = SAML2HandlerChainFactory.createChain();
            } else {
                try {
                    this.chain = SAML2HandlerChainFactory.createChain((String)handlerChainClass);
                }
                catch (ProcessingException e1) {
                    throw new LifecycleException((Throwable)e1);
                }
            }
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)this.handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            if (this.keyManager != null) {
                chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
                String certificateAlias = (String)this.keyManager.getAdditionalOption("X509CERTIFICATE");
                if (certificateAlias != null) {
                    chainConfigOptions.put("X509CERTIFICATE", this.keyManager.getCertificate(certificateAlias));
                }
            }
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
            }
        }
        catch (Exception e) {
            logger.samlHandlerConfigurationError((Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
    }

    protected void initKeyManager() throws LifecycleException {
        if (this.idpConfiguration.isSupportsSignature() || this.idpConfiguration.isEncrypt()) {
            KeyProviderType keyProvider;
            block5: {
                keyProvider = this.idpConfiguration.getKeyProvider();
                if (keyProvider == null) {
                    throw new LifecycleException((Throwable)logger.nullValueError("Key Provider is null for context=" + this.getContext().getName()));
                }
                try {
                    this.keyManager = CoreConfigUtil.getTrustKeyManager((KeyProviderType)keyProvider);
                    List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
                    this.keyManager.setAuthProperties(authProperties);
                    this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
                    if (authProperties == null) break block5;
                    for (AuthPropertyType authPropertyType : authProperties) {
                        String key = authPropertyType.getKey();
                        if (!"X509CERTIFICATE".equals(key)) continue;
                        this.keyManager.addAdditionalOption("X509CERTIFICATE", (Object)authPropertyType.getValue());
                        break;
                    }
                }
                catch (Exception e) {
                    logger.trustKeyManagerCreationError((Throwable)e);
                    throw new LifecycleException(e.getLocalizedMessage());
                }
            }
            logger.samlIDPSettingCanonicalizationMethod(this.idpConfiguration.getCanonicalizationMethod());
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.idpConfiguration.getCanonicalizationMethod());
            logger.trace("Key Provider=" + keyProvider.getClassName());
        }
    }

    protected void initIDPConfiguration() {
        InputStream is = null;
        if (StringUtil.isNullOrEmpty((String)this.configFile)) {
            is = this.getContext().getServletContext().getResourceAsStream("/WEB-INF/picketlink.xml");
        } else {
            try {
                is = new FileInputStream(this.configFile);
            }
            catch (FileNotFoundException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        if (this.configProvider != null) {
            try {
                if (is == null) {
                    is = this.getContext().getServletContext().getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                    if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                        ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                    }
                } else if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                    ((AbstractSAMLConfigurationProvider)this.configProvider).setConsolidatedConfigFile(is);
                }
                this.picketLinkConfiguration = this.configProvider.getPicketLinkConfiguration();
                this.idpConfiguration = this.configProvider.getIDPConfiguration();
            }
            catch (ProcessingException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
            catch (ParsingException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        if (this.idpConfiguration == null) {
            if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)is);
                    this.idpConfiguration = (IDPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    logger.trace((Throwable)e);
                    logger.samlIDPConfigurationError((Throwable)e);
                }
            }
            if (is == null) {
                is = this.getContext().getServletContext().getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw logger.configurationFileMissing("/WEB-INF/picketlink-idfed.xml");
                }
                try {
                    this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
                }
                catch (ParsingException e) {
                    logger.samlIDPConfigurationError((Throwable)e);
                }
            }
        }
        try {
            List entityDescriptors;
            String roleGeneratorAttribute;
            if (this.picketLinkConfiguration != null) {
                String sysProp;
                this.enableAudit = this.picketLinkConfiguration.isEnableAudit();
                if (!this.enableAudit && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
                    this.enableAudit = Boolean.parseBoolean(sysProp);
                }
                if (this.enableAudit && this.auditHelper == null) {
                    String securityDomainName = PicketLinkAuditHelper.getSecurityDomainName((ServletContext)this.getContext().getServletContext());
                    this.auditHelper = new PicketLinkAuditHelper(securityDomainName);
                }
            }
            logger.trace("Identity Provider URL=" + this.getIdentityURL());
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), attributeManager);
                if (clazz == null) {
                    throw new RuntimeException(logger.classNotLoadedError(attributeManager));
                }
                AttributeManager delegate = (AttributeManager)clazz.newInstance();
                this.attribManager.setDelegate(delegate);
            }
            if ((roleGeneratorAttribute = this.idpConfiguration.getRoleGenerator()) != null && !"".equals(roleGeneratorAttribute)) {
                Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), roleGeneratorAttribute);
                if (clazz == null) {
                    throw new RuntimeException(logger.classNotLoadedError(roleGeneratorAttribute));
                }
                this.roleGenerator = (RoleGenerator)clazz.newInstance();
            }
            if ((entityDescriptors = CoreConfigUtil.getMetadataConfiguration((ProviderType)this.idpConfiguration, (ServletContext)this.getContext().getServletContext())) != null) {
                for (EntityDescriptorType entityDescriptorType : entityDescriptors) {
                    SPSSODescriptorType spSSODescriptor = CoreConfigUtil.getSPDescriptor((EntityDescriptorType)entityDescriptorType);
                    if (spSSODescriptor == null) continue;
                    this.spSSOMetadataMap.put(entityDescriptorType.getEntityID(), spSSODescriptor);
                }
            }
        }
        catch (Exception e) {
            throw logger.samlIDPConfigurationError((Throwable)e);
        }
        this.initHostedURI();
    }

    protected void initSTSConfiguration() {
        if (this.picketLinkConfiguration != null && this.picketLinkConfiguration.getStsType() != null) {
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize((STSCoreConfig)new PicketLinkSTSConfiguration(this.picketLinkConfiguration.getStsType()));
        } else {
            File stsTokenConfigFile;
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            String configPath = this.getContext().getServletContext().getRealPath("/WEB-INF/picketlink-sts.xml");
            File file = stsTokenConfigFile = configPath != null ? new File(configPath) : null;
            if (stsTokenConfigFile == null || !stsTokenConfigFile.exists()) {
                logger.samlIDPInstallingDefaultSTSConfig();
                sts.installDefaultConfiguration(new String[0]);
            } else {
                sts.installDefaultConfiguration(new String[]{stsTokenConfigFile.toURI().toString()});
            }
        }
    }

    protected String getIdentityURL() {
        return this.idpConfiguration.getIdentityURL();
    }

    protected Context getContext() {
        return (Context)this.getContainer();
    }

    protected abstract String getContextPath();

    protected void recycle(Response response) {
        response.recycle();
    }

    protected String determineLoginType(boolean isSecure) {
        String auth;
        String result = JBossSAMLURIConstants.AC_PASSWORD.get();
        LoginConfig loginConfig = this.getContext().getLoginConfig();
        if (loginConfig != null && StringUtil.isNotNull((String)(auth = loginConfig.getAuthMethod()))) {
            if ("CLIENT-CERT".equals(auth)) {
                result = JBossSAMLURIConstants.AC_TLS_CLIENT.get();
            } else if (isSecure) {
                result = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
            }
        }
        return result;
    }

    protected void startPicketLink() throws LifecycleException {
        SystemPropertiesUtil.ensure();
        if (this.timerInterval > 0) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    AbstractIDPValve.this.picketLinkConfiguration = null;
                    AbstractIDPValve.this.idpConfiguration = null;
                    AbstractIDPValve.this.initIDPConfiguration();
                    try {
                        AbstractIDPValve.this.initKeyManager();
                        AbstractIDPValve.this.initHandlersChain();
                    }
                    catch (LifecycleException e) {
                        logger.trace(e.getMessage());
                    }
                }
            }, this.timerInterval, (long)this.timerInterval);
        }
        this.initIDPConfiguration();
        this.initSTSConfiguration();
        this.initKeyManager();
        this.initHandlersChain();
        this.initIdentityServer();
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
        if (this.picketLinkConfiguration == null) {
            this.picketLinkConfiguration = new PicketLinkType();
            this.picketLinkConfiguration.setIdpOrSP((ProviderType)this.idpConfiguration);
            this.picketLinkConfiguration.setHandlers(this.handlers);
        }
    }

    private SAML11AttributeStatementType createAttributeStatement(List<String> roles) {
        SAML11AttributeStatementType attrStatement = null;
        for (String role : roles) {
            if (attrStatement == null) {
                attrStatement = new SAML11AttributeStatementType();
            }
            SAML11AttributeType attr = new SAML11AttributeType("Role", URI.create("urn:picketlink:role"));
            attr.add((Object)role);
            attrStatement.add(attr);
        }
        return attrStatement;
    }

    public void setAuditHelper(PicketLinkAuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    private Boolean willIgnoreSignatureOfCurrentRequest(String spIssuer) {
        SPSSODescriptorType currentSPMetadata = this.spSSOMetadataMap.get(spIssuer);
        if (currentSPMetadata == null) {
            return false;
        }
        Boolean isRequestSigned = currentSPMetadata.isAuthnRequestsSigned();
        logger.trace("Issuer: " + spIssuer + ", isRequestSigned: " + isRequestSigned);
        if (isRequestSigned == null) {
            isRequestSigned = Boolean.FALSE;
        }
        return isRequestSigned == false;
    }

    private void initHostedURI() {
        String hostedURI = this.idpConfiguration.getHostedURI();
        if (StringUtil.isNullOrEmpty((String)hostedURI)) {
            hostedURI = "/hosted/";
        } else if (!hostedURI.contains(".") && !hostedURI.endsWith("/")) {
            hostedURI = hostedURI + "/";
        }
        this.idpConfiguration.setHostedURI(hostedURI);
    }

    private SSLAuthenticator getSSLAuthenticator() {
        if (this.sslAuthenticator == null) {
            this.sslAuthenticator = new SSLAuthenticator(){

                public Valve getNext() {
                    return new ValveBase(){

                        public void invoke(Request request, Response response) throws IOException, ServletException {
                        }
                    };
                }
            };
            this.sslAuthenticator.setContainer(this.getContainer());
            try {
                this.sslAuthenticator.start();
            }
            catch (LifecycleException e) {
                throw new RuntimeException("Error starting SSL authenticator.", e);
            }
        }
        return this.sslAuthenticator;
    }
}

