/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.realm.GenericPrincipal;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;

public class TomcatRoleGenerator
implements RoleGenerator {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public List<String> generateRoles(Principal principal) {
        String className = principal.getClass().getCanonicalName();
        if (!(principal instanceof GenericPrincipal) && !(principal instanceof User)) {
            throw logger.wrongTypeError("principal is not tomcat principal:" + className);
        }
        ArrayList<String> userRoles = new ArrayList<String>();
        if (principal instanceof GenericPrincipal) {
            GenericPrincipal gp = (GenericPrincipal)principal;
            String[] roles = gp.getRoles();
            if (roles.length > 0) {
                userRoles.addAll(Arrays.asList(roles));
            }
        } else if (principal instanceof User) {
            User tomcatUser = (User)principal;
            Iterator iter = tomcatUser.getRoles();
            while (iter.hasNext()) {
                Role tomcatRole = (Role)iter.next();
                userRoles.add(tomcatRole.getRolename());
            }
        }
        return userRoles;
    }
}

