/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.security.audit.AuditEvent;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.identity.federation.bindings.tomcat.sp.AbstractSAML11SPRedirectFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSPFormAuthenticator
extends BaseFormAuthenticator {
    protected boolean jbossEnv = false;

    public AbstractSPFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    @Override
    protected void startPicketLink() throws LifecycleException {
        super.startPicketLink();
        this.initKeyProvider(this.context);
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest, String destinationQueryStringWithSignature) throws ProcessingException, ConfigurationException, IOException {
        if (this.isHttpPostBinding()) {
            this.sendHttpPostBindingRequest(destination, samlDocument, relayState, response, willSendRequest);
        } else {
            this.sendHttpRedirectRequest(destination, samlDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature);
        }
    }

    protected void sendHttpRedirectRequest(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest, String destinationQueryStringWithSignature) throws IOException, ProcessingException, ConfigurationException {
        String destinationQueryString = null;
        if (destinationQueryStringWithSignature != null) {
            destinationQueryString = destinationQueryStringWithSignature;
        } else {
            String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMessage.getBytes("UTF-8"));
            destinationQueryString = RedirectBindingUtil.getDestinationQueryString((String)base64Request, (String)relayState, (boolean)willSendRequest);
        }
        RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
        holder.setDestination(destination).setDestinationQueryString(destinationQueryString);
        HTTPRedirectUtil.sendRedirectForRequestor((String)RedirectBindingUtil.getDestinationURL((RedirectBindingUtil.RedirectBindingUtilDestHolder)holder), (HttpServletResponse)response);
    }

    protected void sendHttpPostBindingRequest(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, IOException, ConfigurationException {
        String samlMessage = PostBindingUtil.base64Encode((String)DocumentUtil.getDocumentAsString((Document)samlDocument));
        DestinationInfoHolder destinationHolder = new DestinationInfoHolder(destination, samlMessage, relayState);
        PostBindingUtil.sendPost((DestinationInfoHolder)destinationHolder, (HttpServletResponse)response, (boolean)willSendRequest);
    }

    @Override
    protected void initKeyProvider(Context context) throws LifecycleException {
        if (!this.doSupportSignature()) {
            return;
        }
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null && this.doSupportSignature()) {
            throw new LifecycleException("PL00092: Null Value:KeyProvider is null for context=" + context.getName());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String identityURL = this.spConfiguration.getIdentityURL();
            if (authProperties != null) {
                for (AuthPropertyType authPropertyType : authProperties) {
                    String key = authPropertyType.getKey();
                    if (!"X509CERTIFICATE".equals(key)) continue;
                    this.keyManager.addAdditionalOption("X509CERTIFICATE", (Object)authPropertyType.getValue());
                    break;
                }
            }
            this.keyManager.addAdditionalOption("idp.key", (Object)new URL(identityURL).getHost());
        }
        catch (Exception e) {
            logger.trustKeyManagerCreationError((Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        logger.trace("Key Provider=" + keyProvider.getClassName());
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (response instanceof Response) {
            Response catalinaResponse = (Response)response;
            return this.authenticate(request, catalinaResponse, config);
        }
        throw logger.samlSPResponseNotCatalinaResponseError((Object)response);
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        try {
            String characterEncoding = this.getCharacterEncoding();
            if (characterEncoding != null) {
                request.setCharacterEncoding(characterEncoding);
            }
            Session session = request.getSessionInternal(true);
            if (this.saveRestoreRequest && this.matchRequest(request)) {
                logger.trace("Restoring request from session '" + session.getIdInternal() + "'");
                Principal savedPrincipal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
                this.register(request, response, savedPrincipal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
                if (this.restoreRequest(request, session)) {
                    logger.trace("Continuing with restored request.");
                    return true;
                }
                logger.trace("Restore of original request failed!");
                response.sendError(400);
                return false;
            }
            boolean localLogout = this.isLocalLogout(request);
            if (localLogout) {
                try {
                    this.sendToLogoutPage(request, response, session);
                }
                catch (ServletException e) {
                    logger.samlLogoutError((Throwable)e);
                    throw new IOException(e);
                }
                return false;
            }
            String samlRequest = request.getParameter("SAMLRequest");
            String samlResponse = request.getParameter("SAMLResponse");
            Principal principal = request.getUserPrincipal();
            if (!(principal == null || this.isGlobalLogout(request) || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
                return true;
            }
            if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
                return this.generalUserRequest(request, response, loginConfig);
            }
            if (StringUtil.isNotNull((String)samlResponse)) {
                return this.handleSAMLResponse(request, response, loginConfig);
            }
            if (StringUtil.isNotNull((String)samlRequest)) {
                return this.handleSAMLRequest(request, response, loginConfig);
            }
            return this.localAuthentication(request, response, loginConfig);
        }
        catch (IOException e) {
            if (StringUtil.isNotNull((String)this.spConfiguration.getErrorPage())) {
                try {
                    request.getRequestDispatcher(this.spConfiguration.getErrorPage()).forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                }
                catch (ServletException e1) {
                    logger.samlErrorPageForwardError(this.spConfiguration.getErrorPage(), (Throwable)e1);
                }
                return false;
            }
            throw e;
        }
    }

    private boolean isGlobalLogout(Request request) {
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    private boolean isLocalLogout(Request request) {
        String lloStr = request.getParameter("LLO");
        return StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
    }

    private boolean handleSAMLRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration);
            requestProcessor.setTrustKeyManager(this.keyManager);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.REQUEST_FROM_IDP);
                auditEvent.setWhoIsAuditing(this.getContextPath());
                this.auditHelper.audit((AuditEvent)auditEvent);
            }
            if (response.isCommitted() || response.isAppCommitted()) {
                return false;
            }
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    private Document toSAMLResponseDocument(String samlResponse, boolean isPostBinding) throws ParsingException {
        InputStream dataStream = null;
        dataStream = isPostBinding ? PostBindingUtil.base64DecodeAsStream((String)samlResponse) : RedirectBindingUtil.base64DeflateDecode((String)samlResponse);
        try {
            return DocumentUtil.getDocument((InputStream)dataStream);
        }
        catch (Exception e) {
            logger.samlResponseFromIDPParsingFailed();
            throw new ParsingException("", (Throwable)e);
        }
    }

    private boolean handleSAMLResponse(Request request, Response response, LoginConfig loginConfig) throws IOException {
        if (!super.validate(request)) {
            throw new IOException("PL00019: Validation check failed");
        }
        String samlVersion = this.getSAMLVersion(request);
        if (!JBossSAMLConstants.VERSION_2_0.get().equals(samlVersion)) {
            return AbstractSAML11SPRedirectFormAuthenticator.handleSAML11UnsolicitedResponse(request, response, loginConfig, this);
        }
        return this.handleSAML2Response(request, response, loginConfig);
    }

    private boolean handleSAML2Response(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        String samlResponse = request.getParameter("SAMLResponse");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        Principal principal = request.getUserPrincipal();
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration);
            if (this.auditHelper != null) {
                responseProcessor.setAuditHelper(this.auditHelper);
            }
            responseProcessor.setTrustKeyManager(this.keyManager);
            SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            String relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            boolean willSendRequest = saml2HandlerResponse.getSendRequest();
            String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity = session.isValid();
                if (!sessionValidity) {
                    this.sendToLogoutPage(request, response, session);
                    return false;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getSession().getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = "EMPTY_STR";
                if (logger.isTraceEnabled()) {
                    logger.trace("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray()));
                }
                if (new ServerDetector().isJboss() || this.jbossEnv) {
                    ServiceProviderSAMLContext.push(username, roles);
                    principal = this.context.getRealm().authenticate(username, password);
                    ServiceProviderSAMLContext.clear();
                } else {
                    principal = this.getGenericPrincipal(request, username, roles);
                }
                if (principal == null) {
                    throw new RuntimeException("PL00092: Null Value: principal");
                }
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                request.setUserPrincipal(principal);
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_FROM_IDP);
                    auditEvent.setSubjectName(username);
                    auditEvent.setWhoIsAuditing(this.getContextPath());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                if (this.saveRestoreRequest) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                    String requestURI = this.savedRequestURL(session);
                    if (requestURI != null) {
                        logger.trace("Redirecting back to original Request URI: " + requestURI);
                        response.sendRedirect(response.encodeRedirectURL(requestURI));
                    }
                }
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature);
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                logger.error("Assertion has expired. Asking IDP for reissue");
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.EXPIRED_ASSERTION);
                    auditEvent.setAssertionID(((AssertionExpiredException)t).getId());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                return this.generalUserRequest(request, response, loginConfig);
            }
            logger.samlSPHandleRequestError((Throwable)pe);
            throw logger.samlSPProcessingExceptionError((Throwable)pe);
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    private String getSAMLVersion(Request request) {
        String version;
        String samlResponse = request.getParameter("SAMLResponse");
        try {
            Document samlDocument = this.toSAMLResponseDocument(samlResponse, "POST".equalsIgnoreCase(request.getMethod()));
            Element element = samlDocument.getDocumentElement();
            version = element.getAttribute("Version");
            if (StringUtil.isNullOrEmpty((String)version)) {
                String minorVersion = element.getAttribute("MinorVersion");
                String majorVersion = element.getAttribute("MajorVersion");
                version = minorVersion + "." + majorVersion;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract version from SAML Response.", e);
        }
        return version;
    }

    protected boolean isPOSTBindingResponse() {
        return this.spConfiguration.isIdpUsesPostBinding();
    }

    @Override
    protected String getBinding() {
        return this.spConfiguration.getBindingType();
    }

    private boolean generalUserRequest(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Session session = request.getSessionInternal(true);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        boolean postBinding = this.spConfiguration.getBindingType().equals("POST");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            String idp;
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(postBinding, this.serviceURL, this.picketLinkConfiguration);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            if (StringUtil.isNotNull((String)(idp = (String)request.getAttribute("picketlink.desired.idp")))) {
                baseProcessor.setIdentityURL(idp);
            } else {
                baseProcessor.setIdentityURL(this.identityURL);
            }
            baseProcessor.setAuditHelper(this.auditHelper);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        String relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.saveRestoreRequest && !this.isGlobalLogout(request)) {
                    this.saveRequest(request, session);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.REQUEST_TO_IDP);
                    auditEvent.setWhoIsAuditing(this.getContextPath());
                    this.auditHelper.audit((AuditEvent)auditEvent);
                }
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature);
                return false;
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw logger.samlSPProcessingExceptionError((Throwable)e);
            }
        }
        return this.localAuthentication(request, response, loginConfig);
    }

    protected boolean isHttpPostBinding() {
        return this.getBinding().equalsIgnoreCase("POST");
    }

    public Context getContext() {
        return (Context)this.getContainer();
    }

    public boolean restoreRequest(Request request, Session session) throws IOException {
        return super.restoreRequest(request, session);
    }

    protected abstract String getContextPath();

    protected Principal getGenericPrincipal(Request request, String username, List<String> roles) {
        return new SPUtil().createGenericPrincipal(request, username, roles);
    }
}

