/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.listeners;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;

public class IDPHttpSessionListener
implements HttpSessionListener {
    private static Logger log = Logger.getLogger(IDPHttpSessionListener.class);
    private final boolean trace = log.isTraceEnabled();

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession httpSession = se.getSession();
        if (httpSession == null) {
            throw new RuntimeException("PL00078: Null Parameter::session");
        }
        AssertionType assertion = (AssertionType)httpSession.getAttribute("ASSERTION");
        if (assertion != null) {
            if (this.trace) {
                log.trace((Object)"User has closed the browser. So we proceed to cancel the STS issued token.");
            }
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
            samlProtocolContext.setIssuedAssertion(assertion);
            try {
                sts.cancelToken((ProtocolContext)samlProtocolContext);
            }
            catch (ProcessingException e) {
                log.error((Object)"PL00102: Processing Exception:", (Throwable)e);
            }
            httpSession.removeAttribute("ASSERTION");
        }
    }
}

