/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.roles;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.roles.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRoleGenerator
implements RoleGenerator {
    private static Properties props = new Properties();

    static {
        try {
            URL url = SecurityActions.loadResource(DefaultRoleGenerator.class, "roles.properties");
            if (url == null) {
                throw new RuntimeException("PL00018: Resource not found:roles.properties not found");
            }
            props.load(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> generateRoles(Principal principal) {
        ArrayList<String> roles = new ArrayList<String>();
        String csv = (String)props.get(principal.getName());
        if (StringUtil.isNotNull((String)csv)) {
            roles.addAll(StringUtil.tokenize((String)csv));
        }
        return roles;
    }
}

