/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script;

import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;
import org.picocontainer.script.ContainerBuilder;
import org.picocontainer.script.LifecycleMode;

public abstract class AbstractContainerBuilder
implements ContainerBuilder {
    private final LifecycleMode startMode;

    public AbstractContainerBuilder() {
        this(LifecycleMode.AUTO_LIFECYCLE);
    }

    public AbstractContainerBuilder(LifecycleMode startMode) {
        this.startMode = startMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PicoContainer buildContainer(PicoContainer parentContainer, Object assemblyScope, boolean addChildToParent) {
        PicoContainer container = this.createContainer(parentContainer, assemblyScope);
        if (parentContainer != null && parentContainer instanceof MutablePicoContainer) {
            MutablePicoContainer mutableParentContainer = (MutablePicoContainer)parentContainer;
            if (addChildToParent) {
                MutablePicoContainer mutablePicoContainer = mutableParentContainer;
                synchronized (mutablePicoContainer) {
                    mutableParentContainer.addChildContainer(container);
                }
            }
        }
        this.autoStart(container);
        return container;
    }

    protected void autoStart(PicoContainer container) {
        if (!this.startMode.isInvokeLifecycle()) {
            return;
        }
        if (container instanceof Startable) {
            ((Startable)container).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killContainer(PicoContainer container) {
        PicoContainer parent;
        if (this.startMode.isInvokeLifecycle() && container instanceof Startable) {
            ((Startable)container).stop();
        }
        if (container instanceof Disposable) {
            ((Disposable)container).dispose();
        }
        if ((parent = container.getParent()) != null && parent instanceof MutablePicoContainer) {
            PicoContainer picoContainer = parent;
            synchronized (picoContainer) {
                ((MutablePicoContainer)parent).removeChildContainer(container);
            }
        }
    }

    protected abstract PicoContainer createContainer(PicoContainer var1, Object var2);
}

