/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.InjectionFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoBuilder;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoContainer;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.containers.TransientPicoContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptedBuilder {
    private Class<? extends ClassLoadingPicoContainer> scriptClass = DefaultClassLoadingPicoContainer.class;
    private final PicoBuilder picoBuilder;
    private ClassLoader classLoader = DefaultClassLoadingPicoContainer.class.getClassLoader();
    private List<URL> urls = new ArrayList<URL>();

    public ScriptedBuilder(PicoContainer parentcontainer, InjectionFactory injectionType) {
        this.picoBuilder = new PicoBuilder(parentcontainer, injectionType);
    }

    public ScriptedBuilder(PicoContainer parentcontainer) {
        this.picoBuilder = new PicoBuilder(parentcontainer);
    }

    public ScriptedBuilder(InjectionFactory injectionType) {
        this.picoBuilder = new PicoBuilder(injectionType);
    }

    public ScriptedBuilder() {
        this.picoBuilder = new PicoBuilder();
    }

    public ClassLoadingPicoContainer build() {
        TransientPicoContainer tpc = new TransientPicoContainer();
        tpc.addComponent(ClassLoader.class, (Object)this.classLoader, new Parameter[0]);
        tpc.addComponent((Object)"sc", this.scriptClass, new Parameter[0]);
        tpc.addComponent(MutablePicoContainer.class, (Object)this.picoBuilder.build(), new Parameter[0]);
        ClassLoadingPicoContainer pico = (ClassLoadingPicoContainer)tpc.getComponent((Object)"sc");
        for (URL url : this.urls) {
            pico.addClassLoaderURL(url);
        }
        return pico;
    }

    public ScriptedBuilder withConsoleMonitor() {
        this.picoBuilder.withConsoleMonitor();
        return this;
    }

    public ScriptedBuilder withLifecycle() {
        this.picoBuilder.withLifecycle();
        return this;
    }

    public ScriptedBuilder withReflectionLifecycle() {
        this.picoBuilder.withReflectionLifecycle();
        return this;
    }

    public ScriptedBuilder withMonitor(Class<? extends ComponentMonitor> clazz) {
        this.picoBuilder.withMonitor(clazz);
        return this;
    }

    public ScriptedBuilder withHiddenImplementations() {
        this.picoBuilder.withHiddenImplementations();
        return this;
    }

    public ScriptedBuilder withComponentFactory(ComponentFactory componentFactory) {
        this.picoBuilder.withComponentFactory(componentFactory);
        return this;
    }

    public ScriptedBuilder withBehaviors(BehaviorFactory ... factories) {
        this.picoBuilder.withBehaviors(factories);
        return this;
    }

    public ScriptedBuilder withSetterInjection() {
        this.picoBuilder.withSetterInjection();
        return this;
    }

    public ScriptedBuilder withAnnotatedMethodInjection() {
        this.picoBuilder.withAnnotatedMethodInjection();
        return this;
    }

    public ScriptedBuilder withConstructorInjection() {
        this.picoBuilder.withConstructorInjection();
        return this;
    }

    public ScriptedBuilder withCaching() {
        this.picoBuilder.withCaching();
        return this;
    }

    public ScriptedBuilder withSynchronizing() {
        this.picoBuilder.withSynchronizing();
        return this;
    }

    public ScriptedBuilder implementedBy(Class<? extends ClassLoadingPicoContainer> scriptedContainerClass) {
        this.scriptClass = scriptedContainerClass;
        return this;
    }

    public ScriptedBuilder implementedBy(String scriptedContainerClass) {
        this.scriptClass = this.loadClass(scriptedContainerClass, ClassLoadingPicoContainer.class);
        return this;
    }

    public ScriptedBuilder picoImplementedBy(Class<? extends MutablePicoContainer> picoContainerClass) {
        this.picoBuilder.implementedBy(picoContainerClass);
        return this;
    }

    public ScriptedBuilder withClassLoader(ClassLoader usingClassloader) {
        this.classLoader = usingClassloader;
        return this;
    }

    public ScriptedBuilder withComponentFactory(String componentFactoryName) {
        if (componentFactoryName != null && !componentFactoryName.equals("")) {
            this.picoBuilder.withComponentFactory(this.loadClass(componentFactoryName, ComponentFactory.class));
        }
        return this;
    }

    private <T> Class<? extends T> loadClass(String className, Class<T> asClass) {
        try {
            return this.classLoader.loadClass(className).asSubclass(asClass);
        }
        catch (ClassNotFoundException e) {
            throw new PicoClassNotFoundException(className, e);
        }
    }

    public ScriptedBuilder withMonitor(String monitorName) {
        if (monitorName != null && !monitorName.equals("")) {
            this.picoBuilder.withMonitor(this.loadClass(monitorName, ComponentMonitor.class));
        }
        return this;
    }

    public ScriptedBuilder addClassLoaderURL(URL url) {
        this.urls.add(url);
        return this;
    }
}

