/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.xml;

import java.util.Map;
import java.util.Properties;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.PropertyApplicator;
import org.picocontainer.injectors.AdaptingInjection;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.script.xml.XMLComponentInstanceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanComponentInstanceFactory
implements XMLComponentInstanceFactory {
    private static final String NAME_ATTRIBUTE = "name";

    @Override
    public Object makeInstance(PicoContainer pico, Element element, ClassLoader classLoader) {
        Object instance;
        String className = element.getNodeName();
        if (element.getChildNodes().getLength() == 1) {
            instance = PropertyApplicator.convert((String)className, (String)element.getFirstChild().getNodeValue(), (ClassLoader)classLoader);
        } else {
            PropertyApplicator propertyAdapter = new PropertyApplicator(this.createComponentAdapter(className, classLoader));
            Properties properties = this.createProperties(element.getChildNodes());
            propertyAdapter.setProperties((Map)properties);
            instance = propertyAdapter.getComponentInstance(pico, ComponentAdapter.NOTHING.class);
        }
        return instance;
    }

    private ComponentAdapter createComponentAdapter(String className, ClassLoader classLoader) {
        Class<?> implementation = this.loadClass(classLoader, className);
        AdaptingInjection factory = new AdaptingInjection();
        return factory.createComponentAdapter((ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), new Properties(), (Object)className, implementation, new Parameter[0]);
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new PicoClassNotFoundException(className, e);
        }
    }

    private Properties createProperties(NodeList nodes) {
        Properties properties = new Properties();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String mappedName;
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getNodeName();
            if (n.hasAttributes() && (mappedName = n.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue()) != null) {
                name = mappedName;
            }
            String value = n.getFirstChild().getNodeValue();
            properties.setProperty(name, value);
        }
        return properties;
    }
}

