/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.picocontainer.BehaviorFactory;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.ClassName;
import org.picocontainer.classname.ClassPathElement;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.gems.jndi.JNDIObjectReference;
import org.picocontainer.gems.jndi.JNDIProvided;
import org.picocontainer.injectors.AbstractInjectionFactory;
import org.picocontainer.injectors.ConstructorInjection;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.lifecycle.NullLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.script.LifecycleMode;
import org.picocontainer.script.ScriptedBuilder;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.xml.AttributeUtils;
import org.picocontainer.script.xml.BeanComponentInstanceFactory;
import org.picocontainer.script.xml.ContainerOptions;
import org.picocontainer.script.xml.XMLComponentInstanceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLContainerBuilder
extends ScriptedContainerBuilder {
    private static final String DEFAULT_COMPONENT_INSTANCE_FACTORY = BeanComponentInstanceFactory.class.getName();
    private Element rootElement;
    private XMLComponentInstanceFactory componentInstanceFactory;

    public XMLContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public XMLContainerBuilder(Reader script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parse(documentBuilder, new InputSource(script));
        }
        catch (ParserConfigurationException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    public XMLContainerBuilder(URL script, ClassLoader classLoader) {
        this(script, classLoader, LifecycleMode.AUTO_LIFECYCLE);
    }

    public XMLContainerBuilder(final URL script, ClassLoader classLoader, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws IOException {
                    URL url = new URL(script, systemId);
                    return new InputSource(url.openStream());
                }
            });
            this.parse(documentBuilder, new InputSource(script.toString()));
        }
        catch (ParserConfigurationException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    private void parse(DocumentBuilder documentBuilder, InputSource inputSource) {
        try {
            this.rootElement = documentBuilder.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        try {
            this.componentInstanceFactory = this.createComponentInstanceFactory(this.rootElement.getAttribute("component-instance-factory"));
            MutablePicoContainer childContainer = this.createMutablePicoContainer(parentContainer, new ContainerOptions(this.rootElement));
            this.populateContainer(childContainer);
            return childContainer;
        }
        catch (PicoClassNotFoundException e) {
            throw new ScriptedPicoContainerMarkupException("Class not found:" + e.getMessage(), e);
        }
    }

    private MutablePicoContainer createMutablePicoContainer(PicoContainer parentContainer, ContainerOptions containerOptions) throws PicoCompositionException {
        boolean caching = containerOptions.isCaching();
        boolean inherit = containerOptions.isInheritParentBehaviors();
        String monitorName = containerOptions.getMonitorName();
        String componentFactoryName = containerOptions.getComponentFactoryName();
        if (inherit) {
            if (!(parentContainer instanceof MutablePicoContainer)) {
                throw new PicoCompositionException("For behavior inheritance to be used, the parent picocontainer must be of type MutablePicoContainer");
            }
            MutablePicoContainer parentPico = (MutablePicoContainer)parentContainer;
            return parentPico.makeChildContainer();
        }
        ScriptedBuilder builder = new ScriptedBuilder(parentContainer);
        if (caching) {
            builder.withCaching();
        }
        return builder.withClassLoader(this.getClassLoader()).withLifecycle().withComponentFactory(componentFactoryName).withMonitor(monitorName).build();
    }

    public void populateContainer(MutablePicoContainer container) {
        try {
            String parentClass = this.rootElement.getAttribute("parentclassloader");
            ClassLoader classLoader = this.getClassLoader();
            if (parentClass != null && !"".equals(parentClass)) {
                classLoader = classLoader.loadClass(parentClass).getClassLoader();
            }
            DefaultClassLoadingPicoContainer scriptedContainer = new DefaultClassLoadingPicoContainer(classLoader, container);
            DefaultClassLoadingPicoContainer classLoadingPicoContainer = new DefaultClassLoadingPicoContainer(this.getClassLoader());
            this.addComponentsAndChildContainers((ClassLoadingPicoContainer)scriptedContainer, this.rootElement, (ClassLoadingPicoContainer)classLoadingPicoContainer);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptedPicoContainerMarkupException("Class not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (SAXException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (NamingException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    private void addComponentsAndChildContainers(ClassLoadingPicoContainer parentContainer, Element containerElement, ClassLoadingPicoContainer knownComponentAdapterFactories) throws ClassNotFoundException, IOException, SAXException, NamingException {
        Element childElement;
        String name;
        int i;
        DefaultClassLoadingPicoContainer metaContainer = new DefaultClassLoadingPicoContainer(this.getClassLoader(), (ComponentFactory)new CompFactoryWrappingComponentFactory(), (PicoContainer)knownComponentAdapterFactories);
        NodeList children = containerElement.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !"classpath".equals(name = (childElement = (Element)children.item(i)).getNodeName())) continue;
            this.addClasspath(parentContainer, childElement);
        }
        for (i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            childElement = (Element)children.item(i);
            name = childElement.getNodeName();
            if ("container".equals(name)) {
                MutablePicoContainer childContainer = parentContainer.makeChildContainer();
                DefaultClassLoadingPicoContainer childPicoContainer = new DefaultClassLoadingPicoContainer(parentContainer.getComponentClassLoader(), childContainer);
                this.addComponentsAndChildContainers((ClassLoadingPicoContainer)childPicoContainer, childElement, (ClassLoadingPicoContainer)metaContainer);
                continue;
            }
            if ("component-implementation".equals(name) || "component".equals(name)) {
                this.addComponent(parentContainer, childElement, new Properties[0]);
                continue;
            }
            if ("component-instance".equals(name)) {
                this.registerComponentInstance(parentContainer, childElement);
                continue;
            }
            if ("component-from-jndi".equals(name)) {
                this.registerComponentFromJndi(parentContainer, childElement);
                continue;
            }
            if ("component-adapter".equals(name)) {
                this.addComponentAdapter(parentContainer, childElement, (ClassLoadingPicoContainer)metaContainer);
                continue;
            }
            if ("component-adapter-factory".equals(name)) {
                this.addComponentFactory(childElement, (ClassLoadingPicoContainer)metaContainer);
                continue;
            }
            if ("classloader".equals(name)) {
                this.addClassLoader(parentContainer, childElement, (ClassLoadingPicoContainer)metaContainer);
                continue;
            }
            if ("classpath".equals(name)) continue;
            throw new ScriptedPicoContainerMarkupException("Unsupported element:" + name);
        }
    }

    private void addComponentFactory(Element element, ClassLoadingPicoContainer metaContainer) throws MalformedURLException, ClassNotFoundException {
        if (AttributeUtils.notSet(element.getAttribute("key"))) {
            throw new ScriptedPicoContainerMarkupException("'key' attribute not specified for " + element.getNodeName());
        }
        Element node = (Element)element.cloneNode(false);
        NodeList children = element.getChildNodes();
        String key = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String name = childElement.getNodeName();
            if ("component-adapter-factory".equals(name)) {
                if (!"".equals(childElement.getAttribute("key"))) {
                    throw new ScriptedPicoContainerMarkupException("'key' attribute must not be specified for nested " + element.getNodeName());
                }
                childElement = (Element)childElement.cloneNode(true);
                key = "ContrivedKey:" + String.valueOf(System.identityHashCode(childElement));
                childElement.setAttribute("key", key);
                this.addComponentFactory(childElement, metaContainer);
                continue;
            }
            if (!"parameter".equals(name)) continue;
            node.appendChild(childElement.cloneNode(true));
        }
        if (key != null) {
            this.addComponent(metaContainer, node, new ForCaf(key));
        } else {
            this.addComponent(metaContainer, node, new ForCaf[0]);
        }
    }

    private void addClassLoader(ClassLoadingPicoContainer parentContainer, Element childElement, ClassLoadingPicoContainer metaContainer) throws IOException, SAXException, ClassNotFoundException, NamingException {
        String parentClass = childElement.getAttribute("parentclassloader");
        ClassLoader parentClassLoader = parentContainer.getComponentClassLoader();
        if (parentClass != null && !"".equals(parentClass)) {
            parentClassLoader = parentClassLoader.loadClass(parentClass).getClassLoader();
        }
        DefaultClassLoadingPicoContainer scripted = new DefaultClassLoadingPicoContainer(parentClassLoader, (MutablePicoContainer)parentContainer);
        this.addComponentsAndChildContainers((ClassLoadingPicoContainer)scripted, childElement, metaContainer);
    }

    private void addClasspath(ClassLoadingPicoContainer container, Element classpathElement) throws IOException, ClassNotFoundException {
        NodeList children = classpathElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            URL url;
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String fileName = childElement.getAttribute("file");
            String urlSpec = childElement.getAttribute("url");
            if (urlSpec != null && !"".equals(urlSpec)) {
                url = new URL(urlSpec);
            } else {
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException(file.getAbsolutePath() + " doesn't exist");
                }
                url = file.toURL();
            }
            ClassPathElement cpe = container.addClassLoaderURL(url);
            this.addPermissions(cpe, childElement);
        }
    }

    private void addPermissions(ClassPathElement classPathElement, Element classPathXmlElement) throws ClassNotFoundException {
        NodeList children = classPathXmlElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            String permissionClassName = childElement.getAttribute("classname");
            String action = childElement.getAttribute("context");
            String value = childElement.getAttribute("value");
            DefaultPicoContainer mpc = new DefaultPicoContainer();
            mpc.addComponent(Permission.class, Class.forName(permissionClassName), new Parameter[]{new ConstantParameter((Object)action), new ConstantParameter((Object)value)});
            Permission permission = (Permission)mpc.getComponent(Permission.class);
            classPathElement.grantPermission(permission);
        }
    }

    private void addComponent(ClassLoadingPicoContainer container, Element element, Properties ... props) throws ClassNotFoundException, MalformedURLException {
        String className = element.getAttribute("class");
        if (AttributeUtils.notSet(className)) {
            throw new ScriptedPicoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Parameter[] parameters = this.createChildParameters(container, element);
        Class<?> clazz = container.getComponentClassLoader().loadClass(className);
        Object key = element.getAttribute("key");
        if (AttributeUtils.notSet(key)) {
            String classKey = element.getAttribute("class-name-key");
            key = AttributeUtils.isSet(classKey) ? this.getClassLoader().loadClass(classKey) : clazz;
        }
        if (parameters == null) {
            container.addComponent(key, clazz, new Parameter[0]);
        } else {
            container.as(props).addComponent(key, clazz, parameters);
        }
    }

    private Parameter[] createChildParameters(ClassLoadingPicoContainer container, Element element) throws ClassNotFoundException, MalformedURLException {
        ArrayList<Parameter> parametersList = new ArrayList<Parameter>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element childElement = (Element)children.item(i);
            if ("parameter".equals(childElement.getNodeName())) {
                parametersList.add(this.createParameter((PicoContainer)container, childElement));
            }
            if (!"parameter-zero".equals(childElement.getNodeName())) continue;
            if (!parametersList.isEmpty()) {
                throw new PicoCompositionException("Cannot mix other parameters with 'parameter-zero' nodes.");
            }
            return Parameter.ZERO;
        }
        Parameter[] parameters = null;
        if (!parametersList.isEmpty()) {
            parameters = parametersList.toArray(new Parameter[parametersList.size()]);
        }
        return parameters;
    }

    private Parameter createParameter(PicoContainer pico, Element element) throws ClassNotFoundException, MalformedURLException {
        ComponentParameter parameter;
        String key = element.getAttribute("key");
        String emptyCollectionString = element.getAttribute("empty-collection");
        String componentValueTypeString = element.getAttribute("component-value-type");
        String componentKeyTypeString = element.getAttribute("component-key-type");
        if (key != null && !"".equals(key)) {
            parameter = new ComponentParameter((Object)key);
        } else if (componentKeyTypeString != null && !"".equals(componentKeyTypeString)) {
            if (emptyCollectionString == null || componentValueTypeString == null || "".equals(emptyCollectionString) || "".equals(componentValueTypeString)) {
                throw new ScriptedPicoContainerMarkupException("The componentKeyType attribute was specified (" + componentKeyTypeString + ") but one or both of the emptyCollection (" + emptyCollectionString + ") or componentValueType (" + componentValueTypeString + ") was empty or null.");
            }
            Class<?> componentKeyType = this.getClassLoader().loadClass(componentKeyTypeString);
            Class<?> componentValueType = this.getClassLoader().loadClass(componentValueTypeString);
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(componentKeyType, componentValueType, emptyCollection);
        } else if (componentValueTypeString != null && !"".equals(componentValueTypeString)) {
            if (emptyCollectionString == null || "".equals(emptyCollectionString)) {
                throw new ScriptedPicoContainerMarkupException("The componentValueType attribute was specified (" + componentValueTypeString + ") but the emptyCollection (" + emptyCollectionString + ") was empty or null.");
            }
            Class<?> componentValueType = this.getClassLoader().loadClass(componentValueTypeString);
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(componentValueType, emptyCollection);
        } else if (emptyCollectionString != null && !"".equals(emptyCollectionString)) {
            boolean emptyCollection = Boolean.valueOf(emptyCollectionString);
            parameter = new ComponentParameter(emptyCollection);
        } else if (this.getFirstChildElement(element, false) == null) {
            parameter = new ComponentParameter();
        } else {
            Object instance = this.createInstance(pico, element);
            parameter = new ConstantParameter(instance);
        }
        return parameter;
    }

    private void registerComponentFromJndi(ClassLoadingPicoContainer container, Element element) throws ClassNotFoundException, PicoCompositionException, MalformedURLException, NamingException {
        String key = element.getAttribute("key");
        String classKey = element.getAttribute("class");
        String jndiName = element.getAttribute("jndi-name");
        if (AttributeUtils.notSet(key)) {
            // empty if block
        }
        container.addAdapter((ComponentAdapter)new JNDIProvided((Object)key, new JNDIObjectReference(jndiName), this.getClassLoader().loadClass(classKey)));
    }

    private void registerComponentInstance(ClassLoadingPicoContainer container, Element element) throws ClassNotFoundException, PicoCompositionException, MalformedURLException {
        Object instance = this.createInstance((PicoContainer)container, element);
        String key = element.getAttribute("key");
        String classKey = element.getAttribute("class-name-key");
        if (AttributeUtils.notSet(key)) {
            if (!AttributeUtils.notSet(classKey)) {
                container.addComponent(this.getClassLoader().loadClass(classKey), instance, new Parameter[0]);
            } else {
                container.addComponent(instance);
            }
        } else {
            container.addComponent((Object)key, instance, new Parameter[0]);
        }
    }

    private Object createInstance(PicoContainer pico, Element element) throws MalformedURLException {
        XMLComponentInstanceFactory factory = this.createComponentInstanceFactory(element.getAttribute("factory"));
        Element instanceElement = this.getFirstChildElement(element, true);
        return factory.makeInstance(pico, instanceElement, this.getClassLoader());
    }

    private Element getFirstChildElement(Element parent, boolean fail) {
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            child = (Element)children.item(i);
            break;
        }
        if (child == null && fail) {
            throw new ScriptedPicoContainerMarkupException(parent.getNodeName() + " needs a child element");
        }
        return child;
    }

    private XMLComponentInstanceFactory createComponentInstanceFactory(String factoryClass) {
        if (AttributeUtils.notSet(factoryClass)) {
            if (this.componentInstanceFactory != null) {
                return this.componentInstanceFactory;
            }
            factoryClass = DEFAULT_COMPONENT_INSTANCE_FACTORY;
        }
        try {
            return (XMLComponentInstanceFactory)this.getClassLoader().loadClass(factoryClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new PicoCompositionException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PicoCompositionException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PicoClassNotFoundException(factoryClass, e);
        }
    }

    private void addComponentAdapter(ClassLoadingPicoContainer container, Element element, ClassLoadingPicoContainer metaContainer) throws ClassNotFoundException, PicoCompositionException, MalformedURLException {
        String className = element.getAttribute("class");
        if (AttributeUtils.notSet(className)) {
            throw new ScriptedPicoContainerMarkupException("'class' attribute not specified for " + element.getNodeName());
        }
        Class<?> implementationClass = this.getClassLoader().loadClass(className);
        Class<?> key = element.getAttribute("key");
        String classKey = element.getAttribute("class-name-key");
        if (AttributeUtils.notSet(key)) {
            key = !AttributeUtils.notSet(classKey) ? this.getClassLoader().loadClass(classKey) : implementationClass;
        }
        Parameter[] parameters = this.createChildParameters(container, element);
        ComponentFactory componentFactory = this.createComponentFactory(element.getAttribute("factory"), metaContainer);
        container.as(new Properties[]{Characteristics.NONE}).addAdapter(componentFactory.createComponentAdapter((ComponentMonitor)new NullComponentMonitor(), (LifecycleStrategy)new NullLifecycleStrategy(), new Properties(), key, implementationClass, parameters));
    }

    private ComponentFactory createComponentFactory(String factoryName, ClassLoadingPicoContainer metaContainer) throws PicoCompositionException {
        Object key;
        if (AttributeUtils.notSet(factoryName)) {
            return new Caching().wrap((ComponentFactory)new ConstructorInjection());
        }
        if (metaContainer.getComponentAdapter((Object)factoryName) != null) {
            key = factoryName;
        } else {
            metaContainer.addComponent(ComponentFactory.class, (Object)new ClassName(factoryName), new Parameter[0]);
            key = ComponentFactory.class;
        }
        return (ComponentFactory)metaContainer.getComponent(key);
    }

    private static class MySingleMemberInjector
    extends SingleMemberInjector {
        private final String otherKey;
        private final Injector injector;

        private MySingleMemberInjector(Object key, Class impl, Parameter[] parms, ComponentMonitor monitor, boolean useNames, String otherKey, Injector injector) {
            super(key, impl, parms, monitor, useNames);
            this.otherKey = otherKey;
            this.injector = injector;
        }

        public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            BehaviorFactory bf = (BehaviorFactory)this.injector.getComponentInstance(container, into);
            bf.wrap((ComponentFactory)container.getComponent((Object)this.otherKey));
            return bf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompFactoryWrappingComponentFactory
    extends AbstractInjectionFactory {
        ConstructorInjection constructorInjection = new ConstructorInjection();

        public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor monitor, LifecycleStrategy lifecycle, Properties props, Object key, Class<T> impl, Parameter ... parms) throws PicoCompositionException {
            ComponentAdapter adapter = this.constructorInjection.createComponentAdapter(monitor, lifecycle, props, key, impl, parms);
            String otherKey = props.getProperty("ForCAF");
            if (otherKey != null && !otherKey.equals("")) {
                props.remove("ForCAF");
                return new MySingleMemberInjector(key, impl, parms, monitor, false, otherKey, (Injector)adapter);
            }
            return adapter;
        }
    }

    public class ForCaf
    extends Properties {
        public ForCaf(String key) {
            super.put("ForCAF", key);
        }
    }
}

