/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;
import org.picocontainer.script.LifecycleMode;
import org.picocontainer.script.ScriptedBuilder;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.ScriptedPicoContainerMarkupException;
import org.picocontainer.script.xml.ContainerOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XStreamContainerBuilder
extends ScriptedContainerBuilder {
    private final Element rootElement;
    private static final String IMPLEMENTATION = "implementation";
    private static final String INSTANCE = "instance";
    private static final String ADAPTER = "adapter";
    private static final String CLASS = "class";
    private static final String KEY = "key";
    private static final String CONSTANT = "constant";
    private static final String DEPENDENCY = "dependency";
    private static final String CONSTRUCTOR = "constructor";
    private final HierarchicalStreamDriver xsdriver;

    public XStreamContainerBuilder(Reader script) {
        this(script, Thread.currentThread().getContextClassLoader());
    }

    public XStreamContainerBuilder(Reader script, ClassLoader classLoader) {
        this(script, classLoader, (HierarchicalStreamDriver)new DomDriver());
    }

    public XStreamContainerBuilder(Reader script, ClassLoader classLoader, HierarchicalStreamDriver driver) {
        this(script, classLoader, driver, LifecycleMode.AUTO_LIFECYCLE);
    }

    public XStreamContainerBuilder(Reader script, ClassLoader classLoader, HierarchicalStreamDriver driver, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        this.xsdriver = driver;
        InputSource inputSource = new InputSource(script);
        try {
            this.rootElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    public XStreamContainerBuilder(URL script, ClassLoader classLoader, HierarchicalStreamDriver driver) {
        this(script, classLoader, driver, LifecycleMode.AUTO_LIFECYCLE);
    }

    public XStreamContainerBuilder(URL script, ClassLoader classLoader, HierarchicalStreamDriver driver, LifecycleMode lifecycleMode) {
        super(script, classLoader, lifecycleMode);
        this.xsdriver = driver;
        try {
            InputSource inputSource = new InputSource(this.getScriptReader());
            this.rootElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (IOException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ScriptedPicoContainerMarkupException(e);
        }
    }

    public void populateContainer(MutablePicoContainer container) {
        this.populateContainer(container, this.rootElement);
    }

    private void populateContainer(MutablePicoContainer container, Element rootElement) {
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            short type = child.getNodeType();
            if (type != 1) continue;
            String name = child.getNodeName();
            if (IMPLEMENTATION.equals(name)) {
                try {
                    this.insertImplementation(container, (Element)child);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ScriptedPicoContainerMarkupException(e);
                }
            }
            if (INSTANCE.equals(name)) {
                this.insertInstance(container, (Element)child);
                continue;
            }
            if (ADAPTER.equals(name)) {
                this.insertAdapter(container, (Element)child);
                continue;
            }
            throw new ScriptedPicoContainerMarkupException("Unsupported element:" + name);
        }
    }

    protected void insertAdapter(MutablePicoContainer container, Element rootElement) {
        String key = rootElement.getAttribute(KEY);
        String klass = rootElement.getAttribute(CLASS);
        try {
            DefaultPicoContainer nested = new DefaultPicoContainer();
            this.populateContainer((MutablePicoContainer)nested, rootElement);
            if (key != null) {
                container.addAdapter((ComponentAdapter)nested.getComponent((Object)key));
            } else if (klass != null) {
                Class<?> clazz = this.getClassLoader().loadClass(klass);
                container.addAdapter((ComponentAdapter)nested.getComponent(clazz));
            } else {
                container.addAdapter((ComponentAdapter)nested.getComponent(ComponentAdapter.class));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ScriptedPicoContainerMarkupException(ex);
        }
    }

    protected void insertImplementation(MutablePicoContainer container, Element rootElement) throws ClassNotFoundException {
        NodeList children;
        String key = rootElement.getAttribute(KEY);
        String klass = rootElement.getAttribute(CLASS);
        String constructor = rootElement.getAttribute(CONSTRUCTOR);
        if (klass == null || "".equals(klass)) {
            throw new ScriptedPicoContainerMarkupException("class specification is required for component implementation");
        }
        Class<?> clazz = this.getClassLoader().loadClass(klass);
        Parameter[] parameterArray = this.getParameters(rootElement);
        if ("default".equals(constructor)) {
            parameterArray = Parameter.ZERO;
        }
        if ((children = rootElement.getChildNodes()).getLength() > 0 || "default".equals(constructor)) {
            if (key == null || "".equals(key)) {
                container.addComponent(clazz, clazz, parameterArray);
            } else {
                container.addComponent((Object)key, clazz, parameterArray);
            }
        } else if (key == null || "".equals(key)) {
            container.addComponent(clazz, clazz, new Parameter[0]);
        } else {
            container.addComponent((Object)key, clazz, new Parameter[0]);
        }
    }

    private Parameter[] getParameters(Element rootElement) throws ClassNotFoundException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName();
            if (CONSTANT.equals(name)) {
                Object parseResult = this.parseElementChild((Element)child);
                if (parseResult == null) {
                    throw new ScriptedPicoContainerMarkupException("could not parse constant parameter");
                }
                parameters.add(new ConstantParameter(parseResult));
                continue;
            }
            if (DEPENDENCY.equals(name)) {
                String dependencyKey = ((Element)child).getAttribute(KEY);
                if (dependencyKey == null || "".equals(dependencyKey)) {
                    String dependencyClass = ((Element)child).getAttribute(CLASS);
                    if (dependencyClass == null || "".equals(dependencyClass)) {
                        throw new ScriptedPicoContainerMarkupException("either key or class must be present for dependency");
                    }
                    parameters.add(new ComponentParameter(this.getClassLoader().loadClass(dependencyClass)));
                    continue;
                }
                parameters.add(new ComponentParameter((Object)dependencyKey));
                continue;
            }
            if (!"parameter-zero".equals(child.getNodeName())) continue;
            if (!parameters.isEmpty()) {
                throw new PicoCompositionException("Cannot mix other parameters with 'parameter-zero' nodes.");
            }
            return Parameter.ZERO;
        }
        return parameters.toArray(new Parameter[parameters.size()]);
    }

    protected void insertInstance(MutablePicoContainer container, Element rootElement) {
        String key = rootElement.getAttribute(KEY);
        Object result = this.parseElementChild(rootElement);
        if (result == null) {
            throw new ScriptedPicoContainerMarkupException("no content could be parsed in instance");
        }
        if (key != null && !"".equals(key)) {
            container.addComponent((Object)key, result, new Parameter[0]);
        } else {
            container.addComponent(result);
        }
    }

    protected Object parseElementChild(Element rootElement) {
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return new XStream(this.xsdriver).unmarshal((HierarchicalStreamReader)new DomReader((Element)child));
        }
        return null;
    }

    protected PicoContainer createContainerFromScript(PicoContainer parentContainer, Object assemblyScope) {
        try {
            MutablePicoContainer childContainer = this.createMutablePicoContainer(parentContainer, new ContainerOptions(this.rootElement));
            this.populateContainer(childContainer);
            return childContainer;
        }
        catch (PicoClassNotFoundException e) {
            throw new ScriptedPicoContainerMarkupException("Class not found:" + e.getMessage(), e);
        }
    }

    private MutablePicoContainer createMutablePicoContainer(PicoContainer parentContainer, ContainerOptions containerOptions) throws PicoCompositionException {
        boolean caching = containerOptions.isCaching();
        boolean inherit = containerOptions.isInheritParentBehaviors();
        String monitorName = containerOptions.getMonitorName();
        String componentFactoryName = containerOptions.getComponentFactoryName();
        if (inherit) {
            if (!(parentContainer instanceof MutablePicoContainer)) {
                throw new PicoCompositionException("For behavior inheritance to be used, the parent picocontainer must be of type MutablePicoContainer");
            }
            MutablePicoContainer parentPico = (MutablePicoContainer)parentContainer;
            return parentPico.makeChildContainer();
        }
        ScriptedBuilder builder = new ScriptedBuilder(parentContainer);
        if (caching) {
            builder.withCaching();
        }
        return builder.withClassLoader(this.getClassLoader()).withLifecycle().withComponentFactory(componentFactoryName).withMonitor(monitorName).build();
    }
}

