/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.classname;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.Converters;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoClassNotFoundException;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.classname.ClassLoadingPicoContainer;
import org.picocontainer.classname.ClassName;
import org.picocontainer.classname.ClassPathElement;
import org.picocontainer.containers.AbstractDelegatingMutablePicoContainer;
import org.picocontainer.lifecycle.LifecycleState;
import org.picocontainer.security.CustomPermissionsURLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoadingPicoContainer
extends AbstractDelegatingMutablePicoContainer
implements ClassLoadingPicoContainer,
ComponentMonitorStrategy {
    private static final transient Map<String, String> primitiveNameToBoxedName = new HashMap<String, String>();
    private final transient List<ClassPathElement> classPathElements = new ArrayList<ClassPathElement>();
    private final transient ClassLoader parentClassLoader;
    private transient ClassLoader componentClassLoader;
    private transient boolean componentClassLoaderLocked;
    protected final Map<String, PicoContainer> namedChildContainers = new HashMap<String, PicoContainer>();

    public DefaultClassLoadingPicoContainer(ClassLoader classLoader, ComponentFactory componentFactory, PicoContainer parent) {
        super(new DefaultPicoContainer(componentFactory, parent));
        this.parentClassLoader = classLoader;
    }

    public DefaultClassLoadingPicoContainer(ClassLoader classLoader, MutablePicoContainer delegate) {
        super(delegate);
        this.parentClassLoader = classLoader;
    }

    public DefaultClassLoadingPicoContainer(ClassLoader classLoader, PicoContainer parent, ComponentMonitor componentMonitor) {
        super(new DefaultPicoContainer(new Caching(), parent));
        this.parentClassLoader = classLoader;
        ((ComponentMonitorStrategy)((Object)this.getDelegate())).changeMonitor(componentMonitor);
    }

    public DefaultClassLoadingPicoContainer(ComponentFactory componentFactory) {
        super(new DefaultPicoContainer(componentFactory, null));
        this.parentClassLoader = DefaultClassLoadingPicoContainer.class.getClassLoader();
    }

    public DefaultClassLoadingPicoContainer(PicoContainer parent) {
        super(new DefaultPicoContainer(parent));
        this.parentClassLoader = DefaultClassLoadingPicoContainer.class.getClassLoader();
    }

    public DefaultClassLoadingPicoContainer(MutablePicoContainer delegate) {
        super(delegate);
        this.parentClassLoader = DefaultClassLoadingPicoContainer.class.getClassLoader();
    }

    public DefaultClassLoadingPicoContainer(ClassLoader classLoader) {
        super(new DefaultPicoContainer());
        this.parentClassLoader = classLoader;
    }

    public DefaultClassLoadingPicoContainer() {
        super(new DefaultPicoContainer());
        this.parentClassLoader = DefaultClassLoadingPicoContainer.class.getClassLoader();
    }

    public DefaultClassLoadingPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent, ClassLoader cl, ComponentMonitor componentMonitor) {
        super(new DefaultPicoContainer(componentFactory, lifecycleStrategy, parent, componentMonitor));
        this.parentClassLoader = cl != null ? cl : DefaultClassLoadingPicoContainer.class.getClassLoader();
    }

    protected DefaultClassLoadingPicoContainer createChildContainer() {
        MutablePicoContainer child = this.getDelegate().makeChildContainer();
        DefaultClassLoadingPicoContainer container = new DefaultClassLoadingPicoContainer(this.getComponentClassLoader(), child);
        container.changeMonitor(this.currentMonitor());
        return container;
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        MutablePicoContainer picoDelegate = this.getDelegate();
        while (picoDelegate != null) {
            if (picoDelegate instanceof ComponentMonitorStrategy) {
                ((ComponentMonitorStrategy)((Object)picoDelegate)).changeMonitor(monitor);
                return;
            }
            if (!(picoDelegate instanceof AbstractDelegatingMutablePicoContainer)) break;
            picoDelegate = ((AbstractDelegatingMutablePicoContainer)picoDelegate).getDelegate();
        }
        throw new IllegalStateException("Could not find delegate picocontainer that implemented ComponentMonitorStrategy");
    }

    @Override
    public ComponentMonitor currentMonitor() {
        MutablePicoContainer picoDelegate = this.getDelegate();
        while (picoDelegate != null) {
            if (picoDelegate instanceof ComponentMonitorStrategy) {
                return ((ComponentMonitorStrategy)((Object)picoDelegate)).currentMonitor();
            }
            if (!(picoDelegate instanceof AbstractDelegatingMutablePicoContainer)) break;
            picoDelegate = ((AbstractDelegatingMutablePicoContainer)picoDelegate).getDelegate();
        }
        throw new IllegalStateException("Could not find delegate picocontainer that implemented ComponentMonitorStrategy");
    }

    @Override
    public final Object getComponent(Object componentKeyOrType) throws PicoException {
        Object instance;
        if (componentKeyOrType instanceof ClassName) {
            componentKeyOrType = this.loadClass(((Object)componentKeyOrType).toString());
        }
        if ((instance = this.getDelegate().getComponent((Object)componentKeyOrType)) != null) {
            return instance;
        }
        ComponentAdapter<?> componentAdapter = null;
        if (((Object)componentKeyOrType).toString().startsWith("*")) {
            String candidateClassName = ((Object)componentKeyOrType).toString().substring(1);
            Collection<ComponentAdapter<?>> cas = this.getComponentAdapters();
            for (ComponentAdapter<?> ca : cas) {
                Object key = ca.getComponentKey();
                if (!(key instanceof Class) || !candidateClassName.equals(((Class)key).getName())) continue;
                componentAdapter = ca;
                break;
            }
        }
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance(this, (Type)((Object)ComponentAdapter.NOTHING.class));
        }
        return this.getComponentInstanceFromChildren(componentKeyOrType);
    }

    private Object getComponentInstanceFromChildren(Object componentKey) {
        String componentKeyPath = componentKey.toString();
        int ix = componentKeyPath.indexOf(47);
        if (ix != -1) {
            String firstElement = componentKeyPath.substring(0, ix);
            String remainder = componentKeyPath.substring(ix + 1, componentKeyPath.length());
            PicoContainer o = this.getNamedContainers().get(firstElement);
            if (o != null) {
                MutablePicoContainer child = (MutablePicoContainer)o;
                return child.getComponent(remainder);
            }
        }
        return null;
    }

    @Override
    public final MutablePicoContainer makeChildContainer() {
        return this.makeChildContainer("containers" + this.namedChildContainers.size());
    }

    @Override
    public ClassLoadingPicoContainer makeChildContainer(String name) {
        DefaultClassLoadingPicoContainer child = this.createChildContainer();
        MutablePicoContainer parentDelegate = this.getDelegate();
        parentDelegate.removeChildContainer(child.getDelegate());
        parentDelegate.addChildContainer(child);
        this.namedChildContainers.put(name, child);
        return child;
    }

    @Override
    public boolean removeChildContainer(PicoContainer child) {
        boolean result = this.getDelegate().removeChildContainer(child);
        Iterator<Map.Entry<String, PicoContainer>> children = this.namedChildContainers.entrySet().iterator();
        while (children.hasNext()) {
            Map.Entry<String, PicoContainer> e = children.next();
            PicoContainer pc = e.getValue();
            if (pc != child) continue;
            children.remove();
        }
        return result;
    }

    protected final Map<String, PicoContainer> getNamedContainers() {
        return this.namedChildContainers;
    }

    @Override
    public ClassPathElement addClassLoaderURL(URL url) {
        if (this.componentClassLoaderLocked) {
            throw new IllegalStateException("ClassLoader URLs cannot be added once this instance is locked");
        }
        ClassPathElement classPathElement = new ClassPathElement(url);
        this.classPathElements.add(classPathElement);
        return classPathElement;
    }

    @Override
    public MutablePicoContainer addComponent(Object implOrInstance) {
        if (implOrInstance instanceof ClassName) {
            super.addComponent(this.loadClass(implOrInstance.toString()));
        } else {
            super.addComponent(implOrInstance);
        }
        return this;
    }

    @Override
    public MutablePicoContainer addComponent(Object key, Object componentImplementationOrInstance, Parameter ... parameters) {
        super.addComponent(this.classNameToClassIfApplicable(key), this.classNameToClassIfApplicable(componentImplementationOrInstance), parameters);
        return this;
    }

    private Object classNameToClassIfApplicable(Object key) {
        if (key instanceof ClassName) {
            key = this.loadClass(((Object)key).toString());
        }
        return key;
    }

    @Override
    public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) throws PicoCompositionException {
        super.addAdapter(componentAdapter);
        return this;
    }

    @Override
    public ClassLoader getComponentClassLoader() {
        if (this.componentClassLoader == null) {
            this.componentClassLoaderLocked = true;
            this.componentClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new CustomPermissionsURLClassLoader(DefaultClassLoadingPicoContainer.this.getURLs(DefaultClassLoadingPicoContainer.this.classPathElements), DefaultClassLoadingPicoContainer.this.makePermissions(), DefaultClassLoadingPicoContainer.this.parentClassLoader);
                }
            });
        }
        return this.componentClassLoader;
    }

    @Override
    public MutablePicoContainer addChildContainer(PicoContainer child) {
        this.getDelegate().addChildContainer(child);
        this.namedChildContainers.put("containers" + this.namedChildContainers.size(), child);
        return this;
    }

    @Override
    public ClassLoadingPicoContainer addChildContainer(String name, PicoContainer child) {
        super.addChildContainer(child);
        this.namedChildContainers.put(name, child);
        return this;
    }

    private Class<?> loadClass(String className) {
        ClassLoader classLoader = this.getComponentClassLoader();
        String cn = DefaultClassLoadingPicoContainer.getClassName(className);
        try {
            return classLoader.loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            throw new PicoClassNotFoundException(cn, e);
        }
    }

    private Map<URL, Permissions> makePermissions() {
        HashMap<URL, Permissions> permissionsMap = new HashMap<URL, Permissions>();
        for (ClassPathElement cpe : this.classPathElements) {
            Permissions permissionCollection = cpe.getPermissionCollection();
            permissionsMap.put(cpe.getUrl(), permissionCollection);
        }
        return permissionsMap;
    }

    private URL[] getURLs(List<ClassPathElement> classPathElemelements) {
        URL[] urls = new URL[classPathElemelements.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = classPathElemelements.get(i).getUrl();
        }
        return urls;
    }

    private static String getClassName(String primitiveOrClass) {
        String fromMap = primitiveNameToBoxedName.get(primitiveOrClass);
        return fromMap != null ? fromMap : primitiveOrClass;
    }

    @Override
    public ComponentAdapter<?> getComponentAdapter(Object componentKey) {
        Class<?> componentKey2 = componentKey;
        if (componentKey instanceof ClassName) {
            componentKey2 = this.loadClass(((Object)componentKey).toString());
        }
        return super.getComponentAdapter(componentKey2);
    }

    @Override
    public MutablePicoContainer change(Properties ... properties) {
        super.change(properties);
        return this;
    }

    @Override
    public MutablePicoContainer as(Properties ... properties) {
        return new AsPropertiesPicoContainer(properties);
    }

    static {
        primitiveNameToBoxedName.put("int", Integer.class.getName());
        primitiveNameToBoxedName.put("byte", Byte.class.getName());
        primitiveNameToBoxedName.put("short", Short.class.getName());
        primitiveNameToBoxedName.put("long", Long.class.getName());
        primitiveNameToBoxedName.put("float", Float.class.getName());
        primitiveNameToBoxedName.put("double", Double.class.getName());
        primitiveNameToBoxedName.put("boolean", Boolean.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsPropertiesPicoContainer
    implements ClassLoadingPicoContainer {
        private MutablePicoContainer delegate;

        public AsPropertiesPicoContainer(Properties ... props) {
            this.delegate = DefaultClassLoadingPicoContainer.this.getDelegate().as(props);
        }

        @Override
        public ClassPathElement addClassLoaderURL(URL url) {
            return DefaultClassLoadingPicoContainer.this.addClassLoaderURL(url);
        }

        @Override
        public ClassLoader getComponentClassLoader() {
            return DefaultClassLoadingPicoContainer.this.getComponentClassLoader();
        }

        @Override
        public ClassLoadingPicoContainer makeChildContainer(String name) {
            return DefaultClassLoadingPicoContainer.this.makeChildContainer(name);
        }

        @Override
        public ClassLoadingPicoContainer addChildContainer(String name, PicoContainer child) {
            return (ClassLoadingPicoContainer)DefaultClassLoadingPicoContainer.this.addChildContainer(child);
        }

        @Override
        public MutablePicoContainer addComponent(Object componentKey, Object componentImplementationOrInstance, Parameter ... parameters) {
            this.delegate.addComponent(DefaultClassLoadingPicoContainer.this.classNameToClassIfApplicable(componentKey), DefaultClassLoadingPicoContainer.this.classNameToClassIfApplicable(componentImplementationOrInstance), parameters);
            return DefaultClassLoadingPicoContainer.this;
        }

        @Override
        public MutablePicoContainer addComponent(Object implOrInstance) {
            this.delegate.addComponent(DefaultClassLoadingPicoContainer.this.classNameToClassIfApplicable(implOrInstance));
            return DefaultClassLoadingPicoContainer.this;
        }

        @Override
        public MutablePicoContainer addConfig(String name, Object val) {
            this.delegate.addConfig(name, val);
            return DefaultClassLoadingPicoContainer.this;
        }

        @Override
        public MutablePicoContainer addAdapter(ComponentAdapter<?> componentAdapter) {
            this.delegate.addAdapter(componentAdapter);
            return DefaultClassLoadingPicoContainer.this;
        }

        public ComponentAdapter removeComponent(Object componentKey) {
            return this.delegate.removeComponent(componentKey);
        }

        public ComponentAdapter removeComponentByInstance(Object componentInstance) {
            return this.delegate.removeComponentByInstance(componentInstance);
        }

        @Override
        public MutablePicoContainer makeChildContainer() {
            return DefaultClassLoadingPicoContainer.this.makeChildContainer();
        }

        @Override
        public MutablePicoContainer addChildContainer(PicoContainer child) {
            return DefaultClassLoadingPicoContainer.this.addChildContainer(child);
        }

        @Override
        public boolean removeChildContainer(PicoContainer child) {
            return DefaultClassLoadingPicoContainer.this.removeChildContainer(child);
        }

        @Override
        public MutablePicoContainer change(Properties ... properties) {
            return DefaultClassLoadingPicoContainer.this.change(properties);
        }

        @Override
        public MutablePicoContainer as(Properties ... properties) {
            return new AsPropertiesPicoContainer(properties);
        }

        @Override
        public Object getComponent(Object componentKeyOrType) {
            return DefaultClassLoadingPicoContainer.this.getComponent(componentKeyOrType);
        }

        @Override
        public Object getComponent(Object componentKeyOrType, Type into) {
            return DefaultClassLoadingPicoContainer.this.getComponent(componentKeyOrType, into);
        }

        @Override
        public <T> T getComponent(Class<T> componentType) {
            return DefaultClassLoadingPicoContainer.this.getComponent(componentType);
        }

        @Override
        public <T> T getComponent(Class<T> componentType, Class<? extends Annotation> binding) {
            return DefaultClassLoadingPicoContainer.this.getComponent(componentType, binding);
        }

        @Override
        public List<Object> getComponents() {
            return DefaultClassLoadingPicoContainer.this.getComponents();
        }

        @Override
        public PicoContainer getParent() {
            return DefaultClassLoadingPicoContainer.this.getParent();
        }

        @Override
        public ComponentAdapter<?> getComponentAdapter(Object componentKey) {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapter(componentKey);
        }

        @Override
        public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, NameBinding componentNameBinding) {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapter(componentType, componentNameBinding);
        }

        @Override
        public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, Class<? extends Annotation> binding) {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapter(componentType, binding);
        }

        @Override
        public Collection<ComponentAdapter<?>> getComponentAdapters() {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapters();
        }

        @Override
        public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType) {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapters(componentType);
        }

        @Override
        public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType, Class<? extends Annotation> binding) {
            return DefaultClassLoadingPicoContainer.this.getComponentAdapters(componentType, binding);
        }

        @Override
        public <T> List<T> getComponents(Class<T> componentType) {
            return DefaultClassLoadingPicoContainer.this.getComponents(componentType);
        }

        @Override
        public void accept(PicoVisitor visitor) {
            DefaultClassLoadingPicoContainer.this.accept(visitor);
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void setName(String name) {
            DefaultClassLoadingPicoContainer.this.setName(name);
        }

        @Override
        public void setLifecycleState(LifecycleState lifecycleState) {
            DefaultClassLoadingPicoContainer.this.setLifecycleState(lifecycleState);
        }

        public Converters getConverter() {
            return DefaultClassLoadingPicoContainer.this.getConverters();
        }

        @Override
        public LifecycleState getLifecycleState() {
            return DefaultClassLoadingPicoContainer.this.getLifecycleState();
        }

        @Override
        public String getName() {
            return DefaultClassLoadingPicoContainer.this.getName();
        }
    }
}

