/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.parameters.AbstractParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicComponentParameter
extends AbstractParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;
    private static final Map<Class, Converter> stringConverters = new HashMap<Class, Converter>();

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parameter.Resolver resolve(PicoContainer container, ComponentAdapter<?> forAdapter, ComponentAdapter<?> injecteeAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        void var9_11;
        Class resolvedClassType = null;
        if (!(expectedType instanceof Class)) {
            if (!(expectedType instanceof ParameterizedType)) return new Parameter.NotResolved();
            resolvedClassType = (Class)((ParameterizedType)expectedType).getRawType();
        } else {
            resolvedClassType = (Class)expectedType;
        }
        assert (resolvedClassType != null);
        if (injecteeAdapter == null) {
            ComponentAdapter componentAdapter = this.resolveAdapter(container, forAdapter, resolvedClassType, expectedNameBinding, useNames, binding);
        } else {
            ComponentAdapter<?> componentAdapter = injecteeAdapter;
        }
        void componentAdapter = var9_11;
        return new Parameter.Resolver((ComponentAdapter)componentAdapter, container, forAdapter, expectedType){
            final /* synthetic */ ComponentAdapter val$componentAdapter;
            final /* synthetic */ PicoContainer val$container;
            final /* synthetic */ ComponentAdapter val$forAdapter;
            final /* synthetic */ Type val$expectedType;
            {
                this.val$componentAdapter = componentAdapter;
                this.val$container = picoContainer;
                this.val$forAdapter = componentAdapter2;
                this.val$expectedType = type;
            }

            @Override
            public boolean isResolved() {
                return this.val$componentAdapter != null;
            }

            @Override
            public Object resolveInstance() {
                if (this.val$componentAdapter == null) {
                    return null;
                }
                Object o = this.val$componentAdapter instanceof DefaultPicoContainer.LateInstance ? ((DefaultPicoContainer.LateInstance)this.val$componentAdapter).getComponentInstance() : this.val$container.getComponent(this.val$componentAdapter.getComponentKey(), this.val$forAdapter.getComponentImplementation());
                if (o instanceof String && this.val$expectedType != String.class) {
                    Converter converter = (Converter)stringConverters.get(this.val$expectedType);
                    return converter.convert((String)o);
                }
                return o;
            }

            @Override
            public ComponentAdapter<?> getComponentAdapter() {
                return this.val$componentAdapter;
            }
        };
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> forAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, forAdapter, (Class)expectedType, expectedNameBinding, useNames, binding);
        if (componentAdapter == null) {
            HashSet<Type> set = new HashSet<Type>();
            set.add(expectedType);
            throw new AbstractInjector.UnsatisfiableDependenciesException(forAdapter, null, set, container);
        }
        componentAdapter.verify(container);
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected <T> ComponentAdapter<T> resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class<T> expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        ComponentAdapter<T> result;
        Class<Object> type = expectedType;
        if (type.isPrimitive()) {
            String expectedTypeName = expectedType.getName();
            if (expectedTypeName == "int") {
                type = Integer.class;
            } else if (expectedTypeName == "long") {
                type = Long.class;
            } else if (expectedTypeName == "float") {
                type = Float.class;
            } else if (expectedTypeName == "double") {
                type = Double.class;
            } else if (expectedTypeName == "boolean") {
                type = Boolean.class;
            } else if (expectedTypeName == "char") {
                type = Character.class;
            } else if (expectedTypeName == "short") {
                type = Short.class;
            } else if (expectedTypeName == "byte") {
                type = Byte.class;
            }
        }
        if ((result = this.getTargetAdapter(container, type, expectedNameBinding, adapter, useNames, binding)) == null) {
            return null;
        }
        if (!(type.isAssignableFrom(result.getComponentImplementation()) || result.getComponentImplementation() == String.class && stringConverters.containsKey(type))) {
            return null;
        }
        return result;
    }

    private static <T> ComponentAdapter<T> typeComponentAdapter(ComponentAdapter<?> componentAdapter) {
        return componentAdapter;
    }

    private <T> ComponentAdapter<T> getTargetAdapter(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, ComponentAdapter excludeAdapter, boolean useNames, Annotation binding) {
        if (this.componentKey != null) {
            return BasicComponentParameter.typeComponentAdapter(container.getComponentAdapter(this.componentKey));
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapter(expectedType, (NameBinding)null);
        }
        return this.findTargetAdapter(container, expectedType, expectedNameBinding, excludeAdapter, useNames, binding);
    }

    private <T> ComponentAdapter<T> findTargetAdapter(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, ComponentAdapter excludeAdapter, boolean useNames, Annotation binding) {
        Object found;
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter<?> byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return BasicComponentParameter.typeComponentAdapter(byKey);
        }
        if (useNames && (found = container.getComponentAdapter(expectedNameBinding.getName())) != null && this.areCompatible(expectedType, (ComponentAdapter)found) && found != excludeAdapter) {
            return found;
        }
        found = binding == null ? container.getComponentAdapters(expectedType) : container.getComponentAdapters(expectedType, binding.annotationType());
        this.removeExcludedAdapterIfApplicable(excludeKey, (List<ComponentAdapter<T>>)found);
        if (found.size() == 0) {
            return this.noMatchingAdaptersFound(container, expectedType, expectedNameBinding, binding);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        throw this.tooManyMatchingAdaptersFound(expectedType, (List<ComponentAdapter<T>>)found);
    }

    private <T> ComponentAdapter<T> noMatchingAdaptersFound(PicoContainer container, Class<T> expectedType, NameBinding expectedNameBinding, Annotation binding) {
        if (container.getParent() != null) {
            if (binding != null) {
                return container.getParent().getComponentAdapter(expectedType, binding.getClass());
            }
            return container.getParent().getComponentAdapter(expectedType, expectedNameBinding);
        }
        return null;
    }

    private <T> AbstractInjector.AmbiguousComponentResolutionException tooManyMatchingAdaptersFound(Class<T> expectedType, List<ComponentAdapter<T>> found) {
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        AbstractInjector.AmbiguousComponentResolutionException exception = new AbstractInjector.AmbiguousComponentResolutionException(expectedType, foundClasses);
        return exception;
    }

    private <T> void removeExcludedAdapterIfApplicable(Object excludeKey, List<ComponentAdapter<T>> found) {
        ComponentAdapter<T> exclude = null;
        for (ComponentAdapter<T> work : found) {
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
            break;
        }
        found.remove(exclude);
    }

    private <T> boolean areCompatible(Class<T> expectedType, ComponentAdapter found) {
        Class foundImpl = found.getComponentImplementation();
        return expectedType.isAssignableFrom(foundImpl) || foundImpl == String.class && stringConverters.containsKey(expectedType);
    }

    static {
        stringConverters.put(Integer.class, new Converter(){

            public Object convert(String paramValue) {
                return Integer.valueOf(paramValue);
            }
        });
        stringConverters.put(Double.class, new Converter(){

            public Object convert(String paramValue) {
                return Double.valueOf(paramValue);
            }
        });
        stringConverters.put(Boolean.class, new Converter(){

            public Object convert(String paramValue) {
                return Boolean.valueOf(paramValue);
            }
        });
        stringConverters.put(Long.class, new Converter(){

            public Object convert(String paramValue) {
                return Long.valueOf(paramValue);
            }
        });
        stringConverters.put(Float.class, new Converter(){

            public Object convert(String paramValue) {
                return Float.valueOf(paramValue);
            }
        });
        stringConverters.put(Character.class, new Converter(){

            public Object convert(String paramValue) {
                return Character.valueOf(paramValue.charAt(0));
            }
        });
        stringConverters.put(Byte.class, new Converter(){

            public Object convert(String paramValue) {
                return Byte.valueOf(paramValue);
            }
        });
        stringConverters.put(Short.class, new Converter(){

            public Object convert(String paramValue) {
                return Short.valueOf(paramValue);
            }
        });
        stringConverters.put(File.class, new Converter(){

            public Object convert(String paramValue) {
                return new File(paramValue);
            }
        });
    }

    private static class NewInstanceConverter
    implements Converter {
        private Constructor c;

        private NewInstanceConverter(Class clazz) {
            try {
                this.c = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public Object convert(String paramValue) {
            try {
                return this.c.newInstance(paramValue);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

