/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.containers;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatingPicoContainer
implements PicoContainer,
Serializable {
    private PicoContainer delegate;

    public AbstractDelegatingPicoContainer(PicoContainer delegate) {
        if (delegate == null) {
            throw new NullPointerException("PicoContainer delegate must not be null");
        }
        this.delegate = delegate;
    }

    @Override
    public final void accept(PicoVisitor visitor) {
        visitor.visitContainer(this);
        this.delegate.accept(visitor);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj) || this == obj;
    }

    @Override
    public <T> T getComponent(Class<T> componentType) {
        return componentType.cast(this.getComponent((Object)componentType));
    }

    @Override
    public <T> T getComponent(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.delegate.getComponent(componentType, binding);
    }

    @Override
    public Object getComponent(Object componentKeyOrType) {
        return this.delegate.getComponent(componentKeyOrType);
    }

    @Override
    public Object getComponent(Object componentKeyOrType, Type into) {
        return this.delegate.getComponent(componentKeyOrType, into);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, NameBinding componentNameBinding) {
        return this.delegate.getComponentAdapter(componentType, componentNameBinding);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.delegate.getComponentAdapter(componentType, binding);
    }

    @Override
    public ComponentAdapter<?> getComponentAdapter(Object componentKey) {
        return this.delegate.getComponentAdapter(componentKey);
    }

    @Override
    public Collection<ComponentAdapter<?>> getComponentAdapters() {
        return this.delegate.getComponentAdapters();
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType) {
        return this.delegate.getComponentAdapters(componentType);
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdapters(Class<T> componentType, Class<? extends Annotation> binding) {
        return this.delegate.getComponentAdapters(componentType, binding);
    }

    @Override
    public List<Object> getComponents() {
        return this.delegate.getComponents();
    }

    @Override
    public <T> List<T> getComponents(Class<T> type) throws PicoException {
        return this.delegate.getComponents(type);
    }

    public PicoContainer getDelegate() {
        return this.delegate;
    }

    @Override
    public PicoContainer getParent() {
        return this.delegate.getParent();
    }

    public String toString() {
        return "D<" + this.delegate.toString();
    }
}

