/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.annotations.Bind;
import org.picocontainer.injectors.IterativeInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedFieldInjector
extends IterativeInjector {
    private final List<String> classes;

    public TypedFieldInjector(Object key, Class<?> impl, Parameter[] parameters, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, String classNames) {
        super(key, (Class)impl, parameters, componentMonitor, lifecycleStrategy, true);
        this.classes = Arrays.asList(classNames.trim().split(" "));
    }

    @Override
    protected void initializeInjectionMembersAndTypeLists() {
        Field[] fields;
        this.injectionMembers = new ArrayList();
        ArrayList<Annotation> bindingIds = new ArrayList<Annotation>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Field field : fields = this.getFields()) {
            if (!this.isTypedForInjection(field)) continue;
            this.injectionMembers.add(field);
            typeList.add(this.box(field.getType()));
            bindingIds.add(this.getBinding(field));
        }
        this.injectionTypes = typeList.toArray(new Type[0]);
        this.bindings = bindingIds.toArray(new Annotation[0]);
    }

    private Annotation getBinding(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Bind.class)) continue;
            return annotation;
        }
        return null;
    }

    protected boolean isTypedForInjection(Field field) {
        return this.classes.contains(field.getType().getName());
    }

    private Field[] getFields() {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return TypedFieldInjector.this.getComponentImplementation().getDeclaredFields();
            }
        });
    }

    @Override
    protected Object injectIntoMember(AccessibleObject member, Object componentInstance, Object toInject) throws IllegalAccessException, InvocationTargetException {
        Field field = (Field)member;
        field.setAccessible(true);
        field.set(componentInstance, toInject);
        return null;
    }

    @Override
    public String getDescriptor() {
        return "TypedFieldInjector-";
    }

    @Override
    protected NameBinding makeParameterNameImpl(final AccessibleObject member) {
        return new NameBinding(){

            public String getName() {
                return ((Field)member).getName();
            }
        };
    }

    @Override
    protected Object memberInvocationReturn(Object lastReturn, AccessibleObject member, Object instance) {
        return instance;
    }

    List<String> getInjectionFieldTypes() {
        return Collections.unmodifiableList(this.classes);
    }
}

