/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.pitest.classinfo.ClassInfo;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.report.html.AnnotatedLineFactory;
import org.pitest.mutationtest.report.html.Line;
import org.pitest.mutationtest.report.html.MutationResultList;
import org.pitest.mutationtest.report.html.MutationTestSummaryData;
import org.pitest.mutationtest.report.html.MutationTotals;
import org.pitest.mutationtest.report.html.PackageSummaryData;
import org.pitest.mutationtest.report.html.PackageSummaryMap;
import org.pitest.mutationtest.report.html.SourceFile;
import org.pitest.reloc.antlr.stringtemplate.StringTemplate;
import org.pitest.reloc.antlr.stringtemplate.StringTemplateGroup;
import org.pitest.util.FileUtil;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.ResultOutputStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationHtmlReportListener
implements MutationResultListener {
    private final ResultOutputStrategy outputStrategy;
    private final Collection<SourceLocator> sourceRoots = new HashSet<SourceLocator>();
    private final PackageSummaryMap packageSummaryData = new PackageSummaryMap();
    private final CoverageDatabase coverage;
    private final Set<String> mutatorNames = new HashSet<String>();

    public MutationHtmlReportListener(CoverageDatabase coverage, ResultOutputStrategy outputStrategy, Collection<String> mutatorNames, SourceLocator ... locators) {
        this.coverage = coverage;
        this.outputStrategy = outputStrategy;
        this.sourceRoots.addAll(Arrays.asList(locators));
        this.mutatorNames.addAll(mutatorNames);
    }

    private void generateAnnotatedSourceFile(MutationTestSummaryData mutationMetaData) {
        try {
            String css = FileUtil.readToString((InputStream)IsolationUtils.getContextClassLoader().getResourceAsStream("templates/mutation/style.css"));
            String fileName = mutationMetaData.getPackageName() + File.separator + mutationMetaData.getFileName() + ".html";
            Writer writer = this.outputStrategy.createWriterForFile(fileName);
            StringTemplateGroup group = new StringTemplateGroup("mutation_test");
            StringTemplate st = group.getInstanceOf("templates/mutation/mutation_report");
            st.setAttribute("css", css);
            st.setAttribute("tests", mutationMetaData.getTests());
            st.setAttribute("mutators", mutationMetaData.getMutators());
            SourceFile sourceFile = this.createAnnotatedSourceFile(mutationMetaData);
            st.setAttribute("sourceFile", sourceFile);
            st.setAttribute("mutatedClasses", mutationMetaData.getMutatedClasses());
            writer.write(st.toString());
            writer.close();
        }
        catch (IOException ex) {
            Log.getLogger().log(Level.WARNING, "Error while writing report", ex);
        }
    }

    private PackageSummaryData collectPackageSummaries(ClassMutationResults mutationMetaData) {
        String packageName = mutationMetaData.getPackageName();
        return this.packageSummaryData.update(packageName, this.createSummaryData(this.coverage, mutationMetaData));
    }

    public MutationTestSummaryData createSummaryData(CoverageDatabase coverage, ClassMutationResults data) {
        return new MutationTestSummaryData(data.getFileName(), data.getMutations(), this.mutatorNames, coverage.getClassInfo(Collections.singleton(data.getMutatedClass())), coverage.getNumberOfCoveredLines(Collections.singleton(data.getMutatedClass())));
    }

    private SourceFile createAnnotatedSourceFile(MutationTestSummaryData mutationMetaData) throws IOException {
        String fileName = mutationMetaData.getFileName();
        String packageName = mutationMetaData.getPackageName();
        MutationResultList mutationsForThisFile = mutationMetaData.getResults();
        List<Line> lines = this.createAnnotatedSourceCodeLines(fileName, packageName, mutationsForThisFile);
        return new SourceFile(fileName, lines, mutationsForThisFile.groupMutationsByLine());
    }

    private List<Line> createAnnotatedSourceCodeLines(String sourceFile, String packageName, MutationResultList mutationsForThisFile) throws IOException {
        Collection classes = this.coverage.getClassesForFile(sourceFile, packageName);
        Option<Reader> reader = this.findSourceFile(this.classInfoToNames(classes), sourceFile);
        if (reader.hasSome()) {
            AnnotatedLineFactory alf = new AnnotatedLineFactory(mutationsForThisFile, this.coverage, classes);
            return alf.convert((Reader)reader.value());
        }
        return Collections.emptyList();
    }

    private Collection<String> classInfoToNames(Collection<ClassInfo> classes) {
        return FCollection.map(classes, this.classInfoToJavaName());
    }

    private F<ClassInfo, String> classInfoToJavaName() {
        return new F<ClassInfo, String>(){

            public String apply(ClassInfo a) {
                return a.getName().asJavaName();
            }
        };
    }

    private Option<Reader> findSourceFile(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.sourceRoots) {
            Option maybe = each.locate(classes, fileName);
            if (!maybe.hasSome()) continue;
            return maybe;
        }
        return Option.none();
    }

    public void onRunEnd() {
        this.createIndexPages();
    }

    private void createIndexPages() {
        StringTemplateGroup group = new StringTemplateGroup("mutation_test");
        StringTemplate st = group.getInstanceOf("templates/mutation/mutation_package_index");
        Writer writer = this.outputStrategy.createWriterForFile("index.html");
        MutationTotals totals = new MutationTotals();
        ArrayList<PackageSummaryData> psd = new ArrayList<PackageSummaryData>(this.packageSummaryData.values());
        Collections.sort(psd);
        for (PackageSummaryData psData : psd) {
            totals.add(psData.getTotals());
            this.createPackageIndexPage(psData);
        }
        st.setAttribute("totals", totals);
        st.setAttribute("packageSummaries", psd);
        try {
            writer.write(st.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPackageIndexPage(PackageSummaryData psData) {
        StringTemplateGroup group = new StringTemplateGroup("mutation_test");
        StringTemplate st = group.getInstanceOf("templates/mutation/package_index");
        Writer writer = this.outputStrategy.createWriterForFile(psData.getPackageDirectory() + File.separator + "index.html");
        st.setAttribute("packageData", psData);
        try {
            writer.write(st.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runStart() {
    }

    public void runEnd() {
        this.createIndexPages();
    }

    public void handleMutationResult(ClassMutationResults metaData) {
        PackageSummaryData packageData = this.collectPackageSummaries(metaData);
        this.generateAnnotatedSourceFile(packageData.getForSourceFile(metaData.getFileName()));
    }
}

