/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pitest.classinfo.ClassInfo;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.MutationResultList;
import org.pitest.mutationtest.report.html.MutationTotals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationTestSummaryData {
    private final String fileName;
    private final Set<String> mutators = new HashSet<String>();
    private final Collection<MutationResult> mutations = new ArrayList<MutationResult>();
    private final Set<ClassInfo> classes = new HashSet<ClassInfo>();
    private long numberOfCoveredLines;

    public MutationTestSummaryData(String fileName, Collection<MutationResult> results, Collection<String> mutators, Collection<ClassInfo> classes, long numberOfCoveredLines) {
        this.fileName = fileName;
        this.mutations.addAll(results);
        this.mutators.addAll(mutators);
        this.classes.addAll(classes);
        this.numberOfCoveredLines = numberOfCoveredLines;
    }

    public MutationTotals getTotals() {
        MutationTotals mt = new MutationTotals();
        mt.addFiles(1L);
        mt.addMutations(this.getNumberOfMutations());
        mt.addMutationsDetetcted(this.getNumberOfMutationsDetected());
        mt.addLines(this.getNumberOfLines());
        mt.addLinesCovered(this.numberOfCoveredLines);
        return mt;
    }

    public String getPackageName() {
        String packageName = this.getMutatedClasses().iterator().next().getName().asJavaName();
        int lastDot = packageName.lastIndexOf(46);
        return lastDot > 0 ? packageName.substring(0, lastDot) : "default";
    }

    public void add(MutationTestSummaryData data) {
        this.mutations.addAll(data.mutations);
        this.mutators.addAll(data.getMutators());
        int classesBefore = this.classes.size();
        this.classes.addAll(data.classes);
        if (classesBefore < this.classes.size()) {
            this.numberOfCoveredLines += data.numberOfCoveredLines;
        }
    }

    public Collection<TestInfo> getTests() {
        HashSet<TestInfo> uniqueTests = new HashSet<TestInfo>();
        FCollection.flatMapTo(this.mutations, this.mutationToTargettedTests(), uniqueTests);
        return uniqueTests;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Collection<ClassInfo> getMutatedClasses() {
        return this.classes;
    }

    public Set<String> getMutators() {
        return this.mutators;
    }

    public MutationResultList getResults() {
        return new MutationResultList(this.mutations);
    }

    public Collection<ClassInfo> getClasses() {
        return this.classes;
    }

    private int getNumberOfLines() {
        return (Integer)FCollection.fold(this.accumulateCodeLines(), (Object)0, this.classes);
    }

    private F2<Integer, ClassInfo, Integer> accumulateCodeLines() {
        return new F2<Integer, ClassInfo, Integer>(){

            public Integer apply(Integer a, ClassInfo b) {
                return a + b.getNumberOfCodeLines();
            }
        };
    }

    private long getNumberOfMutations() {
        return this.mutations.size();
    }

    private long getNumberOfMutationsDetected() {
        int count = 0;
        for (MutationResult each : this.mutations) {
            if (!each.getStatus().isDetected()) continue;
            ++count;
        }
        return count;
    }

    private F<MutationResult, Iterable<TestInfo>> mutationToTargettedTests() {
        return new F<MutationResult, Iterable<TestInfo>>(){

            public Iterable<TestInfo> apply(MutationResult a) {
                return a.getDetails().getTestsInOrder();
            }
        };
    }
}

