/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.io.Serializable;
import java.util.Comparator;
import java.util.EnumMap;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultComparator
implements Comparator<MutationResult>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final EnumMap<DetectionStatus, Integer> RANK = new EnumMap(DetectionStatus.class);

    ResultComparator() {
    }

    @Override
    public int compare(MutationResult o1, MutationResult o2) {
        return this.getRanking(o1.getStatus()) - this.getRanking(o2.getStatus());
    }

    private int getRanking(DetectionStatus status) {
        return RANK.get(status);
    }

    static {
        RANK.put(DetectionStatus.KILLED, 4);
        RANK.put(DetectionStatus.SURVIVED, 0);
        RANK.put(DetectionStatus.TIMED_OUT, 2);
        RANK.put(DetectionStatus.NON_VIABLE, 3);
        RANK.put(DetectionStatus.MEMORY_ERROR, 1);
        RANK.put(DetectionStatus.NOT_STARTED, 1);
        RANK.put(DetectionStatus.STARTED, 1);
        RANK.put(DetectionStatus.RUN_ERROR, 0);
        RANK.put(DetectionStatus.NO_COVERAGE, 0);
    }
}

