/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc.cache;

import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.playframework.cachecontrol.CacheDefaults;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.CacheResponse;
import org.playframework.cachecontrol.CurrentAgeCalculator;
import org.playframework.cachecontrol.FreshnessCalculator;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.OriginResponse;
import org.playframework.cachecontrol.ResponseCachingAction;
import org.playframework.cachecontrol.ResponseCachingCalculator;
import org.playframework.cachecontrol.ResponseSelectionAction;
import org.playframework.cachecontrol.ResponseSelectionCalculator;
import org.playframework.cachecontrol.ResponseServeAction;
import org.playframework.cachecontrol.ResponseServingCalculator;
import org.playframework.cachecontrol.SecondaryKeyCalculator;
import org.playframework.cachecontrol.Seconds;
import org.playframework.cachecontrol.Seconds$;
import org.playframework.cachecontrol.StoredResponse;
import org.playframework.cachecontrol.StripHeaderCalculator;
import org.playframework.cachecontrol.Warning;
import org.playframework.cachecontrol.WarningParser$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ahc.AhcUtilities;
import play.api.libs.ws.ahc.cache.AhcHttpCache$;
import play.api.libs.ws.ahc.cache.Cache;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseBodyPart;
import play.api.libs.ws.ahc.cache.CacheableHttpResponseStatus;
import play.api.libs.ws.ahc.cache.CacheableResponse;
import play.api.libs.ws.ahc.cache.Debug;
import play.api.libs.ws.ahc.cache.EffectiveURIKey;
import play.api.libs.ws.ahc.cache.EffectiveURIKey$;
import play.api.libs.ws.ahc.cache.ResponseEntry;
import play.shaded.ahc.io.netty.handler.codec.http.DefaultHttpHeaders;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.Response;
import play.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u001df\u0001\u0002\u001f>\u0001)C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001BC\u0002\u0013\r\u0001\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003j\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001d9\bA1A\u0005\naDaa \u0001!\u0002\u0013I\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u0015\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\ty\u0003\u0001Q\u0001\n\u0005%\u0002\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA%\u0001\t\u0007I\u0011BA&\u0011!\t\u0019\u0006\u0001Q\u0001\n\u00055\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u0007\u0001A\u0011\tB\u0003\u0011\u001d\u0011I\u0002\u0001C!\u00057AqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u00036\u0001!\tAa\u000e\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011i\u0007\u0001C\t\u0005_BqA!&\u0001\t#\u00119\nC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t\u0005\u0003\u0001\"\u0005\u0003:\"9!1\u001a\u0001\u0005\u0012\t5\u0007b\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007\u000b\u0001A\u0011AB\u0004\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u0004,\u0001!\ta!\f\t\u000f\rE\u0002\u0001\"\u0001\u00044!91q\u0007\u0001\u0005\u0002\re\u0002bBB%\u0001\u0011E11\n\u0005\b\u0007\u001f\u0002A\u0011CB)\u0011\u001d\u0019i\u0006\u0001C\t\u0007?Bqa!\u001e\u0001\t#\u00199\bC\u0004\u0004\u0000\u0001!\ta!!\t\u000f\r\r\u0005\u0001\"\u0011\u0004\u0006\u001eI1qQ\u001f\u0002\u0002#\u00051\u0011\u0012\u0004\tyu\n\t\u0011#\u0001\u0004\f\"1\u0001/\u000fC\u0001\u0007\u001bC\u0011ba$:#\u0003%\ta!%\u0003\u0019\u0005C7\r\u0013;ua\u000e\u000b7\r[3\u000b\u0005yz\u0014!B2bG\",'B\u0001!B\u0003\r\t\u0007n\u0019\u0006\u0003\u0005\u000e\u000b!a^:\u000b\u0005\u0011+\u0015\u0001\u00027jENT!AR$\u0002\u0007\u0005\u0004\u0018NC\u0001I\u0003\u0011\u0001H.Y=\u0004\u0001M!\u0001aS)\\!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fMB\u0011!+W\u0007\u0002'*\u0011A+V\u0001\rG\u0006\u001c\u0007.Z2p]R\u0014x\u000e\u001c\u0006\u0003-^\u000bQ\u0002\u001d7bs\u001a\u0014\u0018-\\3x_J\\'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002['\ni1)Y2iK\u0012+g-Y;miN\u0004\"\u0001X/\u000e\u0003uJ!AX\u001f\u0003\u000b\u0011+'-^4\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0002]C&\u0011!-\u0010\u0002\u0006\u0007\u0006\u001c\u0007.Z\u0001\u0012Q\u0016,(/[:uS\u000e\u001cXI\\1cY\u0016$\u0007C\u0001'f\u0013\t1WJA\u0004C_>dW-\u00198\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A5\u0011\u0005)lW\"A6\u000b\u00051l\u0015AC2p]\u000e,(O]3oi&\u0011an\u001b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q\u0019!/\u001e<\u0015\u0005M$\bC\u0001/\u0001\u0011\u00159W\u0001q\u0001j\u0011\u0015yV\u00011\u0001a\u0011\u001d\u0019W\u0001%AA\u0002\u0011\fa\u0001\\8hO\u0016\u0014X#A=\u0011\u0005ilX\"A>\u000b\u0005q<\u0016!B:mMRR\u0017B\u0001@|\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u0007:fgB|gn]3DC\u000eD\u0017N\\4DC2\u001cW\u000f\\1u_J,\"!!\u0002\u0011\u0007I\u000b9!C\u0002\u0002\nM\u0013\u0011DU3ta>t7/Z\"bG\"LgnZ\"bY\u000e,H.\u0019;pe\u0006Q\"/Z:q_:\u001cXmQ1dQ&twmQ1mGVd\u0017\r^8sA\u0005I\"/Z:q_:\u001cXmU3sm&twmQ1mGVd\u0017\r^8s+\t\t\t\u0002E\u0002S\u0003'I1!!\u0006T\u0005e\u0011Vm\u001d9p]N,7+\u001a:wS:<7)\u00197dk2\fGo\u001c:\u00025I,7\u000f]8og\u0016\u001cVM\u001d<j]\u001e\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u00027I,7\u000f]8og\u0016\u001cV\r\\3di&|gnQ1mGVd\u0017\r^8s+\t\ti\u0002E\u0002S\u0003?I1!!\tT\u0005m\u0011Vm\u001d9p]N,7+\u001a7fGRLwN\\\"bY\u000e,H.\u0019;pe\u0006a\"/Z:q_:\u001cXmU3mK\u000e$\u0018n\u001c8DC2\u001cW\u000f\\1u_J\u0004\u0013!F:ue&\u0004\b*Z1eKJ\u001c\u0015\r\\2vY\u0006$xN]\u000b\u0003\u0003S\u00012AUA\u0016\u0013\r\tic\u0015\u0002\u0016'R\u0014\u0018\u000e\u001d%fC\u0012,'oQ1mGVd\u0017\r^8s\u0003Y\u0019HO]5q\u0011\u0016\fG-\u001a:DC2\u001cW\u000f\\1u_J\u0004\u0013AF:fG>tG-\u0019:z\u0017\u0016L8)\u00197dk2\fGo\u001c:\u0016\u0005\u0005U\u0002c\u0001*\u00028%\u0019\u0011\u0011H*\u0003-M+7m\u001c8eCJL8*Z=DC2\u001cW\u000f\\1u_J\fqc]3d_:$\u0017M]=LKf\u001c\u0015\r\\2vY\u0006$xN\u001d\u0011\u0002)\r,(O]3oi\u0006;WmQ1mGVd\u0017\r^8s+\t\t\t\u0005E\u0002S\u0003\u0007J1!!\u0012T\u0005Q\u0019UO\u001d:f]R\fu-Z\"bY\u000e,H.\u0019;pe\u0006)2-\u001e:sK:$\u0018iZ3DC2\u001cW\u000f\\1u_J\u0004\u0013a\u00054sKNDg.Z:t\u0007\u0006d7-\u001e7bi>\u0014XCAA'!\r\u0011\u0016qJ\u0005\u0004\u0003#\u001a&a\u0005$sKNDg.Z:t\u0007\u0006d7-\u001e7bi>\u0014\u0018\u0001\u00064sKNDg.Z:t\u0007\u0006d7-\u001e7bi>\u0014\b%\u0001\u0005jgNC\u0017M]3e+\u0005!\u0017aA4fiR!\u0011QLA8!\u0015Q\u0017qLA2\u0013\r\t\tg\u001b\u0002\u0007\rV$XO]3\u0011\u000b1\u000b)'!\u001b\n\u0007\u0005\u001dTJ\u0001\u0004PaRLwN\u001c\t\u00049\u0006-\u0014bAA7{\ti!+Z:q_:\u001cX-\u00128uefDq!!\u001d\u0018\u0001\u0004\t\u0019(A\u0002lKf\u00042\u0001XA;\u0013\r\t9(\u0010\u0002\u0010\u000b\u001a4Wm\u0019;jm\u0016,&+S&fs\u0006\u0019\u0001/\u001e;\u0015\r\u0005u\u0014QQAD!\u0015Q\u0017qLA@!\ra\u0015\u0011Q\u0005\u0004\u0003\u0007k%\u0001B+oSRDq!!\u001d\u0019\u0001\u0004\t\u0019\bC\u0004\u0002\nb\u0001\r!!\u001b\u0002\u000b\u0015tGO]=\u0002\rI,Wn\u001c<f)\u0011\ti(a$\t\u000f\u0005E\u0014\u00041\u0001\u0002t\u0005i\u0011N\u001c<bY&$\u0017\r^3LKf$B!a \u0002\u0016\"9\u0011\u0011\u000f\u000eA\u0002\u0005M\u0014!D2bG\"LgnZ!di&|g\u000e\u0006\u0004\u0002\u001c\u0006\u0005\u0016\u0011\u0018\t\u0004%\u0006u\u0015bAAP'\n)\"+Z:q_:\u001cXmQ1dQ&tw-Q2uS>t\u0007bBAR7\u0001\u0007\u0011QU\u0001\be\u0016\fX/Z:u!\u0011\t9+!.\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bq\"Y:z]\u000eDG\u000f\u001e9dY&,g\u000e\u001e\u0006\u00041\u0006=&b\u0001!\u00022*\u0019\u00111W$\u0002\rMD\u0017\rZ3e\u0013\u0011\t9,!+\u0003\u000fI+\u0017/^3ti\"9\u00111X\u000eA\u0002\u0005u\u0016\u0001\u0003:fgB|gn]3\u0011\u0007q\u000by,C\u0002\u0002Bv\u0012\u0011cQ1dQ\u0016\f'\r\\3SKN\u0004xN\\:f\u0003=\u0019X\r\\3di&|g.Q2uS>tGCBAd\u0003\u001b\fy\rE\u0002S\u0003\u0013L1!a3T\u0005]\u0011Vm\u001d9p]N,7+\u001a7fGRLwN\\!di&|g\u000eC\u0004\u0002$r\u0001\r!!*\t\u000f\u0005EG\u00041\u0001\u0002T\u00069QM\u001c;sS\u0016\u001c\bCBAk\u0003K\fIG\u0004\u0003\u0002X\u0006\u0005h\u0002BAm\u0003?l!!a7\u000b\u0007\u0005u\u0017*\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0019\u00111]'\u0002\u000fA\f7m[1hK&!\u0011q]Au\u0005\r\u0019V-\u001d\u0006\u0004\u0003Gl\u0015aC:feZ,\u0017i\u0019;j_:$\u0002\"a<\u0002v\u0006]\u0018\u0011 \t\u0004%\u0006E\u0018bAAz'\n\u0019\"+Z:q_:\u001cXmU3sm\u0016\f5\r^5p]\"9\u00111U\u000fA\u0002\u0005\u0015\u0006bBAE;\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003wl\u0002\u0019AA\u007f\u0003)\u0019WO\u001d:f]R\fu-\u001a\t\u0004%\u0006}\u0018b\u0001B\u0001'\n91+Z2p]\u0012\u001c\u0018aH2bY\u000e,H.\u0019;f\rJ,7\u000f\u001b8fgN4%o\\7IKV\u0014\u0018n\u001d;jGR1!q\u0001B\u0005\u0005#\u0001R\u0001TA3\u0003{Dq!a)\u001f\u0001\u0004\u0011Y\u0001E\u0002S\u0005\u001bI1Aa\u0004T\u00051\u0019\u0015m\u00195f%\u0016\fX/Z:u\u0011\u001d\tYL\ba\u0001\u0005'\u00012A\u0015B\u000b\u0013\r\u00119b\u0015\u0002\u000e\u0007\u0006\u001c\u0007.\u001a*fgB|gn]3\u0002)%\u001c8)Y2iK\u0006\u0014G.Z#yi\u0016t7/[8o)\r!'Q\u0004\u0005\b\u0005?y\u0002\u0019\u0001B\u0011\u0003%)\u0007\u0010^3og&|g\u000e\u0005\u0003\u0003$\t%bb\u0001*\u0003&%\u0019!qE*\u0002\u001f\r\u000b7\r[3ESJ,7\r^5wKNLAAa\u000b\u0003.\t92)Y2iK\u0012K'/Z2uSZ,W\t\u001f;f]NLwN\u001c\u0006\u0004\u0005O\u0019\u0016!D5t\u001d>$Xj\u001c3jM&,G\rF\u0002e\u0005gAq!a/!\u0001\u0004\ti,A\u0004jg\u0016\u0013(o\u001c:\u0015\u0007\u0011\u0014I\u0004C\u0004\u0002<\u0006\u0002\r!!0\u0002\u001d%\u001cXK\\:bM\u0016lU\r\u001e5pIR\u0019AMa\u0010\t\u000f\u0005\r&\u00051\u0001\u0002&\u0006\u00192-\u00197dk2\fG/Z\"veJ,g\u000e^!hKRA\u0011Q B#\u0005\u000f\u0012I\u0005C\u0004\u0002$\u000e\u0002\r!!*\t\u000f\u0005%5\u00051\u0001\u0002j!9!1J\u0012A\u0002\t5\u0013a\u0003:fcV,7\u000f\u001e+j[\u0016\u0004BAa\u0014\u0003Z5\u0011!\u0011\u000b\u0006\u0005\u0005'\u0012)&\u0001\u0003uS6,'B\u0001B,\u0003\u0011Q\u0017M^1\n\t\tm#\u0011\u000b\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u00025\r\fGnY;mCR,gI]3tQ:,7o\u001d'jM\u0016$\u0018.\\3\u0015\r\u0005u(\u0011\rB2\u0011\u001d\t\u0019\u000b\na\u0001\u0003KCq!!#%\u0001\u0004\tI'\u0001\nj]Z\fG.\u001b3bi\u0016Le-\u00168tC\u001a,GCBA@\u0005S\u0012Y\u0007C\u0004\u0002$\u0016\u0002\r!!*\t\u000f\u0005mV\u00051\u0001\u0002>\u00061q-\u001a;V%&#bA!\u001d\u0003\u0000\t\u0005\u0005#\u0002'\u0002f\tM\u0004\u0003\u0002B;\u0005wj!Aa\u001e\u000b\t\te$QK\u0001\u0004]\u0016$\u0018\u0002\u0002B?\u0005o\u00121!\u0016*J\u0011\u001d\tYL\na\u0001\u0003{CqAa!'\u0001\u0004\u0011))\u0001\u0006iK\u0006$WM\u001d(b[\u0016\u0004BAa\"\u0003\u0010:!!\u0011\u0012BF!\r\tI.T\u0005\u0004\u0005\u001bk\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0012\nM%AB*ue&twMC\u0002\u0003\u000e6\u000b!#[:O_:,%O]8s%\u0016\u001c\bo\u001c8tKR\u0019AM!'\t\u000f\u0005mv\u00051\u0001\u0002>\u000612-\u00197dk2\fG/Z*fG>tG-\u0019:z\u0017\u0016L8\u000f\u0006\u0004\u0003 \n=&\u0011\u0017\t\u0006\u0019\u0006\u0015$\u0011\u0015\t\t\u0005\u000f\u0013\u0019Ka*\u0003.&!!Q\u0015BJ\u0005\ri\u0015\r\u001d\t\u0004%\n%\u0016b\u0001BV'\nQ\u0001*Z1eKJt\u0015-\\3\u0011\r\u0005U\u0017Q\u001dBC\u0011\u001d\t\u0019\u000b\u000ba\u0001\u0003KCq!a/)\u0001\u0004\u0011\u0019\f\u0005\u0003\u0002(\nU\u0016\u0002\u0002B\\\u0003S\u0013\u0001BU3ta>t7/\u001a\u000b\u000b\u0003{\u0014YL!0\u0003F\n\u001d\u0007bBARS\u0001\u0007!1\u0002\u0005\b\u0003wK\u0003\u0019\u0001B`!\r\u0011&\u0011Y\u0005\u0004\u0005\u0007\u001c&AD*u_J,GMU3ta>t7/\u001a\u0005\b\u0005\u0017J\u0003\u0019\u0001B'\u0011\u001d\u0011I-\u000ba\u0001\u0005\u001b\nAB]3ta>t7/\u001a+j[\u0016\f1cY1mGVd\u0017\r^3US6,Gk\u001c'jm\u0016$\u0002Ba4\u0003R\nM'Q\u001c\t\u0006\u0019\u0006\u0015$Q\n\u0005\b\u0003GS\u0003\u0019AAS\u0011\u001d\u0011)N\u000ba\u0001\u0005/\faa\u001d;biV\u001c\bc\u0001/\u0003Z&\u0019!1\\\u001f\u00037\r\u000b7\r[3bE2,\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tKN#\u0018\r^;t\u0011\u001d\u0011yN\u000ba\u0001\u0005C\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003\u0003d\neXB\u0001Bs\u0015\u0011\u00119O!;\u0002\t!$H\u000f\u001d\u0006\u0005\u0005W\u0014i/A\u0003d_\u0012,7M\u0003\u0003\u0003p\nE\u0018a\u00025b]\u0012dWM\u001d\u0006\u0005\u0005g\u0014)0A\u0003oKR$\u0018P\u0003\u0003\u0003x\u0006=\u0016AA5p\u0013\u0011\u0011YP!:\u0003\u0017!#H\u000f\u001d%fC\u0012,'o]\u0001\u000eG\u0006\u001c\u0007.\u001a*fgB|gn]3\u0015\r\u0005}4\u0011AB\u0002\u0011\u001d\t\u0019k\u000ba\u0001\u0003KCq!a/,\u0001\u0004\ti,\u0001\njgVs7-Y2iK\u0012\u0014Vm\u001d9p]N,Gc\u00013\u0004\n!911\u0002\u0017A\u0002\r5\u0011aA1osB\u0019Aja\u0004\n\u0007\rEQJA\u0002B]f\fqB\u001a:fg\",gNU3ta>t7/\u001a\u000b\u0007\u0003{\u001b9ba\u0007\t\u000f\reQ\u00061\u0001\u0003b\u0006Qa.Z<IK\u0006$WM]:\t\u000f\u0005mV\u00061\u0001\u0002>\u00061r-\u001a8fe\u0006$XmQ1dQ\u0016$'+Z:q_:\u001cX\r\u0006\u0006\u0002>\u000e\u000521EB\u0013\u0007OAq!a)/\u0001\u0004\t)\u000bC\u0004\u0002\n:\u0002\r!!\u001b\t\u000f\u0005mh\u00061\u0001\u0002~\"11\u0011\u0006\u0018A\u0002\u0011\fq![:Ge\u0016\u001c\b.A\u000bbI\u0012\u0014VM^1mS\u0012\fG/[8o\r\u0006LG.\u001a3\u0015\t\u0005u6q\u0006\u0005\b\u0003w{\u0003\u0019AA_\u0003M\tG\r\u001a#jg\u000e|gN\\3di\"+\u0017\rZ3s)\u0011\til!\u000e\t\u000f\u0005m\u0006\u00071\u0001\u0002>\u0006q!/\u001a9mC\u000e,\u0007*Z1eKJ\u001cH\u0003BB\u001e\u0007\u000f\"B!!0\u0004>!91qH\u0019A\u0002\r\u0005\u0013!\u00022m_\u000e\\\u0007c\u0002'\u0004D\t\u0005(\u0011]\u0005\u0004\u0007\u000bj%!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\tY,\ra\u0001\u0003{\u000bAcZ3oKJ\fG/Z\"bG\",'+Z9vKN$H\u0003\u0002B\u0006\u0007\u001bBq!a)3\u0001\u0004\t)+\u0001\fhK:,'/\u0019;f'R|'/\u001a3SKN\u0004xN\\:f)!\u0011yla\u0015\u0004V\re\u0003bBA^g\u0001\u0007\u0011Q\u0018\u0005\b\u0007/\u001a\u0004\u0019\u0001BC\u00035\u0011X-];fgRlU\r\u001e5pI\"911L\u001aA\u0002\t\u0005\u0016\u0001\u00058p[&t\u0017\r^3e\u0011\u0016\fG-\u001a:t\u0003Y9WM\\3sCR,wJ]5hS:\u0014Vm\u001d9p]N,G\u0003CB1\u0007O\u001aIg!\u001d\u0011\u0007I\u001b\u0019'C\u0002\u0004fM\u0013ab\u0014:jO&t'+Z:q_:\u001cX\rC\u0004\u0002$R\u0002\r!!*\t\u000f\tUG\u00071\u0001\u0004lA\u0019Aj!\u001c\n\u0007\r=TJA\u0002J]RDqaa\u001d5\u0001\u0004\u0011\t/A\bsKN\u0004xN\\:f\u0011\u0016\fG-\u001a:t\u00031\u0019HO]5q\u0011\u0016\fG-\u001a:t)\u0019\til!\u001f\u0004|!9\u00111U\u001bA\u0002\u0005\u0015\u0006bBB?k\u0001\u0007\u0011QX\u0001\rQR$\bOU3ta>t7/Z\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u007f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\u000bA\"\u00115d\u0011R$\boQ1dQ\u0016\u0004\"\u0001X\u001d\u0014\u0005eZECABE\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\u0013\u0016\u0004I\u000eU5FABL!\u0011\u0019Ija)\u000e\u0005\rm%\u0002BBO\u0007?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u0005V*\u0001\u0006b]:|G/\u0019;j_:LAa!*\u0004\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class AhcHttpCache
implements CacheDefaults,
Debug {
    private final Cache underlying;
    private final boolean heuristicsEnabled;
    private final ExecutionContext executionContext;
    private final Logger logger;
    private final ResponseCachingCalculator responseCachingCalculator;
    private final ResponseServingCalculator responseServingCalculator;
    private final ResponseSelectionCalculator responseSelectionCalculator;
    private final StripHeaderCalculator stripHeaderCalculator;
    private final SecondaryKeyCalculator secondaryKeyCalculator;
    private final CurrentAgeCalculator currentAgeCalculator;
    private final FreshnessCalculator freshnessCalculator;

    public static boolean $lessinit$greater$default$2() {
        return AhcHttpCache$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String debug(AsyncHttpClientConfig cfg) {
        return Debug.debug$((Debug)this, cfg);
    }

    @Override
    public String debug(Request request) {
        return Debug.debug$((Debug)this, request);
    }

    @Override
    public String debug(Response response) {
        return Debug.debug$((Debug)this, response);
    }

    @Override
    public String debug(HttpResponseStatus responseStatus) {
        return Debug.debug$((Debug)this, responseStatus);
    }

    @Override
    public String debug(HttpHeaders responseHeaders) {
        return Debug.debug$((Debug)this, responseHeaders);
    }

    @Override
    public String debug(List<HttpResponseBodyPart> bodyParts) {
        return Debug.debug$((Debug)this, bodyParts);
    }

    @Override
    public <T> String debug(AsyncHandler<T> handler) {
        return Debug.debug$((Debug)this, handler);
    }

    @Override
    public <T> String debug(FilterContext<T> ctx) {
        return Debug.debug$((Debug)this, ctx);
    }

    @Override
    public String debug(HttpResponseBodyPart bodyPart) {
        return Debug.debug$((Debug)this, bodyPart);
    }

    @Override
    public TreeMap<String, Seq<String>> headersToMap(HttpHeaders headers) {
        return AhcUtilities.headersToMap$(this, headers);
    }

    public boolean isUnderstoodStatusCode(int statusCode) {
        return CacheDefaults.isUnderstoodStatusCode$((CacheDefaults)this, (int)statusCode);
    }

    public boolean isCacheableMethod(String requestMethod) {
        return CacheDefaults.isCacheableMethod$((CacheDefaults)this, (String)requestMethod);
    }

    public boolean isDefaultCacheable(int statusCode) {
        return CacheDefaults.isDefaultCacheable$((CacheDefaults)this, (int)statusCode);
    }

    public boolean containsMatchingHeaders(Map<HeaderName, Seq<String>> presentedHeaders, Map<HeaderName, Seq<String>> nominatedHeaders) {
        return CacheDefaults.containsMatchingHeaders$((CacheDefaults)this, presentedHeaders, nominatedHeaders);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private Logger logger() {
        return this.logger;
    }

    private ResponseCachingCalculator responseCachingCalculator() {
        return this.responseCachingCalculator;
    }

    private ResponseServingCalculator responseServingCalculator() {
        return this.responseServingCalculator;
    }

    private ResponseSelectionCalculator responseSelectionCalculator() {
        return this.responseSelectionCalculator;
    }

    private StripHeaderCalculator stripHeaderCalculator() {
        return this.stripHeaderCalculator;
    }

    private SecondaryKeyCalculator secondaryKeyCalculator() {
        return this.secondaryKeyCalculator;
    }

    private CurrentAgeCalculator currentAgeCalculator() {
        return this.currentAgeCalculator;
    }

    private FreshnessCalculator freshnessCalculator() {
        return this.freshnessCalculator;
    }

    public boolean isShared() {
        return false;
    }

    public Future<Option<ResponseEntry>> get(EffectiveURIKey key) {
        this.logger().debug("get: key = " + key);
        Predef$.MODULE$.require(key != null, (Function0 & Serializable)() -> "key is null");
        return this.underlying.get(key);
    }

    public Future<BoxedUnit> put(EffectiveURIKey key, ResponseEntry entry) {
        this.logger().debug("put: key = " + key + ", entry = " + entry);
        Predef$.MODULE$.require(entry != null, (Function0 & Serializable)() -> "value is null");
        return this.underlying.put(key, entry);
    }

    public Future<BoxedUnit> remove(EffectiveURIKey key) {
        Predef$.MODULE$.require(key != null, (Function0 & Serializable)() -> "key is null");
        return this.underlying.remove(key);
    }

    public void invalidateKey(EffectiveURIKey key) {
        this.underlying.get(key).map((Function1 & Serializable)maybeEntry -> {
            maybeEntry.foreach((Function1 & Serializable)entry -> {
                Some x$1 = new Some((Object)HttpDate$.MODULE$.fromEpochSeconds(0));
                CacheableResponse x$2 = entry.copy$default$1();
                String x$3 = entry.copy$default$2();
                Map<HeaderName, Seq<String>> x$4 = entry.copy$default$3();
                ResponseEntry expiredEntry = entry.copy(x$2, x$3, x$4, (Option<ZonedDateTime>)x$1);
                return $this.put(key$1, expiredEntry);
            });
            return BoxedUnit.UNIT;
        }, this.executionContext());
    }

    public ResponseCachingAction cachingAction(Request request, CacheableResponse response) {
        HttpHeaders headers = response.headers();
        int statusCode = response.getStatusCode();
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        OriginResponse originResponse = this.generateOriginResponse(request, statusCode, headers);
        ResponseCachingAction action = this.responseCachingCalculator().isCacheable(cacheRequest, originResponse);
        return action;
    }

    public ResponseSelectionAction selectionAction(Request request, Seq<ResponseEntry> entries) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        Seq storedResponses = (Seq)entries.map((Function1 & Serializable)entry -> this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders()));
        return this.responseSelectionCalculator().selectResponse(cacheRequest, storedResponses);
    }

    public ResponseServeAction serveAction(Request request, ResponseEntry entry, Seconds currentAge) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        return this.responseServingCalculator().serveResponse(cacheRequest, storedResponse, currentAge);
    }

    public Option<Seconds> calculateFreshnessFromHeuristic(CacheRequest request, CacheResponse response) {
        if (this.heuristicsEnabled) {
            return response.headers().get((Object)new HeaderName("Last-Modified")).map((Function1 & Serializable)lastModifiedString -> {
                ZonedDateTime lastModified = HttpDate$.MODULE$.parse((String)lastModifiedString.head());
                ZonedDateTime lastRequestedAt = HttpDate$.MODULE$.now();
                Seconds timeSinceLastModified = HttpDate$.MODULE$.diff(lastModified, lastRequestedAt);
                int scaledDownSeconds = (int)(0.1 * (double)timeSinceLastModified.seconds());
                Seconds scaledSeconds = Seconds$.MODULE$.seconds((long)scaledDownSeconds);
                return scaledSeconds;
            });
        }
        return None$.MODULE$;
    }

    public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return false;
    }

    public boolean isNotModified(CacheableResponse response) {
        return response.getStatusCode() == 304;
    }

    public boolean isError(CacheableResponse response) {
        int n = response.getStatusCode();
        switch (n) {
            case 500: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnsafeMethod(Request request) {
        block10: {
            String string = request.getMethod();
            switch (string == null ? 0 : string.hashCode()) {
                case -531492226: {
                    if ("OPTIONS".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 70454: {
                    if ("GET".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 2213344: {
                    if ("HEAD".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 80083237: {
                    if ("TRACE".equals(string)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            return false;
        }
        return true;
    }

    public Seconds calculateCurrentAge(Request request, ResponseEntry entry, ZonedDateTime requestTime) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds currentAge = this.calculateCurrentAge(cacheRequest, storedResponse, requestTime, HttpDate$.MODULE$.now());
        return currentAge;
    }

    public Seconds calculateFreshnessLifetime(Request request, ResponseEntry entry) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        StoredResponse storedResponse = this.generateStoredResponse(entry.response(), entry.requestMethod(), entry.nominatedHeaders());
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(cacheRequest, (CacheResponse)storedResponse);
        return freshnessLifetime;
    }

    public void invalidateIfUnsafe(Request request, CacheableResponse response) {
        this.logger().trace("invalidate: request = " + this.debug(request) + ", response = " + this.debug(response));
        if (this.isUnsafeMethod(request) && this.isNonErrorResponse(response)) {
            String requestHost = request.getUri().getHost();
            EffectiveURIKey responseKey = new EffectiveURIKey(request.getMethod(), response.getUri().toJavaNetURI());
            this.invalidateKey(responseKey);
            this.getURI(response, "Content-Location").foreach((Function1 & Serializable)contentLocation -> {
                AhcHttpCache.$anonfun$invalidateIfUnsafe$1(this, requestHost, request, contentLocation);
                return BoxedUnit.UNIT;
            });
            this.getURI(response, "Location").foreach((Function1 & Serializable)location -> {
                AhcHttpCache.$anonfun$invalidateIfUnsafe$2(this, requestHost, request, location);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<URI> getURI(CacheableResponse response, String headerName) {
        return Option$.MODULE$.apply((Object)response.getHeaders().get(headerName)).map((Function1 & Serializable)value -> {
            URI baseURI = response.getUri().toJavaNetURI();
            return baseURI.resolve((String)value);
        });
    }

    public boolean isNonErrorResponse(CacheableResponse response) {
        int n = response.getStatusCode();
        switch (n) {
            default: 
        }
        if (n >= 200 && n < 300) {
            return true;
        }
        return n >= 300 && n < 400;
    }

    public Option<Map<HeaderName, Seq<String>>> calculateSecondaryKeys(Request request, Response response) {
        CacheRequest cacheRequest = this.generateCacheRequest(request);
        TreeMap headers = (TreeMap)this.headersToMap(response.getHeaders()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return this.secondaryKeyCalculator().calculate(cacheRequest, (Map)headers);
    }

    public Seconds calculateCurrentAge(CacheRequest request, StoredResponse response, ZonedDateTime requestTime, ZonedDateTime responseTime) {
        return this.currentAgeCalculator().calculateCurrentAge(request, response, requestTime, responseTime);
    }

    public Option<ZonedDateTime> calculateTimeToLive(Request request, CacheableHttpResponseStatus status, HttpHeaders headers) {
        return new Some((Object)ZonedDateTime.now().plusHours(24L));
    }

    public void cacheResponse(Request request, CacheableResponse response) {
        this.logger().debug("cacheResponse: response = " + this.debug(response));
        CacheableResponse strippedResponse = this.stripHeaders(request, response);
        this.logger().debug("cacheResponse: strippedResponse = " + this.debug(strippedResponse));
        Map nominated = (Map)this.calculateSecondaryKeys(request, strippedResponse).getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        Option<ZonedDateTime> ttl = this.calculateTimeToLive(request, strippedResponse.status(), strippedResponse.headers());
        ResponseEntry entry = new ResponseEntry(strippedResponse, request.getMethod(), (Map<HeaderName, Seq<String>>)nominated, ttl);
        this.put(EffectiveURIKey$.MODULE$.apply(request), entry);
    }

    public boolean isUncachedResponse(Object any) {
        Object object = any;
        if (object instanceof CacheableHttpResponseStatus) {
            return false;
        }
        if (object instanceof HttpHeaders) {
            return false;
        }
        if (object instanceof CacheableHttpResponseBodyPart) {
            return false;
        }
        return !(object instanceof CacheableResponse);
    }

    public CacheableResponse freshenResponse(HttpHeaders newHeaders, CacheableResponse response) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace("freshenResponse: newHeaders = " + newHeaders + ", storedResponse = " + response);
        }
        HttpHeaders headers = response.headers();
        HttpHeaders headersMap = new DefaultHttpHeaders().add(headers);
        List filteredWarnings = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(headersMap.getAll("Warning")).asScala().filter((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)AhcHttpCache.$anonfun$freshenResponse$1(line)))).asJava();
        headersMap.set("Warning", (java.lang.Iterable)filteredWarnings);
        headersMap.set(newHeaders);
        HttpHeaders x$1 = headersMap;
        CacheableHttpResponseStatus x$2 = response.copy$default$1();
        List<CacheableHttpResponseBodyPart> x$3 = response.copy$default$3();
        AsyncHttpClientConfig x$4 = response.copy$default$4();
        return response.copy(x$2, x$1, x$3, x$4);
    }

    public CacheableResponse generateCachedResponse(Request request, ResponseEntry entry, Seconds currentAge, boolean isFresh) {
        return this.replaceHeaders(entry.response(), (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> {
            headers.set("Age", (Object)Long.toString(currentAge.seconds()));
            Object object = !isFresh ? headers.add("Warning", (Object)new Warning(110, "-", "Response is Stale", (Option)None$.MODULE$).toString()) : BoxedUnit.UNIT;
            return headers;
        });
    }

    public CacheableResponse addRevalidationFailed(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)new Warning(111, "-", "Revalidation Failed", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse addDisconnectHeader(CacheableResponse response) {
        return this.replaceHeaders(response, (Function1<HttpHeaders, HttpHeaders>)(Function1 & Serializable)headers -> headers.add("Warning", (Object)new Warning(112, "-", "Disconnected Operation", (Option)None$.MODULE$).toString()));
    }

    public CacheableResponse replaceHeaders(CacheableResponse response, Function1<HttpHeaders, HttpHeaders> block) {
        HttpHeaders newHeadersMap;
        HttpHeaders x$1 = newHeadersMap = (HttpHeaders)block.apply((Object)new DefaultHttpHeaders().add(response.getHeaders()));
        CacheableHttpResponseStatus x$2 = response.copy$default$1();
        List<CacheableHttpResponseBodyPart> x$3 = response.copy$default$3();
        AsyncHttpClientConfig x$4 = response.copy$default$4();
        return response.copy(x$2, x$1, x$3, x$4);
    }

    public CacheRequest generateCacheRequest(Request request) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(request.getHeaders()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        String method = request.getMethod();
        return new CacheRequest(uri, method, (Map)headers);
    }

    public StoredResponse generateStoredResponse(CacheableResponse response, String requestMethod, Map<HeaderName, Seq<String>> nominatedHeaders) {
        URI uri = response.getUri().toJavaNetURI();
        int status = response.getStatusCode();
        HttpHeaders responseHeaders = response.getHeaders();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return new StoredResponse(uri, status, (Map)headers, requestMethod, nominatedHeaders);
    }

    public OriginResponse generateOriginResponse(Request request, int status, HttpHeaders responseHeaders) {
        URI uri = request.getUri().toJavaNetURI();
        TreeMap headers = (TreeMap)this.headersToMap(responseHeaders).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return new Tuple2((Object)new HeaderName(name), (Object)values);
            }
            throw new MatchError((Object)tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return new OriginResponse(uri, status, (Map)headers);
    }

    public CacheableResponse stripHeaders(Request request, CacheableResponse httpResponse) {
        CacheableResponse cacheableResponse;
        OriginResponse originResponse = this.generateOriginResponse(request, httpResponse.getStatusCode(), httpResponse.headers());
        Set stripSet = this.stripHeaderCalculator().stripHeaders((CacheResponse)originResponse);
        if (stripSet.nonEmpty()) {
            Collection stripHeaderNames = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)stripSet.map((Function1 & Serializable)x$1 -> x$1.toString())).asJavaCollection();
            this.logger().debug("massageCachedResponse: stripHeaderNames = " + stripHeaderNames);
            HttpHeaders httpHeaders = httpResponse.getHeaders();
            CollectionConverters$.MODULE$.CollectionHasAsScala(stripHeaderNames).asScala().foreach((Function1 & Serializable)x$1 -> httpHeaders.remove(x$1));
            this.logger().debug("massageCachedResponse: strippedHeaders = " + httpResponse.getHeaders());
            HttpHeaders x$12 = httpResponse.getHeaders();
            CacheableHttpResponseStatus x$2 = httpResponse.copy$default$1();
            List<CacheableHttpResponseBodyPart> x$3 = httpResponse.copy$default$3();
            AsyncHttpClientConfig x$4 = httpResponse.copy$default$4();
            cacheableResponse = httpResponse.copy(x$2, x$12, x$3, x$4);
        } else {
            cacheableResponse = httpResponse;
        }
        CacheableResponse r = cacheableResponse;
        return r;
    }

    public void close() {
        this.underlying.close();
    }

    public String toString() {
        return "AhcHttpCache(" + this.underlying + ")";
    }

    public static final /* synthetic */ void $anonfun$invalidateIfUnsafe$1(AhcHttpCache $this, String requestHost$1, Request request$1, URI contentLocation) {
        if (requestHost$1.equalsIgnoreCase(contentLocation.getHost())) {
            EffectiveURIKey key = new EffectiveURIKey(request$1.getMethod(), contentLocation);
            $this.invalidateKey(key);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$invalidateIfUnsafe$2(AhcHttpCache $this, String requestHost$1, Request request$1, URI location) {
        if (requestHost$1.equalsIgnoreCase(location.getHost())) {
            EffectiveURIKey key = new EffectiveURIKey(request$1.getMethod(), location);
            $this.invalidateKey(key);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$freshenResponse$1(String line) {
        Warning warning = WarningParser$.MODULE$.parse(line);
        return warning.code() < 200;
    }

    public AhcHttpCache(Cache underlying, boolean heuristicsEnabled, ExecutionContext executionContext) {
        this.underlying = underlying;
        this.heuristicsEnabled = heuristicsEnabled;
        this.executionContext = executionContext;
        CacheDefaults.$init$((CacheDefaults)this);
        AhcUtilities.$init$(this);
        Debug.$init$(this);
        Predef$.MODULE$.require(underlying != null, (Function0 & Serializable)() -> "null underlying!");
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.responseCachingCalculator = new ResponseCachingCalculator((org.playframework.cachecontrol.Cache)this);
        this.responseServingCalculator = new ResponseServingCalculator((org.playframework.cachecontrol.Cache)this);
        this.responseSelectionCalculator = new ResponseSelectionCalculator((org.playframework.cachecontrol.Cache)this);
        this.stripHeaderCalculator = new StripHeaderCalculator((org.playframework.cachecontrol.Cache)this);
        this.secondaryKeyCalculator = new SecondaryKeyCalculator();
        this.currentAgeCalculator = new CurrentAgeCalculator();
        this.freshnessCalculator = new FreshnessCalculator((org.playframework.cachecontrol.Cache)this);
    }
}

