/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.handler.intercept;

import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import play.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import play.shaded.ahc.org.asynchttpclient.filter.FilterException;
import play.shaded.ahc.org.asynchttpclient.filter.ResponseFilter;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

