/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;

    public ProtocolConnection openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger) throws SQLException {
        boolean requireSSL;
        boolean trySSL;
        String sslmode = info.getProperty("sslmode");
        if (sslmode == null) {
            trySSL = info.getProperty("ssl") != null;
            requireSSL = trySSL;
        } else if ("disable".equals(sslmode)) {
            trySSL = false;
            requireSSL = false;
        } else if ("require".equals(sslmode) || "verify-ca".equals(sslmode) || "verify-full".equals(sslmode)) {
            trySSL = true;
            requireSSL = true;
        } else {
            throw new PSQLException(GT.tr("Invalid sslmode value: {0}", sslmode), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        boolean requireTCPKeepAlive = Boolean.parseBoolean(info.getProperty("tcpKeepAlive"));
        for (int whichHost = 0; whichHost < hostSpecs.length; ++whichHost) {
            HostSpec hostSpec = hostSpecs[whichHost];
            if (logger.logDebug()) {
                logger.debug("Trying to establish a protocol version 3 connection to " + hostSpec);
            }
            int connectTimeout = 0;
            String connectTimeoutProperty = info.getProperty("connectTimeout", "0");
            try {
                connectTimeout = Integer.parseInt(connectTimeoutProperty) * 1000;
            }
            catch (NumberFormatException nfe) {
                logger.info("Couldn't parse connectTimeout value:" + connectTimeoutProperty);
            }
            PGStream newStream = null;
            try {
                newStream = new PGStream(hostSpec, connectTimeout);
                if (trySSL) {
                    newStream = this.enableSSL(newStream, requireSSL, info, logger, connectTimeout);
                }
                String socketTimeoutProperty = info.getProperty("socketTimeout", "0");
                try {
                    int socketTimeout = Integer.parseInt(socketTimeoutProperty);
                    if (socketTimeout > 0) {
                        newStream.getSocket().setSoTimeout(socketTimeout * 1000);
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.info("Couldn't parse socketTimeout value:" + socketTimeoutProperty);
                }
                newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
                String receiveBufferSizeProperty = info.getProperty("receiveBufferSize", "-1");
                try {
                    int receiveBufferSize = Integer.parseInt(receiveBufferSizeProperty);
                    if (receiveBufferSize > -1) {
                        if (receiveBufferSize > 0) {
                            newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
                        } else {
                            logger.info("Ignore invalid value for receiveBufferSize: " + receiveBufferSize);
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.info("Couldn't parse receiveBufferSize value: " + receiveBufferSizeProperty);
                }
                String sendBufferSizeProperty = info.getProperty("sendBufferSize", "-1");
                try {
                    int sendBufferSize = Integer.parseInt(sendBufferSizeProperty);
                    if (sendBufferSize > -1) {
                        if (sendBufferSize > 0) {
                            newStream.getSocket().setSendBufferSize(sendBufferSize);
                        } else {
                            logger.info("Ignore invalid value for sendBufferSize: " + sendBufferSize);
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.info("Couldn't parse sendBufferSize value: " + sendBufferSizeProperty);
                }
                logger.info("Receive Buffer Size is " + newStream.getSocket().getReceiveBufferSize());
                logger.info("Send Buffer Size is " + newStream.getSocket().getSendBufferSize());
                ArrayList<String[]> paramList = new ArrayList<String[]>();
                paramList.add(new String[]{"user", user});
                paramList.add(new String[]{"database", database});
                paramList.add(new String[]{"client_encoding", "UTF8"});
                paramList.add(new String[]{"DateStyle", "ISO"});
                paramList.add(new String[]{"TimeZone", this.createPostgresTimeZone()});
                paramList.add(new String[]{"extra_float_digits", "2"});
                String currentSchema = info.getProperty("currentSchema");
                if (currentSchema != null) {
                    paramList.add(new String[]{"search_path", currentSchema});
                }
                String[][] params = (String[][])paramList.toArray((T[])new String[0][]);
                this.sendStartupPacket(newStream, params, logger);
                this.doAuthentication(newStream, hostSpec.getHost(), user, info, logger);
                ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database, info, logger, connectTimeout);
                this.readStartupMessages(newStream, protoConnection, logger);
                this.runInitialQueries(protoConnection, info, logger);
                return protoConnection;
            }
            catch (UnsupportedProtocolException upe) {
                if (logger.logDebug()) {
                    logger.debug("Protocol not supported, abandoning connection.");
                }
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return null;
            }
            catch (ConnectException cex) {
                if (whichHost + 1 < hostSpecs.length) continue;
                throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                if (newStream != null) {
                    try {
                        newStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (whichHost + 1 < hostSpecs.length) continue;
                throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                if (newStream != null) {
                    try {
                        newStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (whichHost + 1 < hostSpecs.length) continue;
                throw se;
            }
        }
        throw new PSQLException(GT.tr("The connection url is invalid."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        if (sign == '+') {
            start = "GMT-";
        } else if (sign == '-') {
            start = "GMT+";
        } else {
            return tz;
        }
        return start + tz.substring(4);
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, Logger logger, int connectTimeout) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLOk");
                }
                MakeSSL.convert(pgStream, info, logger);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the SSL connection."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, String[][] params, Logger logger) throws IOException {
        int i;
        if (logger.logDebug()) {
            StringBuffer details = new StringBuffer();
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 != 0) {
                    details.append(", ");
                }
                details.append(params[i2][0]);
                details.append("=");
                details.append(params[i2][1]);
            }
            logger.debug(" FE=> StartupPacket(" + details + ")");
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.length * 2][];
        for (i = 0; i < params.length; ++i) {
            encodedParams[i * 2] = params[i][0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params[i][1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.SendInteger4(++length);
        pgStream.SendInteger2(3);
        pgStream.SendInteger2(0);
        for (i = 0; i < encodedParams.length; ++i) {
            pgStream.Send(encodedParams[i]);
            pgStream.SendChar(0);
        }
        pgStream.SendChar(0);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String host, String user, Properties info, Logger logger) throws IOException, SQLException {
        String password = info.getProperty("password");
        block11: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    if (l_elen > 30000) {
                        throw new UnsupportedProtocolException();
                    }
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(errorMsg);
                }
                case 82: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    int areq = pgStream.ReceiveInteger4();
                    switch (areq) {
                        case 4: {
                            byte[] salt = pgStream.Receive(2);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqCrypt(salt='" + new String(salt, "US-ASCII") + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedResult = UnixCrypt.crypt(salt, password.getBytes("UTF-8"));
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(crypt='" + new String(encodedResult, "US-ASCII") + "')");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 5: {
                            byte[] md5Salt = pgStream.Receive(4);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(md5digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 3: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqPassword");
                                logger.debug(" FE=> Password(password=<not shown>)");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedPassword = password.getBytes("UTF-8");
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedPassword.length + 1);
                            pgStream.Send(encodedPassword);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block11;
                        }
                        case 7: 
                        case 9: {
                            MakeGSS.authenticate(pgStream, host, user, password, info.getProperty("jaasApplicationName"), info.getProperty("kerberosServerName"), logger, Boolean.parseBoolean(info.getProperty("useSpnego")));
                            continue block11;
                        }
                        case 0: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (logger.logDebug()) {
                        logger.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection, Logger logger) throws IOException, SQLException {
        int beresp;
        block12: while (true) {
            beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (pgStream.ReceiveInteger4() != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    char tStatus = (char)pgStream.ReceiveChar();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ReadyForQuery(" + tStatus + ")");
                    }
                    switch (tStatus) {
                        case 'I': {
                            protoConnection.setTransactionState(0);
                            break;
                        }
                        case 'T': {
                            protoConnection.setTransactionState(1);
                            break;
                        }
                        case 'E': {
                            protoConnection.setTransactionState(2);
                            break;
                        }
                    }
                    return;
                }
                case 75: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    if (l_msgLen != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                    }
                    int pid = pgStream.ReceiveInteger4();
                    int ckey = pgStream.ReceiveInteger4();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block12;
                }
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + l_errorMsg + ")");
                    }
                    throw new PSQLException(l_errorMsg);
                }
                case 78: {
                    int l_nlen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_warnMsg = new ServerErrorMessage(pgStream.ReceiveString(l_nlen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE NoticeResponse(" + l_warnMsg + ")");
                    }
                    protoConnection.addWarning(new PSQLWarning(l_warnMsg));
                    continue block12;
                }
                case 83: {
                    int l_len = pgStream.ReceiveInteger4();
                    String name = pgStream.ReceiveString();
                    String value = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("server_version")) {
                        protoConnection.setServerVersion(value);
                        continue block12;
                    }
                    if (name.equals("client_encoding")) {
                        if (!value.equals("UTF8")) {
                            throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                        }
                        pgStream.setEncoding(Encoding.getDatabaseEncoding("UTF8"));
                        continue block12;
                    }
                    if (name.equals("standard_conforming_strings")) {
                        if (value.equals("on")) {
                            protoConnection.setStandardConformingStrings(true);
                            continue block12;
                        }
                        if (value.equals("off")) {
                            protoConnection.setStandardConformingStrings(false);
                            continue block12;
                        }
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                    }
                    if (!name.equals("integer_datetimes")) continue block12;
                    if (value.equals("on")) {
                        protoConnection.setIntegerDateTimes(true);
                        continue block12;
                    }
                    if (value.equals("off")) {
                        protoConnection.setIntegerDateTimes(false);
                        continue block12;
                    }
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                }
            }
            break;
        }
        if (logger.logDebug()) {
            logger.debug("invalid message type=" + (char)beresp);
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void runInitialQueries(ProtocolConnection protoConnection, Properties info, Logger logger) throws SQLException {
        String appName;
        String dbVersion = protoConnection.getServerVersion();
        if (dbVersion.compareTo("9.0") >= 0) {
            SetupQueryRunner.run(protoConnection, "SET extra_float_digits = 3", false);
        }
        if ((appName = info.getProperty("ApplicationName")) != null && dbVersion.compareTo("9.0") >= 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("SET application_name = '");
            Utils.appendEscapedLiteral(sql, appName, protoConnection.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(protoConnection, sql.toString(), false);
        }
    }

    private static class UnsupportedProtocolException
    extends IOException {
        private UnsupportedProtocolException() {
        }
    }
}

