/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;

public abstract class BlockDoor
extends BlockTransparentMeta
implements Faceable {
    public static int DOOR_OPEN_BIT = 4;
    public static int DOOR_TOP_BIT = 8;
    public static int DOOR_HINGE_BIT = 1;
    public static int DOOR_POWERED_BIT = 2;

    protected BlockDoor(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public int getFullDamage() {
        int meta = this.isTop() ? this.down().getDamage() : this.getDamage();
        return (this.getId() << 5) + (meta & 7 | (this.isTop() ? 8 : 0) | (this.isRightHinged() ? 16 : 0));
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        double f = 0.1875;
        SimpleAxisAlignedBB bb = new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 2.0, this.z + 1.0);
        int j = this.isTop() ? this.down().getDamage() & 3 : this.getDamage() & 3;
        boolean isOpen = this.isOpen();
        boolean isRight = this.isRightHinged();
        if (j == 0) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
                } else {
                    bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
            }
        } else if (j == 1) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
            }
        } else if (j == 2) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
                }
            } else {
                bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
            }
        } else if (j == 3) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
            }
        }
        return bb;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            Block up = this.up();
            if (up instanceof BlockDoor) {
                this.getLevel().setBlock((Vector3)up, new BlockAir(), false);
                this.getLevel().useBreakOn(this);
            }
            return 1;
        }
        if (type == 6) {
            if (!this.level.getServer().isRedstoneEnabled()) {
                return 0;
            }
            if (!this.isOpen() && this.level.isBlockPowered(this.getLocation()) || this.isOpen() && !this.level.isBlockPowered(this.getLocation())) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                this.toggle(null);
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.y > 254.0) {
            return false;
        }
        if (face == BlockFace.UP) {
            Block blockUp = this.up();
            Block blockDown = this.down();
            if (!blockUp.canBeReplaced() || blockDown.isTransparent()) {
                return false;
            }
            int[] faces = new int[]{1, 2, 3, 0};
            int direction = faces[player != null ? player.getDirection().getHorizontalIndex() : 0];
            Block left = this.getSide(player.getDirection().rotateYCCW());
            Block right = this.getSide(player.getDirection().rotateY());
            int metaUp = DOOR_TOP_BIT;
            if (left.getId() == this.getId() || !right.isTransparent() && left.isTransparent()) {
                metaUp |= DOOR_HINGE_BIT;
            }
            this.setDamage(direction);
            this.getLevel().setBlock((Vector3)block, this, true, false);
            if (blockUp instanceof BlockLiquid && ((BlockLiquid)blockUp).usesWaterLogging()) {
                this.getLevel().setBlock(blockUp, 1, blockUp, true, false);
            }
            this.getLevel().setBlock((Vector3)blockUp, Block.get(this.getId(), metaUp), true, true);
            if (this.level.getServer().isRedstoneEnabled() && !this.isOpen() && this.level.isBlockPowered(this.getLocation())) {
                this.toggle(null);
                this.getLevel().setBlockDataAt(blockUp.getFloorX(), blockUp.getFloorY(), blockUp.getFloorZ(), metaUp |= DOOR_POWERED_BIT);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isTop(this.getDamage())) {
            Block down = this.down();
            if (down.getId() == this.getId()) {
                this.getLevel().setBlock((Vector3)down, new BlockAir(), true);
            }
        } else {
            Block up = this.up();
            if (up.getId() == this.getId()) {
                this.getLevel().setBlock((Vector3)up, new BlockAir(), true);
            }
        }
        this.getLevel().setBlock((Vector3)this, new BlockAir(), true);
        return true;
    }

    @Override
    public boolean onActivate(Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (!this.toggle(player)) {
            return false;
        }
        this.level.addSound(this, this.isOpen() ? Sound.RANDOM_DOOR_OPEN : Sound.RANDOM_DOOR_CLOSE);
        return true;
    }

    public boolean toggle(Player player) {
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        Block down = this.isTop() ? this.down() : this;
        if (down.up().getId() != down.getId()) {
            return false;
        }
        down.setDamage(down.getDamage() ^ DOOR_OPEN_BIT);
        this.getLevel().setBlock((Vector3)down, down, true, true);
        return true;
    }

    public boolean isOpen() {
        if (this.isTop(this.getDamage())) {
            return (this.down().getDamage() & DOOR_OPEN_BIT) > 0;
        }
        return (this.getDamage() & DOOR_OPEN_BIT) > 0;
    }

    public boolean isTop() {
        return this.isTop(this.getDamage());
    }

    public boolean isTop(int meta) {
        return (meta & DOOR_TOP_BIT) != 0;
    }

    public boolean isRightHinged() {
        if (this.isTop()) {
            return (this.getDamage() & DOOR_HINGE_BIT) > 0;
        }
        return (this.up().getDamage() & DOOR_HINGE_BIT) > 0;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

