/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockDirt;
import cn.nukkit.block.BlockFarmland;
import cn.nukkit.block.BlockGrassPath;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.generator.object.ObjectTallGrass;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockGrass
extends BlockDirt {
    public BlockGrass() {
        this(0);
    }

    public BlockGrass(int meta) {
        super(0);
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public String getName() {
        return "Grass Block";
    }

    @Override
    public boolean onActivate(Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            ObjectTallGrass.growGrass(this.getLevel(), this, new NukkitRandom());
            return true;
        }
        if (item.isHoe()) {
            item.useOn(this);
            this.getLevel().setBlock(this, new BlockFarmland());
            return true;
        }
        if (item.isShovel()) {
            item.useOn(this);
            this.getLevel().setBlock(this, new BlockGrassPath());
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && this.getLevel().getFullLight(this.add(0.0, 1.0, 0.0)) >= 9) {
            NukkitRandom random = new NukkitRandom();
            this.x = random.nextRange((int)this.x - 1, (int)this.x + 1);
            this.y = random.nextRange((int)this.y - 2, (int)this.y + 2);
            this.z = random.nextRange((int)this.z - 1, (int)this.z + 1);
            Block block = this.getLevel().getBlock(new Vector3(this.x, this.y, this.z));
            if (block.getId() == 3 && block.getDamage() == 0) {
                if (block.up() instanceof BlockAir) {
                    BlockSpreadEvent ev = new BlockSpreadEvent(block, this, new BlockGrass());
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock(block, ev.getNewState());
                    }
                }
            } else if (block.getId() == 2 && block.up() instanceof BlockSolid) {
                BlockSpreadEvent ev = new BlockSpreadEvent(block, this, new BlockDirt());
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock(block, ev.getNewState());
                }
            }
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GRASS_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int getFullId() {
        return this.getId() << 6;
    }

    @Override
    public void setDamage(int meta) {
    }
}

