/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemItemFrame;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.Random;

public class BlockItemFrame
extends BlockTransparentMeta {
    public BlockItemFrame() {
        this(0);
    }

    public BlockItemFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 199;
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.getSideAtLayer(0, this.getFacing()).isTransparent()) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)blockEntity;
        if (itemFrame == null) {
            itemFrame = (BlockEntityItemFrame)BlockEntity.createBlockEntity("ItemFrame", (Position)this, BlockEntity.getDefaultCompound(this, "ItemFrame").putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f), new Object[0]);
        }
        if (itemFrame == null) {
            return false;
        }
        if (itemFrame.getItem().getId() == 0) {
            Item itemOnFrame = item.clone();
            if (player != null && player.isSurvival()) {
                itemOnFrame.setCount(itemOnFrame.getCount() - 1);
                player.getInventory().setItemInHand(itemOnFrame);
            }
            itemOnFrame.setCount(1);
            itemFrame.setItem(itemOnFrame);
            this.getLevel().addSound(this, Sound.BLOCK_ITEMFRAME_ADD_ITEM);
        } else {
            itemFrame.setItemRotation((itemFrame.getItemRotation() + 1) % 8);
            this.getLevel().addSound(this, Sound.BLOCK_ITEMFRAME_ROTATE_ITEM);
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!target.isTransparent() && face.getIndex() > 1 && !block.isSolid()) {
            BlockEntityItemFrame frame;
            switch (face) {
                case NORTH: {
                    this.setDamage(3);
                    break;
                }
                case SOUTH: {
                    this.setDamage(2);
                    break;
                }
                case WEST: {
                    this.setDamage(1);
                    break;
                }
                case EAST: {
                    this.setDamage(0);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.getLevel().setBlock((Vector3)block, this, true, true);
            CompoundTag nbt = new CompoundTag().putString("id", "ItemFrame").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f);
            if (item.hasCustomBlockData()) {
                for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                    nbt.put(aTag.getName(), aTag);
                }
            }
            if ((frame = (BlockEntityItemFrame)BlockEntity.createBlockEntity("ItemFrame", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0])) == null) {
                return false;
            }
            this.getLevel().addSound(this, Sound.BLOCK_ITEMFRAME_PLACE);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, this.layer, new BlockAir(), true, true);
        this.getLevel().addSound(this, Sound.BLOCK_ITEMFRAME_REMOVE_ITEM);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)blockEntity;
        int chance = new Random().nextInt(100) + 1;
        if (itemFrame != null && (float)chance <= itemFrame.getItemDropChance() * 100.0f) {
            return new Item[]{this.toItem(), itemFrame.getItem().clone()};
        }
        return new Item[]{this.toItem()};
    }

    @Override
    public Item toItem() {
        return new ItemItemFrame();
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityItemFrame) {
            return ((BlockEntityItemFrame)blockEntity).getAnalogOutput();
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        switch (this.getDamage() & 3) {
            case 0: {
                return BlockFace.WEST;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
        }
        return null;
    }

    @Override
    public double getHardness() {
        return 0.25;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

