/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemKelp;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;

public class BlockKelp
extends BlockFlowable {
    public BlockKelp() {
        this(0);
    }

    public BlockKelp(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 393;
    }

    @Override
    public String getName() {
        return "Kelp";
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int waterDamage;
        Block down = this.down();
        Block layer1Block = block.getLevelBlockAtLayer(1);
        if ((down.getId() == 393 || down.isSolid()) && down.getId() != 213 && down.getId() != 79 && down.getId() != 88 && layer1Block instanceof BlockWater && ((waterDamage = block.getDamage()) == 0 || waterDamage == 8)) {
            if (waterDamage == 8) {
                this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
            }
            if (down.getId() == 393 && down.getDamage() != 24) {
                down.setDamage(24);
                this.getLevel().setBlock((Vector3)down, down, true, true);
            }
            this.setDamage(ThreadLocalRandom.current().nextInt(25));
            this.getLevel().setBlock((Vector3)this, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block blockLayer1 = this.getLevelBlockAtLayer(1);
            int waterDamage = 0;
            if (!(blockLayer1 instanceof BlockIceFrosted) && (!(blockLayer1 instanceof BlockWater) || (waterDamage = blockLayer1.getDamage()) != 0 && waterDamage != 8)) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            Block down = this.down();
            if (!down.isSolid() && down.getId() != 393 || down.getId() == 213 || down.getId() == 79 || down.getId() == 88) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            if (waterDamage == 8) {
                this.getLevel().setBlock(this, 1, new BlockWater(), true, false);
            }
            return type;
        }
        if (type == 2) {
            if (ThreadLocalRandom.current().nextInt(100) <= 14) {
                this.grow();
            }
            return type;
        }
        return super.onUpdate(type);
    }

    public boolean grow() {
        Block up;
        int age = MathHelper.clamp(this.getDamage(), 0, 25);
        if (age < 25 && ((up = this.up()) instanceof BlockWater && up.getDamage() == 0 || up.getDamage() == 8)) {
            BlockKelp grown = new BlockKelp(age + 1);
            BlockGrowEvent ev = new BlockGrowEvent(this, grown);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.setDamage(25);
                this.getLevel().setBlock(this, 0, this, true, true);
                this.getLevel().setBlock(up, 1, new BlockWater(), true, false);
                this.getLevel().setBlock(up, 0, ev.getNewState(), true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block down = this.down();
        if (down.getId() == 393) {
            this.getLevel().setBlock((Vector3)down, new BlockKelp(ThreadLocalRandom.current().nextInt(25)), true, true);
        }
        this.getLevel().setBlock((Vector3)this, new BlockAir(), true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            int x = (int)this.x;
            int z = (int)this.z;
            for (int y = (int)this.y + 1; y < 255; ++y) {
                BlockKelp highestKelp;
                int waterData;
                int blockIdAbove = this.getLevel().getBlockIdAt(x, y, z);
                if (blockIdAbove == 393) continue;
                if (!(blockIdAbove != 8 && blockIdAbove != 9 || (waterData = this.getLevel().getBlockDataAt(x, y, z)) != 0 && waterData != 8 || !(highestKelp = (BlockKelp)this.getLevel().getBlock(x, y - 1, z)).grow())) {
                    this.level.addParticle(new BoneMealParticle(this));
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemKelp();
    }

    @Override
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }
}

