/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockNetherPortal
extends BlockFlowable
implements Faceable {
    public BlockNetherPortal() {
        this(0);
    }

    public BlockNetherPortal(int meta) {
        super(0);
    }

    @Override
    public String getName() {
        return "Nether Portal Block";
    }

    @Override
    public int getId() {
        return 90;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public int getLightLevel() {
        return 11;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockAir());
    }

    @Override
    public boolean onBreak(Item item) {
        boolean result = super.onBreak(item);
        for (BlockFace face : BlockFace.values()) {
            Block b = this.getSide(face);
            if (b == null || !(b instanceof BlockNetherPortal)) continue;
            result &= b.onBreak(item);
        }
        return result;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    public static void spawnPortal(Position pos) {
        Level lvl = pos.level;
        int x = pos.getFloorX();
        int y = pos.getFloorY();
        int z = pos.getFloorZ();
        for (int xx = -1; xx < 4; ++xx) {
            for (int yy = 1; yy < 4; ++yy) {
                for (int zz = -1; zz < 3; ++zz) {
                    lvl.setBlockAt(x + xx, y + yy, z + zz, 0);
                }
            }
        }
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x, y, ++z, 49);
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x + 1, y, ++z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x, ++y, --z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 90);
        lvl.setBlockAt(x + 2, y, z, 90);
        lvl.setBlockAt(x + 3, y, z, 49);
        lvl.setBlockAt(x, ++y, z, 49);
        lvl.setBlockAt(x + 1, y, z, 49);
        lvl.setBlockAt(x + 2, y, z, 49);
        lvl.setBlockAt(x + 3, y, z, 49);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }
}

