/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySkull;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSkull;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;

public class BlockSkull
extends BlockTransparentMeta {
    public BlockSkull() {
        this(0);
    }

    public BlockSkull(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 144;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public String getName() {
        BlockEntity blockEntity;
        int itemMeta = 0;
        if (this.level != null && (blockEntity = this.getLevel().getBlockEntity(this)) != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return ItemSkull.getItemSkullName(itemMeta);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntitySkull skull;
        switch (face) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: 
            case UP: {
                this.setDamage(face.getIndex());
                break;
            }
            default: {
                return false;
            }
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag().putString("id", "Skull").putByte("SkullType", item.getDamage()).putInt("x", block.getFloorX()).putInt("y", block.getFloorY()).putInt("z", block.getFloorZ()).putByte("Rot", (int)Math.floor(player.yaw * 16.0 / 360.0 + 0.5) & 0xF);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        return (skull = (BlockEntitySkull)BlockEntity.createBlockEntity("Skull", this.getLevel().getChunk((int)block.x >> 4, (int)block.z >> 4), nbt, new Object[0])) != null;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        int dropMeta = 0;
        if (blockEntity != null) {
            dropMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return new Item[]{new ItemSkull((Integer)dropMeta)};
    }

    @Override
    public Item toItem() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        int itemMeta = 0;
        if (blockEntity != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return new ItemSkull((Integer)itemMeta);
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

