/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.block.BlockMelon;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSeedsMelon;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class BlockStemMelon
extends BlockCrops {
    public BlockStemMelon() {
        this(0);
    }

    public BlockStemMelon(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 105;
    }

    @Override
    public String getName() {
        return "Melon Stem";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() != 60) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            NukkitRandom random = new NukkitRandom();
            if (random.nextRange(1, 2) == 1 && this.getLevel().getFullLight(this) >= 9) {
                if (this.getDamage() < 7) {
                    Block block = this.clone();
                    block.setDamage(block.getDamage() + 1);
                    BlockGrowEvent ev = new BlockGrowEvent(this, block);
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock((Vector3)this, ev.getNewState(), true);
                    }
                    return 2;
                }
                for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
                    Block b = this.getSide(face);
                    if (b.getId() != 103) continue;
                    return 2;
                }
                Block side = this.getSide(BlockFace.Plane.HORIZONTAL.random(random));
                Block d = side.down();
                if (side.getId() == 0 && (d.getId() == 60 || d.getId() == 2 || d.getId() == 3)) {
                    BlockGrowEvent ev = new BlockGrowEvent(side, new BlockMelon());
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock((Vector3)side, ev.getNewState(), true);
                    }
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemSeedsMelon();
    }

    @Override
    public Item[] getDrops(Item item) {
        NukkitRandom random = new NukkitRandom();
        return new Item[]{new ItemSeedsMelon((Integer)0, random.nextRange(0, 3))};
    }
}

