/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockGlass;
import cn.nukkit.block.BlockIce;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockWall;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.mob.EntityGhast;
import cn.nukkit.entity.mob.EntityPhantom;
import cn.nukkit.entity.passive.EntityBat;
import cn.nukkit.entity.passive.EntityChicken;
import cn.nukkit.entity.passive.EntityTurtle;
import cn.nukkit.event.Event;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.block.TurtleEggHatchEvent;
import cn.nukkit.event.entity.CreatureSpawnEvent;
import cn.nukkit.event.entity.EntityInteractEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockTurtleEgg
extends BlockFlowable {
    public static final int CRACK_STATE_NO_CRACKS = 0;
    public static final int CRACK_STATE_CRACKED = 1;
    public static final int CRACK_STATE_MAX_CRACKED = 2;

    public BlockTurtleEgg() {
        this(0);
    }

    public BlockTurtleEgg(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 414;
    }

    @Override
    public String getName() {
        return "Turtle Egg";
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    public int getEggCount() {
        return (this.getDamage() & 3) + 1;
    }

    public void setEggCount(int eggCount) {
        this.setDamage(this.getDamage() & 0x3C | eggCount - 1 & 3);
    }

    public int getCrackState() {
        return Math.min(this.getDamage() >> 2 & 3, 2);
    }

    public void setCrackState(int crackState) {
        crackState = MathHelper.clamp(crackState, 0, 2);
        this.setDamage(this.getDamage() & 0x33 | crackState << 2);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (!(item.getBlock() == null || item.getBlock().getId() != 414 || player != null && player.isSneaking())) {
            int eggCount = this.getEggCount();
            if (eggCount >= 4) {
                return false;
            }
            BlockTurtleEgg newState = new BlockTurtleEgg(this.getDamage());
            newState.setEggCount(eggCount + 1);
            BlockPlaceEvent placeEvent = new BlockPlaceEvent(player, newState, this, this.down(), item);
            if (placeEvent.isCancelled()) {
                return false;
            }
            if (!this.level.setBlock((Vector3)this, placeEvent.getBlock(), true, true)) {
                return false;
            }
            Block placeBlock = placeEvent.getBlock();
            this.level.addLevelSoundEvent(this, 6, GlobalBlockPalette.getOrCreateRuntimeId(placeBlock.getId(), placeBlock.getDamage()));
            item.setCount(item.getCount() - 1);
            if (this.down().getId() == 12) {
                this.level.addParticle(new BoneMealParticle(this));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getMinX() {
        return this.x + 0.1875;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.1875;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.75;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.75;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.4375;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.getMinX(), this.getMinY(), this.getMinZ(), this.getMaxX(), this.getMaxY() + 0.25, this.getMaxZ());
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            if (this.down().getId() == 12) {
                float celestialAngle = this.level.calculateCelestialAngle(this.level.getTime(), 1.0f);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                if (0.7 > (double)celestialAngle && (double)celestialAngle > 0.65 || random.nextInt(500) == 0) {
                    int crackState = this.getCrackState();
                    if (crackState < 2) {
                        BlockTurtleEgg newState = this.clone();
                        newState.setCrackState(crackState + 1);
                        BlockGrowEvent event = new BlockGrowEvent(this, newState);
                        this.level.getServer().getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                            this.level.setBlock((Vector3)this, event.getNewState(), true, true);
                        }
                    } else {
                        this.hatch();
                    }
                }
            }
            return type;
        }
        return 0;
    }

    public void hatch() {
        this.hatch(this.getEggCount());
    }

    public void hatch(int eggs) {
        this.hatch(eggs, new BlockAir());
    }

    public void hatch(int eggs, Block newState) {
        TurtleEggHatchEvent turtleEggHatchEvent = new TurtleEggHatchEvent(this, eggs, newState);
        turtleEggHatchEvent.setCancelled(true);
        this.level.getServer().getPluginManager().callEvent(turtleEggHatchEvent);
        int eggsHatching = turtleEggHatchEvent.getEggsHatching();
        if (!turtleEggHatchEvent.isCancelled()) {
            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK);
            boolean hasFailure = false;
            for (int i = 0; i < eggsHatching; ++i) {
                EntityTurtle turtle;
                this.level.addLevelSoundEvent(this, 224);
                CreatureSpawnEvent creatureSpawnEvent = new CreatureSpawnEvent(74, this.add(0.3 + (double)i * 0.2, 0.0, 0.3), CreatureSpawnEvent.SpawnReason.TURTLE_EGG);
                this.level.getServer().getPluginManager().callEvent(creatureSpawnEvent);
                if (!creatureSpawnEvent.isCancelled() && (turtle = (EntityTurtle)Entity.createEntity(creatureSpawnEvent.getEntityNetworkId(), creatureSpawnEvent.getPosition(), new Object[0])) != null) {
                    turtle.setBreedingAge(-24000);
                    turtle.setHomePos(new Vector3(this.x, this.y, this.z));
                    turtle.setDataFlag(0, 11, true);
                    turtle.setScale(0.16f);
                    turtle.spawnToAll();
                    continue;
                }
                if (!turtleEggHatchEvent.isRecalculateOnFailure()) continue;
                turtleEggHatchEvent.setEggsHatching(turtleEggHatchEvent.getEggsHatching() - 1);
                hasFailure = true;
            }
            if (hasFailure) {
                turtleEggHatchEvent.recalculateNewState();
            }
            this.level.setBlock((Vector3)this, turtleEggHatchEvent.getNewState(), true, true);
        }
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity instanceof EntityLiving && !(entity instanceof EntityChicken) && !(entity instanceof EntityBat) && !(entity instanceof EntityGhast) && !(entity instanceof EntityPhantom) && entity.getY() >= this.getMaxY()) {
            Event ev = entity instanceof Player ? new PlayerInteractEvent((Player)entity, null, this, null, PlayerInteractEvent.Action.PHYSICAL) : new EntityInteractEvent(entity, this);
            ev.setCancelled(ThreadLocalRandom.current().nextInt(200) > 0);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.level.useBreakOn(this, null, null, true);
            }
        }
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockTurtleEgg());
    }

    @Override
    public boolean onBreak(Item item) {
        int eggCount = this.getEggCount();
        if (item.getEnchantment(16) == null) {
            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK);
        }
        if (eggCount == 1) {
            return super.onBreak(item);
        }
        this.setEggCount(eggCount - 1);
        return this.level.setBlock((Vector3)this, this, true, true);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isValidSupport(block.down())) {
            return false;
        }
        this.setDamage(0);
        if (this.level.setBlock((Vector3)this, this, true, true)) {
            if (this.down().getId() == 12) {
                this.level.addParticle(new BoneMealParticle(this));
            }
            return true;
        }
        return false;
    }

    public boolean isValidSupport(Block support) {
        if (support instanceof BlockStairs) {
            return (support.getDamage() & 4) == 4;
        }
        if (support instanceof BlockSlab) {
            return (support.getDamage() & 8) == 8;
        }
        if (support instanceof BlockGlass || support instanceof BlockIce || support instanceof BlockWall) {
            return true;
        }
        if (support.getId() == 138 || support.getId() == 154) {
            return true;
        }
        if (support instanceof BlockCauldron) {
            return false;
        }
        return !support.isTransparent();
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public BlockTurtleEgg clone() {
        return (BlockTurtleEgg)super.clone();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SAND_BLOCK_COLOR;
    }
}

