/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.ShulkerBoxInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;

public class BlockUndyedShulkerBox
extends BlockTransparent {
    @Override
    public int getId() {
        return 205;
    }

    @Override
    public String getName() {
        return "Shulker Box";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public Item toItem() {
        ItemBlock item = new ItemBlock(this, (Integer)this.getDamage(), 1);
        BlockEntityShulkerBox t = (BlockEntityShulkerBox)this.getLevel().getBlockEntity(this);
        if (t != null) {
            ShulkerBoxInventory i = t.getRealInventory();
            if (!i.isEmpty()) {
                CompoundTag nbt = item.getNamedTag();
                if (nbt == null) {
                    nbt = new CompoundTag("");
                }
                ListTag<CompoundTag> items = new ListTag<CompoundTag>();
                for (int it = 0; it < i.getSize(); ++it) {
                    if (i.getItem(it).getId() == 0) continue;
                    CompoundTag d = NBTIO.putItemHelper(i.getItem(it), it);
                    items.add(d);
                }
                nbt.put("Items", items);
                item.setCompoundTag(nbt);
            }
            if (t.hasName()) {
                item.setCustomName(t.getName());
            }
        }
        return item;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityShulkerBox box;
        CompoundTag t;
        this.getLevel().setBlock((Vector3)block, this, true);
        CompoundTag nbt = BlockEntity.getDefaultCompound(this, "ShulkerBox").putByte("facing", face.getIndex());
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if ((t = item.getNamedTag()) != null && t.contains("Items")) {
            nbt.putList(t.getList("Items"));
        }
        return (box = (BlockEntityShulkerBox)BlockEntity.createBlockEntity("ShulkerBox", this.getLevel().getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), nbt, new Object[0])) != null;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntityShulkerBox box;
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityShulkerBox) {
                box = (BlockEntityShulkerBox)t;
            } else {
                CompoundTag nbt = BlockEntity.getDefaultCompound(this, "ShulkerBox");
                box = (BlockEntityShulkerBox)BlockEntity.createBlockEntity("ShulkerBox", this.getLevel().getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), nbt, new Object[0]);
                if (box == null) {
                    return false;
                }
            }
            Block block = this.getSide(BlockFace.fromIndex(box.namedTag.getByte("facing")));
            if (!(block instanceof BlockAir || block instanceof BlockLiquid || block instanceof BlockFlowable)) {
                return true;
            }
            player.addWindow(box.getInventory());
        }
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity be = this.getLevel().getBlockEntity(this);
        if (!(be instanceof InventoryHolder)) {
            return 0;
        }
        return ContainerInventory.calculateRedstone(((InventoryHolder)((Object)be)).getInventory());
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

