/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBeehive;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.passive.EntityBee;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class BlockEntityBeehive
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private List<Occupant> occupants;

    public BlockEntityBeehive(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.occupants = new ArrayList<Occupant>(4);
        if (!this.namedTag.contains("ShouldSpawnBees")) {
            this.namedTag.putByte("ShouldSpawnBees", 0);
        }
        if (!this.namedTag.contains("Occupants")) {
            this.namedTag.putList(new ListTag("Occupants"));
        } else {
            ListTag<CompoundTag> occupantsTag = this.namedTag.getList("Occupants", CompoundTag.class);
            for (int i = 0; i < occupantsTag.size(); ++i) {
                this.occupants.add(new Occupant(occupantsTag.get(i)));
            }
        }
        if (this.namedTag.contains("HoneyLevel")) {
            int faceHorizontalIndex = 0;
            Block block = this.getBlock();
            if (block instanceof BlockBeehive) {
                faceHorizontalIndex = block.getDamage() & 3;
                int honeyLevel = this.namedTag.getByte("HoneyLevel");
                BlockBeehive beehive = (BlockBeehive)block;
                beehive.setBlockFace(BlockFace.fromHorizontalIndex(faceHorizontalIndex));
                beehive.setHoneyLevel(honeyLevel);
                beehive.getLevel().setBlock((Vector3)beehive, beehive, true, true);
            }
            this.namedTag.remove("HoneyLevel");
        }
        if (!this.isEmpty()) {
            this.scheduleUpdate();
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        ListTag<CompoundTag> occupantsTag = new ListTag<CompoundTag>("Occupants");
        for (Occupant occupant : this.occupants) {
            occupantsTag.add(occupant.saveNBT());
        }
        this.namedTag.putList(occupantsTag);
    }

    public int getHoneyLevel() {
        Block block = this.getBlock();
        if (block instanceof BlockBeehive) {
            return ((BlockBeehive)block).getHoneyLevel();
        }
        return 0;
    }

    public void setHoneyLevel(int honeyLevel) {
        Block block = this.getBlock();
        if (block instanceof BlockBeehive) {
            ((BlockBeehive)block).setHoneyLevel(honeyLevel);
            block.getLevel().setBlock((Vector3)block, block, true, true);
        }
    }

    public boolean addOccupant(Occupant occupant) {
        this.occupants.add(occupant);
        ListTag<CompoundTag> occupants = this.namedTag.getList("Occupants", CompoundTag.class);
        occupants.add(occupant.saveNBT());
        this.namedTag.putList(occupants);
        this.scheduleUpdate();
        return true;
    }

    public Occupant addOccupant(Entity entity) {
        if (entity instanceof EntityBee) {
            EntityBee bee;
            boolean hasNectar = (bee = (EntityBee)entity).getHasNectar();
            return this.addOccupant(bee, hasNectar ? 2400 : 600, hasNectar, true);
        }
        return this.addOccupant(entity, 600, false, true);
    }

    public Occupant addOccupant(Entity entity, int ticksLeftToStay) {
        return this.addOccupant(entity, ticksLeftToStay, false, true);
    }

    public Occupant addOccupant(Entity entity, int ticksLeftToStay, boolean hasNectar) {
        return this.addOccupant(entity, ticksLeftToStay, hasNectar, true);
    }

    public Occupant addOccupant(Entity entity, int ticksLeftToStay, boolean hasNectar, boolean playSound) {
        entity.saveNBT();
        Occupant occupant = new Occupant(ticksLeftToStay, entity.getSaveId(), entity.namedTag.clone());
        if (!this.addOccupant(occupant)) {
            return null;
        }
        entity.close();
        if (playSound) {
            entity.level.addSound(this, Sound.BLOCK_BEEHIVE_ENTER);
            if (entity.level != null && (entity.level != this.level || this.distanceSquared(this) >= 4.0)) {
                entity.level.addSound(entity, Sound.BLOCK_BEEHIVE_ENTER);
            }
        }
        return occupant;
    }

    public Occupant[] getOccupants() {
        return this.occupants.toArray(new Occupant[0]);
    }

    public boolean removeOccupant(Occupant occupant) {
        return this.occupants.remove(occupant);
    }

    public boolean isHoneyEmpty() {
        return this.getHoneyLevel() == 0;
    }

    public boolean isHoneyFull() {
        return this.getHoneyLevel() == 5;
    }

    public boolean isEmpty() {
        return this.occupants.isEmpty();
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public boolean isSpawnFaceValid(BlockFace face) {
        Block side = this.getSide(face).getLevelBlock();
        return side.canPassThrough() && !(side instanceof BlockLiquid);
    }

    public List<BlockFace> scanValidSpawnFaces() {
        return this.scanValidSpawnFaces(false);
    }

    public List<BlockFace> scanValidSpawnFaces(boolean preferFront) {
        BlockFace beehiveFace;
        Block block;
        if (preferFront && (block = this.getBlock()) instanceof BlockBeehive && this.isSpawnFaceValid(beehiveFace = ((BlockBeehive)block).getBlockFace())) {
            return Collections.singletonList(beehiveFace);
        }
        ArrayList<BlockFace> validFaces = new ArrayList<BlockFace>(4);
        for (int faceIndex = 0; faceIndex < 4; ++faceIndex) {
            BlockFace face = BlockFace.fromHorizontalIndex(faceIndex);
            if (!this.isSpawnFaceValid(face)) continue;
            validFaces.add(face);
        }
        return validFaces;
    }

    public Entity spawnOccupant(Occupant occupant, List<BlockFace> validFaces) {
        EntityBee bee;
        Position lookAt;
        Position spawnPosition;
        if (validFaces != null && validFaces.isEmpty()) {
            return null;
        }
        CompoundTag saveData = occupant.saveData.clone();
        if (validFaces != null) {
            BlockFace face = validFaces.get(RANDOM.nextInt(validFaces.size()));
            spawnPosition = this.add((double)face.getXOffset() * 0.25 - (double)face.getZOffset() * 0.5, (double)face.getYOffset() + (face.getYOffset() < 0 ? -0.4 : 0.2), (double)face.getZOffset() * 0.25 - (double)face.getXOffset() * 0.5);
            saveData.putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("0", spawnPosition.x)).add(new DoubleTag("1", spawnPosition.y)).add(new DoubleTag("2", spawnPosition.z)));
            saveData.putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("0", 0.0)).add(new DoubleTag("1", 0.0)).add(new DoubleTag("2", 0.0)));
            lookAt = this.getSide(face, 2);
        } else {
            spawnPosition = this.add(RANDOM.nextDouble(), 0.2, RANDOM.nextDouble());
            lookAt = spawnPosition.add(RANDOM.nextDouble(), 0.0, RANDOM.nextDouble());
        }
        double dx = lookAt.getX() - spawnPosition.getX();
        double dz = lookAt.getZ() - spawnPosition.getZ();
        float yaw = 0.0f;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.712389f : 1.5707964f;
            yaw -= (float)Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = (float)Math.PI;
        }
        yaw = -yaw * 180.0f / (float)Math.PI;
        saveData.putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("0", yaw)).add(new FloatTag("1", 0.0f)));
        Entity entity = Entity.createEntity(occupant.actorIdentifier, spawnPosition.getChunk(), saveData, new Object[0]);
        if (entity != null) {
            this.removeOccupant(occupant);
            this.level.addSound(this, Sound.BLOCK_BEEHIVE_EXIT);
        }
        EntityBee entityBee = bee = entity instanceof EntityBee ? (EntityBee)entity : null;
        if (occupant.getHasNectar() && occupant.getTicksLeftToStay() <= 0) {
            if (!this.isHoneyFull()) {
                this.setHoneyLevel(this.getHoneyLevel() + 1);
            }
            if (bee != null) {
                bee.nectarDelivered(this);
            }
        } else if (bee != null) {
            bee.leftBeehive(this);
        }
        if (entity != null) {
            entity.spawnToAll();
        }
        return entity;
    }

    @Override
    public void onBreak() {
        if (!this.isEmpty()) {
            for (Occupant occupant : this.getOccupants()) {
                Entity entity = this.spawnOccupant(occupant, null);
                if (this.level != null && this.level.getBlock(this.down()).getId() == 464 || !(entity instanceof EntityBee)) continue;
                ((EntityBee)entity).setAngry(true);
            }
        }
    }

    @Override
    public void onBreak(boolean isSilkTouch) {
        if (!isSilkTouch) {
            this.onBreak();
        }
    }

    public void angerBees(Player player) {
        if (!this.isEmpty()) {
            List<BlockFace> validFaces = this.scanValidSpawnFaces();
            if (this.isSpawnFaceValid(BlockFace.UP)) {
                validFaces.add(BlockFace.UP);
            }
            if (this.isSpawnFaceValid(BlockFace.DOWN)) {
                validFaces.add(BlockFace.DOWN);
            }
            for (Occupant occupant : this.getOccupants()) {
                Entity entity = this.spawnOccupant(occupant, validFaces);
                if (!(entity instanceof EntityBee)) continue;
                EntityBee bee = (EntityBee)entity;
                if (player != null) {
                    bee.setAngry(player);
                    continue;
                }
                bee.setAngry(true);
            }
        }
    }

    @Override
    public boolean onUpdate() {
        if (this.closed || this.isEmpty()) {
            return false;
        }
        this.timing.startTiming();
        List<BlockFace> validSpawnFaces = null;
        for (Occupant occupant : this.getOccupants()) {
            if (--occupant.ticksLeftToStay <= 0) {
                if (validSpawnFaces == null) {
                    validSpawnFaces = this.scanValidSpawnFaces(true);
                }
                if (this.spawnOccupant(occupant, validSpawnFaces) != null) continue;
                occupant.ticksLeftToStay = 600;
                continue;
            }
            if (occupant.isMuted() || !(RANDOM.nextDouble() < 0.005)) continue;
            this.level.addSound(this.add(0.5, 0.0, 0.5), occupant.workSound, 1.0f, occupant.workSoundPitch);
        }
        this.timing.stopTiming();
        return true;
    }

    @Override
    public boolean isBlockEntityValid() {
        int id = this.getBlock().getId();
        return id == 474 || id == 473;
    }

    public static final class Occupant
    implements Cloneable {
        private int ticksLeftToStay;
        private String actorIdentifier;
        private CompoundTag saveData;
        private Sound workSound = Sound.BLOCK_BEEHIVE_WORK;
        private float workSoundPitch = 1.0f;
        private boolean hasNectar;
        private boolean muted;

        public Occupant(int ticksLeftToStay, String actorIdentifier, CompoundTag saveData) {
            this.ticksLeftToStay = ticksLeftToStay;
            this.actorIdentifier = actorIdentifier;
            this.saveData = saveData;
        }

        private Occupant(CompoundTag saved) {
            this.ticksLeftToStay = saved.getInt("TicksLeftToStay");
            this.actorIdentifier = saved.getString("ActorIdentifier");
            this.saveData = saved.getCompound("SaveData").clone();
            if (saved.contains("WorkSound")) {
                try {
                    this.workSound = Sound.valueOf(saved.getString("WorkSound"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (saved.contains("WorkSoundPitch")) {
                this.workSoundPitch = saved.getFloat("WorkSoundPitch");
            }
            this.hasNectar = saved.getBoolean("HasNectar");
            this.muted = saved.getBoolean("Muted");
        }

        public CompoundTag saveNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("ActorIdentifier", this.actorIdentifier).putInt("TicksLeftToStay", this.ticksLeftToStay).putCompound("SaveData", this.saveData).putString("WorkSound", this.workSound.name()).putFloat("WorkSoundPitch", this.workSoundPitch).putBoolean("HasNectar", this.hasNectar).putBoolean("Muted", this.muted);
            return compoundTag;
        }

        public boolean getHasNectar() {
            return this.hasNectar;
        }

        public void setHasNectar(boolean hasNectar) {
            this.hasNectar = hasNectar;
        }

        public int getTicksLeftToStay() {
            return this.ticksLeftToStay;
        }

        public void setTicksLeftToStay(int ticksLeftToStay) {
            this.ticksLeftToStay = ticksLeftToStay;
        }

        public String getActorIdentifier() {
            return this.actorIdentifier;
        }

        public void setActorIdentifier(String actorIdentifier) {
            this.actorIdentifier = actorIdentifier;
        }

        public CompoundTag getSaveData() {
            return this.saveData.clone();
        }

        public void setSaveData(CompoundTag saveData) {
            this.saveData = saveData.clone();
        }

        public Sound getWorkSound() {
            return this.workSound;
        }

        public void setWorkSound(Sound workSound) {
            this.workSound = workSound;
        }

        public float getWorkSoundPitch() {
            return this.workSoundPitch;
        }

        public void setWorkSoundPitch(float workSoundPitch) {
            this.workSoundPitch = workSoundPitch;
        }

        public boolean isMuted() {
            return this.muted;
        }

        public void setMuted(boolean muted) {
            this.muted = muted;
        }

        public String toString() {
            return "Occupant{ticksLeftToStay=" + this.ticksLeftToStay + ", actorIdentifier='" + this.actorIdentifier + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Occupant occupant = (Occupant)o;
            return this.ticksLeftToStay == occupant.ticksLeftToStay && Objects.equals(this.actorIdentifier, occupant.actorIdentifier) && Objects.equals(this.saveData, occupant.saveData);
        }

        public int hashCode() {
            return Objects.hash(this.ticksLeftToStay, this.actorIdentifier, this.saveData);
        }

        protected Occupant clone() {
            try {
                Occupant occupant = (Occupant)super.clone();
                occupant.saveData = this.saveData.clone();
                return occupant;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Unexpected exception", e);
            }
        }
    }
}

