/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockBrewingStand;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.inventory.BrewEvent;
import cn.nukkit.event.inventory.StartBrewEvent;
import cn.nukkit.inventory.BrewingInventory;
import cn.nukkit.inventory.BrewingRecipe;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.ContainerSetDataPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class BlockEntityBrewingStand
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected BrewingInventory inventory;
    public static final int MAX_BREW_TIME = 400;
    public int brewTime = 400;
    public int fuelTotal;
    public int fuelAmount;
    public static final List<Integer> ingredients = new ArrayList<Integer>(){
        {
            this.addAll(Arrays.asList(372, 370, 348, 331, 289, 378, 377, 396, 375, 376, 382, 353, 414, 462, 469, 470, 437));
        }
    };

    public BlockEntityBrewingStand(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new BrewingInventory(this);
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.inventory.setItem(i, this.getItem(i));
        }
        this.brewTime = !this.namedTag.contains("CookTime") || this.namedTag.getShort("CookTime") > 400 ? 400 : this.namedTag.getShort("CookTime");
        this.fuelAmount = this.namedTag.getShort("FuelAmount");
        this.fuelTotal = this.namedTag.getShort("FuelTotal");
        if (this.brewTime < 400) {
            this.scheduleUpdate();
        }
        super.initBlockEntity();
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Brewing Stand";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals("")) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
    }

    @Override
    public void saveNBT() {
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putShort("CookTime", this.brewTime);
        this.namedTag.putShort("FuelAmount", this.fuelAmount);
        this.namedTag.putShort("FuelTotal", this.fuelTotal);
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 117;
    }

    @Override
    public int getSize() {
        return 5;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(new BlockAir(), (Integer)0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public BrewingInventory getInventory() {
        return this.inventory;
    }

    protected boolean checkIngredient(Item ingredient) {
        return ingredients.contains(ingredient.getId());
    }

    @Override
    public boolean onUpdate() {
        if (this.closed) {
            return false;
        }
        boolean ret = false;
        Item ingredient = this.inventory.getIngredient();
        boolean canBrew = false;
        Item fuel = this.getInventory().getFuel();
        if (this.fuelAmount <= 0 && fuel.getId() == 377 && fuel.getCount() > 0) {
            --fuel.count;
            this.fuelAmount = 20;
            this.fuelTotal = 20;
            this.inventory.setFuel(fuel);
            this.sendFuel();
        }
        if (this.fuelAmount > 0) {
            for (int i = 1; i <= 3; ++i) {
                if (this.inventory.getItem(i).getId() != 373) continue;
                canBrew = true;
            }
            if (this.brewTime <= 400 && canBrew && ingredient.getCount() > 0) {
                if (!this.checkIngredient(ingredient)) {
                    canBrew = false;
                }
            } else {
                canBrew = false;
            }
        }
        if (canBrew) {
            if (this.brewTime == 400) {
                this.sendBrewTime();
                StartBrewEvent e = new StartBrewEvent(this);
                this.server.getPluginManager().callEvent(e);
                if (e.isCancelled()) {
                    return false;
                }
            }
            --this.brewTime;
            if (this.brewTime <= 0) {
                BrewEvent e = new BrewEvent(this);
                this.server.getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    for (int i = 1; i <= 3; ++i) {
                        Item potion = this.inventory.getItem(i);
                        ContainerRecipe containerRecipe = Server.getInstance().getCraftingManager().matchContainerRecipe(ingredient, potion);
                        if (containerRecipe != null) {
                            Item result = containerRecipe.getResult();
                            result.setDamage(potion.getDamage());
                            this.inventory.setItem(i, result);
                            continue;
                        }
                        BrewingRecipe recipe = Server.getInstance().getCraftingManager().matchBrewingRecipe(ingredient, potion);
                        if (recipe == null) continue;
                        this.inventory.setItem(i, recipe.getResult());
                    }
                    this.getLevel().addLevelSoundEvent(this, 128);
                    --ingredient.count;
                    this.inventory.setIngredient(ingredient);
                    --this.fuelAmount;
                    this.sendFuel();
                }
                this.brewTime = 400;
            }
            ret = true;
        } else {
            this.brewTime = 400;
        }
        this.lastUpdate = System.currentTimeMillis();
        return ret;
    }

    protected void sendFuel() {
        ContainerSetDataPacket pk = new ContainerSetDataPacket();
        for (Player p : this.inventory.getViewers()) {
            int windowId = p.getWindowId(this.inventory);
            if (windowId <= 0) continue;
            pk.windowId = windowId;
            pk.property = 1;
            pk.value = this.fuelAmount;
            p.dataPacket(pk);
            pk.property = 2;
            pk.value = this.fuelTotal;
            p.dataPacket(pk);
        }
    }

    protected void sendBrewTime() {
        ContainerSetDataPacket pk = new ContainerSetDataPacket();
        pk.property = 0;
        pk.value = this.brewTime;
        for (Player p : this.inventory.getViewers()) {
            int windowId = p.getWindowId(this.inventory);
            if (windowId <= 0) continue;
            pk.windowId = windowId;
            p.dataPacket(pk);
        }
    }

    public void updateBlock() {
        Block block = this.getLevelBlock();
        if (!(block instanceof BlockBrewingStand)) {
            return;
        }
        int meta = 0;
        for (int i = 1; i <= 3; ++i) {
            Item potion = this.inventory.getItem(i);
            int id = potion.getId();
            if (id != 373 && id != 438 && id != 441 || potion.getCount() <= 0) continue;
            meta |= 1 << i - 1;
        }
        block.setDamage(meta);
        this.level.setBlock((Vector3)block, block, false, false);
    }

    public int getFuel() {
        return this.fuelAmount;
    }

    public void setFuel(int fuel) {
        this.fuelAmount = fuel;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag nbt = new CompoundTag().putString("id", "BrewingStand").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("FuelTotal", this.fuelTotal).putShort("FuelAmount", this.fuelAmount);
        if (this.brewTime < 400) {
            nbt.putShort("CookTime", this.brewTime);
        }
        if (this.hasName()) {
            nbt.put("CustomName", this.namedTag.get("CustomName"));
        }
        return nbt;
    }
}

