/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity;

import cn.nukkit.block.BlockAir;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityCreature;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.PlayerEnderChestInventory;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.inventory.PlayerOffhandInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;

public abstract class EntityHumanType
extends EntityCreature
implements InventoryHolder {
    protected PlayerInventory inventory;
    protected PlayerEnderChestInventory enderChestInventory;
    protected PlayerOffhandInventory offhandInventory;

    public EntityHumanType(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public PlayerEnderChestInventory getEnderChestInventory() {
        return this.enderChestInventory;
    }

    public PlayerOffhandInventory getOffhandInventory() {
        return this.offhandInventory;
    }

    @Override
    protected void initEntity() {
        ListTag<CompoundTag> inventoryList;
        this.inventory = new PlayerInventory(this);
        this.offhandInventory = new PlayerOffhandInventory(this);
        if (this.namedTag.contains("Inventory") && this.namedTag.get("Inventory") instanceof ListTag) {
            inventoryList = this.namedTag.getList("Inventory", CompoundTag.class);
            for (CompoundTag item : inventoryList.getAll()) {
                int slot = item.getByte("Slot");
                if (slot >= 0 && slot < 9) {
                    inventoryList.remove(item);
                    continue;
                }
                if (slot >= 100 && slot < 104) {
                    this.inventory.setItem(this.inventory.getSize() + slot - 100, NBTIO.getItemHelper(item));
                    continue;
                }
                if (slot == -106) {
                    this.offhandInventory.setItem(0, NBTIO.getItemHelper(item));
                    continue;
                }
                this.inventory.setItem(slot - 9, NBTIO.getItemHelper(item));
            }
        }
        this.enderChestInventory = new PlayerEnderChestInventory(this);
        if (this.namedTag.contains("EnderItems") && this.namedTag.get("EnderItems") instanceof ListTag) {
            inventoryList = this.namedTag.getList("EnderItems", CompoundTag.class);
            for (CompoundTag item : inventoryList.getAll()) {
                this.enderChestInventory.setItem(item.getByte("Slot"), NBTIO.getItemHelper(item));
            }
        }
        super.initEntity();
    }

    @Override
    public void saveNBT() {
        Item item;
        super.saveNBT();
        ListTag<CompoundTag> inventoryTag = null;
        if (this.inventory != null) {
            Item item2;
            int slot;
            inventoryTag = new ListTag<CompoundTag>("Inventory");
            this.namedTag.putList(inventoryTag);
            for (int slot2 = 0; slot2 < 9; ++slot2) {
                inventoryTag.add(new CompoundTag().putByte("Count", 0).putShort("Damage", 0).putByte("Slot", slot2).putByte("TrueSlot", -1).putShort("id", 0));
            }
            int slotCount = 45;
            for (slot = 9; slot < slotCount; ++slot) {
                item2 = this.inventory.getItem(slot - 9);
                inventoryTag.add(NBTIO.putItemHelper(item2, slot));
            }
            for (slot = 100; slot < 104; ++slot) {
                item2 = this.inventory.getItem(this.inventory.getSize() + slot - 100);
                if (item2 == null || item2.getId() == 0) continue;
                inventoryTag.add(NBTIO.putItemHelper(item2, slot));
            }
        }
        if (this.offhandInventory != null && (item = this.offhandInventory.getItem(0)).getId() != 0) {
            if (inventoryTag == null) {
                inventoryTag = new ListTag("Inventory");
                this.namedTag.putList(inventoryTag);
            }
            inventoryTag.add(NBTIO.putItemHelper(item, -106));
        }
        this.namedTag.putList(new ListTag("EnderItems"));
        if (this.enderChestInventory != null) {
            for (int slot = 0; slot < 27; ++slot) {
                Item item3 = this.enderChestInventory.getItem(slot);
                if (item3 == null || item3.getId() == 0) continue;
                this.namedTag.getList("EnderItems", CompoundTag.class).add(NBTIO.putItemHelper(item3, slot));
            }
        }
    }

    @Override
    public Item[] getDrops() {
        if (this.inventory != null) {
            ArrayList<Item> drops = new ArrayList<Item>(this.inventory.getContents().values());
            drops.addAll(this.offhandInventory.getContents().values());
            return drops.toArray(new Item[0]);
        }
        return new Item[0];
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (this.isClosed() || !this.isAlive()) {
            return false;
        }
        if (source.getCause() != EntityDamageEvent.DamageCause.VOID && source.getCause() != EntityDamageEvent.DamageCause.CUSTOM && source.getCause() != EntityDamageEvent.DamageCause.MAGIC) {
            int armorPoints = 0;
            int epf = 0;
            boolean toughness = false;
            for (Item item : this.inventory.getArmorContents()) {
                armorPoints += item.getArmorPoints();
                epf = (int)((double)epf + this.calculateEnchantmentProtectionFactor(item, source));
            }
            if (source.canBeReducedByArmor()) {
                source.setDamage(-source.getFinalDamage() * (float)armorPoints * 0.04f, EntityDamageEvent.DamageModifier.ARMOR);
            }
            source.setDamage(-source.getFinalDamage() * (float)Math.min(NukkitMath.ceilFloat((float)Math.min(epf, 25) * ((float)ThreadLocalRandom.current().nextInt(50, 100) / 100.0f)), 20) * 0.04f, EntityDamageEvent.DamageModifier.ARMOR_ENCHANTMENTS);
            source.setDamage(-Math.min(this.getAbsorption(), source.getFinalDamage()), EntityDamageEvent.DamageModifier.ABSORPTION);
        }
        if (super.attack(source)) {
            Entity damager = null;
            if (source instanceof EntityDamageByEntityEvent) {
                damager = ((EntityDamageByEntityEvent)source).getDamager();
            }
            for (int slot = 0; slot < 4; ++slot) {
                Item armor = this.inventory.getArmorItem(slot);
                if (armor.hasEnchantments()) {
                    Enchantment durability;
                    if (damager != null) {
                        for (Cloneable cloneable : armor.getEnchantments()) {
                            ((Enchantment)cloneable).doPostAttack(damager, this);
                        }
                    }
                    if ((durability = armor.getEnchantment(17)) != null && durability.getLevel() > 0 && 100 / (durability.getLevel() + 1) <= ThreadLocalRandom.current().nextInt(100)) continue;
                }
                if (armor.isUnbreakable()) continue;
                armor.setDamage(armor.getDamage() + 1);
                if (armor.getDamage() >= armor.getMaxDurability()) {
                    this.inventory.setArmorItem(slot, new ItemBlock(new BlockAir()));
                    continue;
                }
                this.inventory.setArmorItem(slot, armor, true);
            }
            return true;
        }
        return false;
    }

    protected double calculateEnchantmentProtectionFactor(Item item, EntityDamageEvent source) {
        if (!item.hasEnchantments()) {
            return 0.0;
        }
        double epf = 0.0;
        for (Enchantment ench : item.getEnchantments()) {
            epf += (double)ench.getProtectionFactor(source);
        }
        return epf;
    }

    @Override
    public void setOnFire(int seconds) {
        int level = 0;
        for (Item armor : this.inventory.getArmorContents()) {
            Enchantment fireProtection = armor.getEnchantment(1);
            if (fireProtection == null || fireProtection.getLevel() <= 0) continue;
            level = Math.max(level, fireProtection.getLevel());
        }
        seconds = (int)((double)seconds * (1.0 - (double)level * 0.15));
        super.setOnFire(seconds);
    }
}

