/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLava;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityBlockChangeEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityFallingBlock
extends Entity {
    public static final int NETWORK_ID = 66;
    protected int blockId;
    protected int damage;
    protected boolean breakOnLava;

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    public float getLength() {
        return 0.98f;
    }

    @Override
    public float getHeight() {
        return 0.98f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.49f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    public EntityFallingBlock(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag != null) {
            if (this.namedTag.contains("TileID")) {
                this.blockId = this.namedTag.getInt("TileID");
            } else if (this.namedTag.contains("Tile")) {
                this.blockId = this.namedTag.getInt("Tile");
                this.namedTag.putInt("TileID", this.blockId);
            }
            if (this.namedTag.contains("Data")) {
                this.damage = this.namedTag.getByte("Data");
            }
        }
        this.breakOnLava = this.namedTag.getBoolean("BreakOnLava");
        if (this.blockId == 0) {
            this.close();
            return;
        }
        this.setDataProperty(new IntEntityData(2, GlobalBlockPalette.getOrCreateRuntimeId(this.getBlock(), this.getDamage())));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            this.motionY -= (double)this.getGravity();
            this.move(this.motionX, this.motionY, this.motionZ);
            float friction = 1.0f - this.getDrag();
            this.motionX *= (double)friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= (double)friction;
            Vector3 pos = new Vector3(this.x - 0.5, this.y, this.z - 0.5).round();
            if (this.breakOnLava && this.level.getBlock(pos.subtract(0.0, 1.0, 0.0)) instanceof BlockLava) {
                this.close();
                if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                    this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                }
                this.level.addParticle(new DestroyBlockParticle(pos, Block.get(this.getBlock(), this.getDamage())));
                return true;
            }
            if (this.onGround) {
                this.close();
                Block block = this.level.getBlock(pos);
                if (block.getId() > 0 && block.isTransparent() && !block.canBeReplaced()) {
                    if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                        this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                    }
                } else {
                    EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, block, Block.get(this.getBlock(), this.getDamage()));
                    this.server.getPluginManager().callEvent(event);
                    if (!event.isCancelled()) {
                        this.getLevel().setBlock(pos, event.getTo(), true);
                        if (event.getTo().getId() == 145) {
                            this.getLevel().addSound(pos, Sound.RANDOM_ANVIL_LAND);
                        }
                    }
                }
                hasUpdate = true;
            }
            this.updateMovement();
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    public int getBlock() {
        return this.blockId;
    }

    public int getDamage() {
        return this.damage;
    }

    @Override
    public int getNetworkId() {
        return 66;
    }

    @Override
    public void saveNBT() {
        this.namedTag.putInt("TileID", this.blockId);
        this.namedTag.putByte("Data", this.damage);
    }

    @Override
    public boolean canBeMovedByCurrents() {
        return false;
    }
}

