/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;

public class EntityXPOrb
extends Entity {
    public static final int NETWORK_ID = 69;
    public static final int[] ORB_SPLIT_SIZES = new int[]{2477, 1237, 617, 307, 149, 73, 37, 17, 7, 3, 1};
    private int age;
    private int pickupDelay;
    private int exp;
    public Player closestPlayer = null;

    @Override
    public int getNetworkId() {
        return 69;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    public EntityXPOrb(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.setMaxHealth(5);
        this.setHealth(5.0f);
        if (this.namedTag.contains("Health")) {
            this.setHealth(this.namedTag.getShort("Health"));
        }
        if (this.namedTag.contains("Age")) {
            this.age = this.namedTag.getShort("Age");
        }
        if (this.namedTag.contains("PickupDelay")) {
            this.pickupDelay = this.namedTag.getShort("PickupDelay");
        }
        if (this.namedTag.contains("Value")) {
            this.exp = this.namedTag.getShort("Value");
        }
        if (this.exp <= 0) {
            this.exp = 1;
        }
        this.dataProperties.putInt(15, this.exp);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return (source.getCause() == EntityDamageEvent.DamageCause.VOID || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || source.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || source.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            double dZ;
            double dY;
            double dX;
            double d;
            double diff;
            if (this.pickupDelay > 0 && this.pickupDelay < Short.MAX_VALUE) {
                this.pickupDelay -= tickDiff;
                if (this.pickupDelay < 0) {
                    this.pickupDelay = 0;
                }
            } else {
                for (Entity entity : this.level.getCollidingEntities(this.boundingBox, this)) {
                    if (!(entity instanceof Player) || !((Player)entity).pickupEntity(this, false)) continue;
                    return true;
                }
            }
            this.motionY -= (double)this.getGravity();
            if (this.checkObstruction(this.x, this.y, this.z)) {
                hasUpdate = true;
            }
            if (this.closestPlayer == null || this.closestPlayer.distanceSquared(this) > 64.0) {
                for (Player p : this.level.getPlayers().values()) {
                    if (p.isSpectator() || !(p.distance(this) <= 8.0)) continue;
                    this.closestPlayer = p;
                    break;
                }
            }
            if (this.closestPlayer != null && this.closestPlayer.isSpectator()) {
                this.closestPlayer = null;
            }
            if (this.closestPlayer != null && (diff = 1.0 - (d = Math.sqrt((dX = (this.closestPlayer.x - this.x) / 8.0) * dX + (dY = (this.closestPlayer.y + (double)this.closestPlayer.getEyeHeight() / 2.0 - this.y) / 8.0) * dY + (dZ = (this.closestPlayer.z - this.z) / 8.0) * dZ))) > 0.0) {
                diff *= diff;
                this.motionX += dX / d * diff * 0.1;
                this.motionY += dY / d * diff * 0.1;
                this.motionZ += dZ / d * diff * 0.1;
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            double friction = 1.0 - (double)this.getDrag();
            if (this.onGround && (Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5)) {
                friction = this.getLevel().getBlock(this.temporalVector.setComponents((int)Math.floor(this.x), (int)Math.floor(this.y - 1.0), (int)Math.floor(this.z) - 1)).getFrictionFactor() * friction;
            }
            this.motionX *= friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= friction;
            if (this.onGround) {
                this.motionY *= -0.5;
            }
            this.updateMovement();
            if (this.age > 6000) {
                this.kill();
                hasUpdate = true;
            }
        }
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putShort("Health", (int)this.getHealth());
        this.namedTag.putShort("Age", this.age);
        this.namedTag.putShort("PickupDelay", this.pickupDelay);
        this.namedTag.putShort("Value", this.exp);
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        if (exp <= 0) {
            throw new IllegalArgumentException("XP amount must be greater than 0, got " + exp);
        }
        this.exp = exp;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    public static int getMaxOrbSize(int amount) {
        for (int split : ORB_SPLIT_SIZES) {
            if (amount < split) continue;
            return split;
        }
        return 1;
    }

    public static List<Integer> splitIntoOrbSizes(int amount) {
        IntArrayList result = new IntArrayList();
        while (amount > 0) {
            int size = EntityXPOrb.getMaxOrbSize(amount);
            result.add(size);
            amount -= size;
        }
        return result;
    }
}

