/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class ShapelessRecipe
implements CraftingRecipe {
    private String recipeId;
    private final Item output;
    private long least;
    private long most;
    private final List<Item> ingredients;
    private final int priority;

    public ShapelessRecipe(Item result, Collection<Item> ingredients) {
        this(null, 10, result, ingredients);
    }

    public ShapelessRecipe(String recipeId, int priority, Item result, Collection<Item> ingredients) {
        this.recipeId = recipeId;
        this.priority = priority;
        this.output = result.clone();
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Shapeless recipes cannot have more than 9 ingredients");
        }
        this.ingredients = new ArrayList<Item>();
        for (Item item : ingredients) {
            if (item.getCount() < 1) {
                throw new IllegalArgumentException("Recipe '" + recipeId + "' Ingredient amount was not 1 (value: " + item.getCount() + ")");
            }
            this.ingredients.add(item.clone());
        }
    }

    @Override
    public Item getResult() {
        return this.output.clone();
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public UUID getId() {
        return new UUID(this.least, this.most);
    }

    @Override
    public void setId(UUID uuid) {
        this.least = uuid.getLeastSignificantBits();
        this.most = uuid.getMostSignificantBits();
        if (this.recipeId == null) {
            this.recipeId = this.getId().toString();
        }
    }

    public List<Item> getIngredientList() {
        ArrayList<Item> ingredients = new ArrayList<Item>();
        for (Item ingredient : this.ingredients) {
            ingredients.add(ingredient.clone());
        }
        return ingredients;
    }

    public int getIngredientCount() {
        return this.ingredients.size();
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerShapelessRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPELESS;
    }

    @Override
    public boolean requiresCraftingTable() {
        return this.ingredients.size() > 4;
    }

    @Override
    public List<Item> getExtraResults() {
        return new ArrayList<Item>();
    }

    @Override
    public List<Item> getAllResults() {
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean matchItems(Item[][] input, Item[][] output) {
        ArrayList<Item> haveInputs = new ArrayList<Item>();
        for (Item[] items : input) {
            haveInputs.addAll(Arrays.asList(items));
        }
        haveInputs.sort(CraftingManager.recipeComparator);
        List<Item> needInputs = this.getIngredientList();
        if (!this.matchItemList(haveInputs, needInputs)) {
            return false;
        }
        ArrayList<Item> haveOutputs = new ArrayList<Item>();
        for (Item[] items : output) {
            haveOutputs.addAll(Arrays.asList(items));
        }
        haveOutputs.sort(CraftingManager.recipeComparator);
        List<Item> needOutputs = this.getExtraResults();
        return this.matchItemList(haveOutputs, needOutputs);
    }

    private boolean matchItemList(List<Item> haveItems, List<Item> needItems) {
        haveItems.removeIf(Item::isNull);
        if (haveItems.size() != needItems.size()) {
            return false;
        }
        int size = needItems.size();
        int completed = 0;
        for (int i = 0; i < size; ++i) {
            Item haveItem = haveItems.get(i);
            Item needItem = needItems.get(i);
            if (!needItem.equals(haveItem, needItem.hasMeta(), needItem.hasCompoundTag())) continue;
            ++completed;
        }
        return completed == size;
    }
}

