/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.CraftItemEvent;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BigCraftingGrid;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RepairRecipe;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.DamageAnvilAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.inventory.transaction.action.TakeLevelAction;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.scheduler.Task;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class CraftingTransaction
extends InventoryTransaction {
    protected int gridSize;
    protected Item[][] inputs;
    protected Item[][] secondaryOutputs;
    protected Item primaryOutput;
    protected Recipe recipe;
    protected int craftingType;

    public CraftingTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions, false);
        Item air = Item.get(0, 0, 1);
        this.craftingType = source.craftingType;
        if (source.craftingType == 6) {
            this.gridSize = 1;
            this.inputs = new Item[1][1];
            this.inputs[0][0] = air;
            this.secondaryOutputs = new Item[1][1];
            this.secondaryOutputs[0][0] = air;
        } else {
            this.gridSize = source.getCraftingGrid() instanceof BigCraftingGrid ? 3 : 2;
            for (Object[] objectArray : this.inputs = new Item[this.gridSize][this.gridSize]) {
                Arrays.fill(objectArray, air);
            }
            this.secondaryOutputs = new Item[this.gridSize][this.gridSize];
            for (Object[] objectArray : this.secondaryOutputs) {
                Arrays.fill(objectArray, air);
            }
        }
        this.init(source, actions);
    }

    public void setInput(int index, Item item) {
        int y = index / this.gridSize;
        int x = index % this.gridSize;
        if (this.inputs[y][x].isNull()) {
            this.inputs[y][x] = item.clone();
        } else if (!this.inputs[y][x].equals(item)) {
            throw new RuntimeException("Input " + index + " has already been set and does not match the current item (expected " + this.inputs[y][x] + ", got " + item + ")");
        }
    }

    public Item[][] getInputMap() {
        return this.inputs;
    }

    public void setExtraOutput(int index, Item item) {
        int y = index / this.gridSize;
        int x = index % this.gridSize;
        if (this.secondaryOutputs[y][x].isNull()) {
            this.secondaryOutputs[y][x] = item.clone();
        } else if (!this.secondaryOutputs[y][x].equals(item)) {
            throw new RuntimeException("Output " + index + " has already been set and does not match the current item (expected " + this.secondaryOutputs[y][x] + ", got " + item + ")");
        }
    }

    public Item getPrimaryOutput() {
        return this.primaryOutput;
    }

    public void setPrimaryOutput(Item item) {
        if (this.primaryOutput == null) {
            this.primaryOutput = item.clone();
        } else if (!this.primaryOutput.equals(item)) {
            throw new RuntimeException("Primary result item has already been set and does not match the current item (expected " + this.primaryOutput + ", got " + item + ")");
        }
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    private Item[][] reindexInputs() {
        int xMin = this.gridSize - 1;
        int yMin = this.gridSize - 1;
        int xMax = 0;
        int yMax = 0;
        for (int y = 0; y < this.inputs.length; ++y) {
            Item[] row = this.inputs[y];
            for (int x = 0; x < row.length; ++x) {
                Item item = row[x];
                if (item.isNull()) continue;
                xMin = Math.min(x, xMin);
                yMin = Math.min(y, yMin);
                xMax = Math.max(x, xMax);
                yMax = Math.max(y, yMax);
            }
        }
        int height = yMax - yMin + 1;
        int width = xMax - xMin + 1;
        if (height < 1 || width < 1) {
            return new Item[0][];
        }
        Item[][] reindexed = new Item[height][width];
        int y = yMin;
        int i = 0;
        while (y <= yMax) {
            System.arraycopy(this.inputs[y], xMin, reindexed[i], 0, width);
            ++y;
            ++i;
        }
        return reindexed;
    }

    @Override
    public boolean canExecute() {
        Item[][] inputs = this.reindexInputs();
        CraftingManager craftingManager = this.source.getServer().getCraftingManager();
        if (this.craftingType == 6) {
            this.recipe = craftingManager.matchStonecutterRecipe(this.primaryOutput);
        } else if (this.craftingType == 7) {
            this.recipe = craftingManager.matchCartographyRecipe(inputs, this.primaryOutput, this.secondaryOutputs);
        } else if (this.craftingType == 2) {
            Inventory inventory = this.source.getWindowById(2);
            if (inventory instanceof AnvilInventory) {
                AnvilInventory anvil = (AnvilInventory)inventory;
                this.addInventory(anvil);
                if (this.primaryOutput.equals(anvil.getResult(), true, true)) {
                    TakeLevelAction takeLevel = new TakeLevelAction(anvil.getLevelCost());
                    this.addAction(takeLevel);
                    if (takeLevel.isValid(this.source)) {
                        this.recipe = new RepairRecipe(InventoryType.ANVIL, this.primaryOutput, Arrays.asList(inputs[0]));
                        PlayerUIInventory uiInventory = this.source.getUIInventory();
                        this.actions.add(new DamageAnvilAction(anvil, !this.source.isCreative() && ThreadLocalRandom.current().nextFloat() < 0.12f, this));
                        this.actions.stream().filter(a -> a instanceof SlotChangeAction).map(a -> (SlotChangeAction)a).filter(a -> a.getInventory() == uiInventory).filter(a -> a.getSlot() == 50).findFirst().ifPresent(a -> {
                            this.actions.remove(a);
                            this.actions.add(a);
                        });
                        anvil.setResult(Item.get(0), false);
                    }
                }
            }
        } else if (this.craftingType == 5) {
            Inventory inventory = this.source.getWindowById(2);
            if (inventory instanceof GrindstoneInventory) {
                GrindstoneInventory grindstone = (GrindstoneInventory)inventory;
                this.addInventory(grindstone);
                if (this.primaryOutput.equals(grindstone.getResult(), true, true)) {
                    this.recipe = new RepairRecipe(InventoryType.GRINDSTONE, this.primaryOutput, Arrays.asList(inputs[0]));
                    grindstone.setResult(Item.get(0), false);
                }
            }
        } else {
            this.recipe = craftingManager.matchRecipe(inputs, this.primaryOutput, this.secondaryOutputs);
        }
        return this.recipe != null && super.canExecute();
    }

    @Override
    protected boolean callExecuteEvent() {
        CraftItemEvent ev = new CraftItemEvent(this);
        this.source.getServer().getPluginManager().callEvent(ev);
        return !ev.isCancelled();
    }

    @Override
    protected void sendInventories() {
        super.sendInventories();
        final ContainerClosePacket pk = new ContainerClosePacket();
        pk.windowId = -1;
        this.source.getServer().getScheduler().scheduleDelayedTask(new Task(){

            @Override
            public void onRun(int currentTick) {
                CraftingTransaction.this.source.dataPacket(pk);
            }
        }, 20);
        this.source.resetCraftingGridType();
    }

    @Override
    public boolean execute() {
        if (super.execute()) {
            switch (this.primaryOutput.getId()) {
                case 58: {
                    this.source.awardAchievement("buildWorkBench");
                    break;
                }
                case 270: {
                    this.source.awardAchievement("buildPickaxe");
                    break;
                }
                case 61: {
                    this.source.awardAchievement("buildFurnace");
                    break;
                }
                case 290: {
                    this.source.awardAchievement("buildHoe");
                    break;
                }
                case 297: {
                    this.source.awardAchievement("makeBread");
                    break;
                }
                case 354: {
                    this.source.awardAchievement("bakeCake");
                    break;
                }
                case 257: 
                case 274: 
                case 278: 
                case 285: {
                    this.source.awardAchievement("buildBetterPickaxe");
                    break;
                }
                case 268: {
                    this.source.awardAchievement("buildSword");
                    break;
                }
                case 264: {
                    this.source.awardAchievement("diamond");
                }
            }
            return true;
        }
        return false;
    }
}

