/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.item.Item;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.concurrent.ThreadLocalRandom;

public class ItemBookWritten
extends Item {
    protected boolean isWritten = false;

    public ItemBookWritten() {
        this((Integer)0, 1);
    }

    public ItemBookWritten(Integer meta, int count) {
        super(387, 0, count, "Book");
    }

    public Item writeBook(String author, String title, String[] pages) {
        ListTag<CompoundTag> pageList = new ListTag<CompoundTag>("pages");
        for (String page : pages) {
            pageList.add(new CompoundTag().putString("photoname", "").putString("text", page));
        }
        return this.writeBook(author, title, pageList);
    }

    public Item writeBook(String author, String title, ListTag<CompoundTag> pages) {
        if (pages.size() > 50 || pages.size() <= 0) {
            return this;
        }
        if (this.isWritten) {
            return this;
        }
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        tag.putString("author", author);
        tag.putString("title", title);
        tag.putList(pages);
        tag.putInt("generation", 0);
        long randomId = 0xFF00000000L + ThreadLocalRandom.current().nextLong(0L, Integer.MAX_VALUE);
        tag.putLong("id", randomId);
        this.isWritten = true;
        return this.setNamedTag(tag);
    }

    public String getAuthor() {
        if (!this.isWritten) {
            return "";
        }
        return this.getNamedTag().getString("author");
    }

    public String getTitle() {
        if (!this.isWritten) {
            return "Book";
        }
        return this.getNamedTag().getString("title");
    }

    public String[] getPages() {
        if (!this.isWritten) {
            return new String[0];
        }
        ListTag<? extends Tag> tag = this.getNamedTag().getList("pages");
        String[] pages = new String[tag.size()];
        int i = 0;
        for (CompoundTag compoundTag : tag.getAll()) {
            pages[i] = compoundTag.getString("text");
            ++i;
        }
        return pages;
    }
}

