/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFire;
import cn.nukkit.block.BlockNetherPortal;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.item.ItemTool;
import cn.nukkit.level.Level;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;

public class ItemFlintSteel
extends ItemTool {
    private static final int MAX_PORTAL_SIZE = 23;

    public ItemFlintSteel() {
        this((Integer)0, 1);
    }

    public ItemFlintSteel(Integer meta) {
        this(meta, 1);
    }

    public ItemFlintSteel(Integer meta, int count) {
        super(259, meta, count, "Flint and Steel");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (block.getId() == 0 && (target instanceof BlockSolid || target instanceof BlockSolidMeta)) {
            block60: {
                if (target.getId() == 49) {
                    int i;
                    int targX = target.getFloorX();
                    int targY = target.getFloorY();
                    int targZ = target.getFloorZ();
                    for (int i2 = 1; i2 < 4; ++i2) {
                        if (level.getBlockIdAt(targX, targY + i2, targZ) == 0) {
                            continue;
                        }
                        break block60;
                    }
                    int sizePosX = 0;
                    int sizeNegX = 0;
                    int sizePosZ = 0;
                    int sizeNegZ = 0;
                    for (i = 1; i < 23 && level.getBlockIdAt(targX + i, targY, targZ) == 49; ++i) {
                        ++sizePosX;
                    }
                    for (i = 1; i < 23 && level.getBlockIdAt(targX - i, targY, targZ) == 49; ++i) {
                        ++sizeNegX;
                    }
                    for (i = 1; i < 23 && level.getBlockIdAt(targX, targY, targZ + i) == 49; ++i) {
                        ++sizePosZ;
                    }
                    for (i = 1; i < 23 && level.getBlockIdAt(targX, targY, targZ - i) == 49; ++i) {
                        ++sizeNegZ;
                    }
                    int sizeX = sizePosX + sizeNegX + 1;
                    int sizeZ = sizePosZ + sizeNegZ + 1;
                    if (sizeX >= 2 && sizeX <= 23) {
                        int scanX = targX;
                        int scanY = targY + 1;
                        int scanZ = targZ;
                        for (int i3 = 0; i3 < sizePosX + 1; ++i3) {
                            if (level.getBlockIdAt(scanX + i3, scanY, scanZ) == 0) {
                                if (level.getBlockIdAt(scanX + i3 + 1, scanY, scanZ) != 49) continue;
                                scanX += i3;
                                break;
                            }
                            break block60;
                        }
                        if (level.getBlockIdAt(scanX + 1, scanY, scanZ) == 49) {
                            int innerWidth = 0;
                            block22: for (int i4 = 0; i4 < 21; ++i4) {
                                int id = level.getBlockIdAt(scanX - i4, scanY, scanZ);
                                switch (id) {
                                    case 0: {
                                        ++innerWidth;
                                        continue block22;
                                    }
                                    case 49: {
                                        break block22;
                                    }
                                    default: {
                                        break block60;
                                    }
                                }
                            }
                            int innerHeight = 0;
                            block23: for (int i5 = 0; i5 < 21; ++i5) {
                                int id = level.getBlockIdAt(scanX, scanY + i5, scanZ);
                                switch (id) {
                                    case 0: {
                                        ++innerHeight;
                                        continue block23;
                                    }
                                    case 49: {
                                        break block23;
                                    }
                                    default: {
                                        break block60;
                                    }
                                }
                            }
                            if (innerWidth <= 21 && innerWidth >= 2 && innerHeight <= 21 && innerHeight >= 3) {
                                int width;
                                int height;
                                for (height = 0; height < innerHeight + 1; ++height) {
                                    if (height == innerHeight) {
                                        for (width = 0; width < innerWidth; ++width) {
                                            if (level.getBlockIdAt(scanX - width, scanY + height, scanZ) == 49) {
                                                continue;
                                            }
                                            break block60;
                                        }
                                        continue;
                                    }
                                    if (level.getBlockIdAt(scanX + 1, scanY + height, scanZ) != 49 || level.getBlockIdAt(scanX - innerWidth, scanY + height, scanZ) != 49) break block60;
                                    for (width = 0; width < innerWidth; ++width) {
                                        if (level.getBlockIdAt(scanX - width, scanY + height, scanZ) == 0) {
                                            continue;
                                        }
                                        break block60;
                                    }
                                }
                                for (height = 0; height < innerHeight; ++height) {
                                    for (width = 0; width < innerWidth; ++width) {
                                        level.setBlock(new Vector3(scanX - width, scanY + height, scanZ), new BlockNetherPortal());
                                    }
                                }
                                level.addLevelSoundEvent(block, 50);
                                return true;
                            }
                        }
                    } else if (sizeZ >= 2 && sizeZ <= 23) {
                        int scanX = targX;
                        int scanY = targY + 1;
                        int scanZ = targZ;
                        for (int i6 = 0; i6 < sizePosZ + 1; ++i6) {
                            if (level.getBlockIdAt(scanX, scanY, scanZ + i6) == 0) {
                                if (level.getBlockIdAt(scanX, scanY, scanZ + i6 + 1) != 49) continue;
                                scanZ += i6;
                                break;
                            }
                            break block60;
                        }
                        if (level.getBlockIdAt(scanX, scanY, scanZ + 1) == 49) {
                            int innerWidth = 0;
                            block30: for (int i7 = 0; i7 < 21; ++i7) {
                                int id = level.getBlockIdAt(scanX, scanY, scanZ - i7);
                                switch (id) {
                                    case 0: {
                                        ++innerWidth;
                                        continue block30;
                                    }
                                    case 49: {
                                        break block30;
                                    }
                                    default: {
                                        break block60;
                                    }
                                }
                            }
                            int innerHeight = 0;
                            block31: for (int i8 = 0; i8 < 21; ++i8) {
                                int id = level.getBlockIdAt(scanX, scanY + i8, scanZ);
                                switch (id) {
                                    case 0: {
                                        ++innerHeight;
                                        continue block31;
                                    }
                                    case 49: {
                                        break block31;
                                    }
                                    default: {
                                        break block60;
                                    }
                                }
                            }
                            if (innerWidth <= 21 && innerWidth >= 2 && innerHeight <= 21 && innerHeight >= 3) {
                                int width;
                                int height;
                                for (height = 0; height < innerHeight + 1; ++height) {
                                    if (height == innerHeight) {
                                        for (width = 0; width < innerWidth; ++width) {
                                            if (level.getBlockIdAt(scanX, scanY + height, scanZ - width) == 49) {
                                                continue;
                                            }
                                            break block60;
                                        }
                                        continue;
                                    }
                                    if (level.getBlockIdAt(scanX, scanY + height, scanZ + 1) != 49 || level.getBlockIdAt(scanX, scanY + height, scanZ - innerWidth) != 49) break block60;
                                    for (width = 0; width < innerWidth; ++width) {
                                        if (level.getBlockIdAt(scanX, scanY + height, scanZ - width) == 0) {
                                            continue;
                                        }
                                        break block60;
                                    }
                                }
                                for (height = 0; height < innerHeight; ++height) {
                                    for (width = 0; width < innerWidth; ++width) {
                                        level.setBlock(new Vector3(scanX, scanY + height, scanZ - width), new BlockNetherPortal());
                                    }
                                }
                                level.addLevelSoundEvent(block, 50);
                                return true;
                            }
                        }
                    }
                }
            }
            BlockFire fire = new BlockFire();
            fire.x = block.x;
            fire.y = block.y;
            fire.z = block.z;
            fire.level = level;
            if (fire.isBlockTopFacingSurfaceSolid(fire.down()) || fire.canNeighborBurn()) {
                BlockIgniteEvent e = new BlockIgniteEvent(block, null, player, BlockIgniteEvent.BlockIgniteCause.FLINT_AND_STEEL);
                block.getLevel().getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    level.setBlock((Vector3)fire, fire, true);
                    level.addLevelSoundEvent(block, 50);
                    level.scheduleUpdate(fire, fire.tickRate() + ThreadLocalRandom.current().nextInt(10));
                }
                return true;
            }
            if ((player.gamemode & 1) == 0 && this.useOn(block)) {
                if (this.getDamage() >= this.getMaxDurability()) {
                    this.count = 0;
                } else {
                    ++this.meta;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getMaxDurability() {
        return 65;
    }
}

