/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.item.Item;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.ClientboundMapItemDataPacket;
import cn.nukkit.utils.MainLogger;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ItemMap
extends Item {
    public static int mapCount = 0;

    public ItemMap() {
        this((Integer)0, 1);
    }

    public ItemMap(Integer meta) {
        this(meta, 1);
    }

    public ItemMap(Integer meta, int count) {
        super(358, meta, count, "Map");
        switch (meta) {
            case 3: {
                this.name = "Ocean Explorer Map";
                break;
            }
            case 4: {
                this.name = "Woodland Explorer Map";
                break;
            }
            case 5: {
                this.name = "Treasure Map";
            }
        }
        if (!this.hasCompoundTag() || !this.getNamedTag().contains("map_uuid")) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("map_uuid", mapCount++);
            this.setNamedTag(tag);
        }
    }

    public void setImage(File file) throws IOException {
        this.setImage(ImageIO.read(file));
    }

    public void setImage(BufferedImage img) {
        try {
            BufferedImage image = img;
            if (img.getHeight() != 128 || img.getWidth() != 128) {
                image = new BufferedImage(128, 128, img.getType());
                Graphics2D g = image.createGraphics();
                g.drawImage(img, 0, 0, 128, 128, null);
                g.dispose();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            this.getNamedTag().putByteArray("Colors", baos.toByteArray());
        }
        catch (IOException e) {
            MainLogger.getLogger().logException(e);
        }
    }

    protected BufferedImage loadImageFromNBT() {
        try {
            byte[] data = this.getNamedTag().getByteArray("Colors");
            return ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            MainLogger.getLogger().logException(e);
            return null;
        }
    }

    public long getMapId() {
        return this.getNamedTag().getLong("map_uuid");
    }

    public void sendImage(Player p) {
        BufferedImage image = this.loadImageFromNBT();
        ClientboundMapItemDataPacket pk = new ClientboundMapItemDataPacket();
        pk.mapId = this.getMapId();
        pk.update = 2;
        pk.scale = 0;
        pk.width = 128;
        pk.height = 128;
        pk.offsetX = 0;
        pk.offsetZ = 0;
        pk.image = image;
        p.dataPacket(pk);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }
}

