/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.mcregion;

import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseLevelProvider;
import cn.nukkit.level.format.generic.BaseRegionLoader;
import cn.nukkit.level.format.mcregion.Chunk;
import cn.nukkit.level.format.mcregion.RegionLoader;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class McRegion
extends BaseLevelProvider {
    public McRegion(Level level, String path) throws IOException {
        super(level, path);
    }

    public static String getProviderName() {
        return "mcregion";
    }

    public static byte getProviderOrder() {
        return 1;
    }

    public static boolean usesChunkSection() {
        return false;
    }

    public static boolean isValid(String path) {
        boolean isValid;
        boolean bl = isValid = new File(path + "/level.dat").exists() && new File(path + "/region/").isDirectory();
        if (isValid) {
            for (File file : new File(path + "/region/").listFiles((dir, name) -> Pattern.matches("^.+\\.mc[r|a]$", name))) {
                if (file.getName().endsWith(".mcr")) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public static void generate(String path, String name, long seed, Class<? extends Generator> generator) throws IOException {
        McRegion.generate(path, name, seed, generator, new HashMap<String, String>());
    }

    public static void generate(String path, String name, long seed, Class<? extends Generator> generator, Map<String, String> options) throws IOException {
        if (!new File(path + "/region").exists()) {
            new File(path + "/region").mkdirs();
        }
        CompoundTag levelData = new CompoundTag("Data").putCompound("GameRules", new CompoundTag()).putLong("DayTime", 0L).putInt("GameType", 0).putString("generatorName", Generator.getGeneratorName(generator)).putString("generatorOptions", options.getOrDefault("preset", "")).putInt("generatorVersion", 1).putBoolean("hardcore", false).putBoolean("initialized", true).putLong("LastPlayed", System.currentTimeMillis() / 1000L).putString("LevelName", name).putBoolean("raining", false).putInt("rainTime", 0).putLong("RandomSeed", seed).putInt("SpawnX", 128).putInt("SpawnY", 70).putInt("SpawnZ", 128).putBoolean("thundering", false).putInt("thunderTime", 0).putInt("version", 19133).putLong("Time", 0L).putLong("SizeOnDisk", 0L);
        NBTIO.writeGZIPCompressed(new CompoundTag().putCompound("Data", levelData), new FileOutputStream(path + "level.dat"), ByteOrder.BIG_ENDIAN);
    }

    @Override
    public AsyncTask requestChunkTask(int x, int z) throws ChunkException {
        BinaryStream extraData;
        Map<Integer, Integer> extra;
        BaseFullChunk chunk = this.getChunk(x, z, false);
        if (chunk == null) {
            throw new ChunkException("Invalid Chunk Sent");
        }
        long timestamp = chunk.getChanges();
        byte[] tiles = new byte[]{};
        if (!chunk.getBlockEntities().isEmpty()) {
            ArrayList<CompoundTag> tagList = new ArrayList<CompoundTag>();
            for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                if (!(blockEntity instanceof BlockEntitySpawnable)) continue;
                tagList.add(((BlockEntitySpawnable)blockEntity).getSpawnCompound());
            }
            try {
                tiles = NBTIO.write(tagList, ByteOrder.LITTLE_ENDIAN, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(extra = chunk.getBlockExtraDataArray()).isEmpty()) {
            extraData = new BinaryStream();
            extraData.putLInt(extra.size());
            for (Map.Entry<Integer, Integer> entry : extra.entrySet()) {
                extraData.putLInt(entry.getKey());
                extraData.putLShort(entry.getValue());
            }
        } else {
            extraData = null;
        }
        BinaryStream binaryStream = new BinaryStream();
        binaryStream.put(chunk.getBlockIdArray());
        binaryStream.put(chunk.getBlockDataArray());
        binaryStream.put(chunk.getBlockSkyLightArray());
        binaryStream.put(chunk.getBlockLightArray());
        binaryStream.put(chunk.getHeightMapArray());
        binaryStream.put(chunk.getBiomeIdArray());
        if (extraData != null) {
            binaryStream.put(extraData.getBuffer());
        } else {
            binaryStream.putLInt(0);
        }
        binaryStream.put(tiles);
        this.getLevel().chunkRequestCallback(timestamp, x, z, 16, binaryStream.getBuffer());
        return null;
    }

    @Override
    public BaseFullChunk loadChunk(long index, int chunkX, int chunkZ, boolean create) {
        BaseFullChunk chunk;
        int regionX = McRegion.getRegionIndexX(chunkX);
        int regionZ = McRegion.getRegionIndexZ(chunkZ);
        BaseRegionLoader region = this.loadRegion(regionX, regionZ);
        this.level.timings.syncChunkLoadDataTimer.startTiming();
        try {
            chunk = region.readChunk(chunkX - regionX * 32, chunkZ - regionZ * 32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (chunk == null) {
            if (create) {
                chunk = this.getEmptyChunk(chunkX, chunkZ);
                this.putChunk(index, chunk);
            }
        } else {
            this.putChunk(index, chunk);
        }
        this.level.timings.syncChunkLoadDataTimer.stopTiming();
        return chunk;
    }

    @Override
    public Chunk getEmptyChunk(int chunkX, int chunkZ) {
        return Chunk.getEmptyChunk(chunkX, chunkZ, this);
    }

    @Override
    public void saveChunk(int x, int z) {
        if (this.isChunkLoaded(x, z)) {
            try {
                this.getRegion(x >> 5, z >> 5).writeChunk(this.getChunk(x, z));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void saveChunk(int x, int z, FullChunk chunk) {
        if (!(chunk instanceof Chunk)) {
            throw new ChunkException("Invalid Chunk class");
        }
        this.loadRegion(x >> 5, z >> 5);
        chunk.setPosition(x, z);
        try {
            this.getRegion(x >> 5, z >> 5).writeChunk(chunk);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ChunkSection createChunkSection(int y) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseRegionLoader loadRegion(int x, int z) {
        BaseRegionLoader tmp = (BaseRegionLoader)this.lastRegion.get();
        if (tmp != null && x == tmp.getX() && z == tmp.getZ()) {
            return tmp;
        }
        long index = Level.chunkHash(x, z);
        Long2ObjectMap long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            BaseRegionLoader region = (BaseRegionLoader)this.regions.get(index);
            if (region == null) {
                region = new RegionLoader(this, x, z);
                this.regions.put(index, (Object)region);
            }
            this.lastRegion.set(region);
            return region;
        }
    }
}

