/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.mushroom;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockHugeMushroomBrown;
import cn.nukkit.block.BlockHugeMushroomRed;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.BasicGenerator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class BigMushroom
extends BasicGenerator {
    public static final int NORTH_WEST = 1;
    public static final int NORTH = 2;
    public static final int NORTH_EAST = 3;
    public static final int WEST = 4;
    public static final int CENTER = 5;
    public static final int EAST = 6;
    public static final int SOUTH_WEST = 7;
    public static final int SOUTH = 8;
    public static final int SOUTH_EAST = 9;
    public static final int STEM = 10;
    public static final int ALL_INSIDE = 0;
    public static final int ALL_OUTSIDE = 14;
    public static final int ALL_STEM = 15;
    public static final int BROWN = 0;
    public static final int RED = 1;
    private int mushroomType;

    public BigMushroom(int mushroomType) {
        this.mushroomType = mushroomType;
    }

    public BigMushroom() {
        this.mushroomType = -1;
    }

    @Override
    public boolean generate(ChunkManager level, NukkitRandom rand, Vector3 position) {
        int block = this.mushroomType;
        if (block < 0) {
            block = rand.nextBoolean() ? 1 : 0;
        }
        BlockSolidMeta mushroom = block == 0 ? new BlockHugeMushroomBrown() : new BlockHugeMushroomRed();
        int i = rand.nextBoundedInt(3) + 4;
        if (rand.nextBoundedInt(12) == 0) {
            i *= 2;
        }
        boolean flag = true;
        if (position.getY() >= 1.0 && position.getY() + (double)i + 1.0 < 256.0) {
            int j = position.getFloorY();
            while ((double)j <= position.getY() + 1.0 + (double)i) {
                int k = 3;
                if ((double)j <= position.getY() + 3.0) {
                    k = 0;
                }
                Vector3 pos = new Vector3();
                int l = position.getFloorX() - k;
                while ((double)l <= position.getX() + (double)k && flag) {
                    int i1 = position.getFloorZ() - k;
                    while ((double)i1 <= position.getZ() + (double)k && flag) {
                        if (j >= 0 && j < 256) {
                            pos.setComponents(l, j, i1);
                            int material = level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
                            if (material != 0 && material != 18) {
                                flag = false;
                            }
                        } else {
                            flag = false;
                        }
                        ++i1;
                    }
                    ++l;
                }
                ++j;
            }
            if (!flag) {
                return false;
            }
            Vector3 pos2 = position.down();
            int block1 = level.getBlockIdAt(pos2.getFloorX(), pos2.getFloorY(), pos2.getFloorZ());
            if (block1 != 3 && block1 != 2 && block1 != 110) {
                return false;
            }
            int k2 = position.getFloorY() + i;
            if (block == 1) {
                k2 = position.getFloorY() + i - 3;
            }
            int l2 = k2;
            while ((double)l2 <= position.getY() + (double)i) {
                int j3 = 1;
                if ((double)l2 < position.getY() + (double)i) {
                    ++j3;
                }
                if (block == 0) {
                    j3 = 3;
                }
                int k3 = position.getFloorX() - j3;
                int l3 = position.getFloorX() + j3;
                int j1 = position.getFloorZ() - j3;
                int k1 = position.getFloorZ() + j3;
                for (int l1 = k3; l1 <= l3; ++l1) {
                    for (int i2 = j1; i2 <= k1; ++i2) {
                        Vector3 blockPos;
                        int j2 = 5;
                        if (l1 == k3) {
                            --j2;
                        } else if (l1 == l3) {
                            ++j2;
                        }
                        if (i2 == j1) {
                            j2 -= 3;
                        } else if (i2 == k1) {
                            j2 += 3;
                        }
                        int meta = j2;
                        if (block == 0 || (double)l2 < position.getY() + (double)i) {
                            if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                            if ((double)l1 == position.getX() - (double)(j3 - 1) && i2 == j1) {
                                meta = 1;
                            }
                            if (l1 == k3 && (double)i2 == position.getZ() - (double)(j3 - 1)) {
                                meta = 1;
                            }
                            if ((double)l1 == position.getX() + (double)(j3 - 1) && i2 == j1) {
                                meta = 3;
                            }
                            if (l1 == l3 && (double)i2 == position.getZ() - (double)(j3 - 1)) {
                                meta = 3;
                            }
                            if ((double)l1 == position.getX() - (double)(j3 - 1) && i2 == k1) {
                                meta = 7;
                            }
                            if (l1 == k3 && (double)i2 == position.getZ() + (double)(j3 - 1)) {
                                meta = 7;
                            }
                            if ((double)l1 == position.getX() + (double)(j3 - 1) && i2 == k1) {
                                meta = 9;
                            }
                            if (l1 == l3 && (double)i2 == position.getZ() + (double)(j3 - 1)) {
                                meta = 9;
                            }
                        }
                        if (meta == 5 && (double)l2 < position.getY() + (double)i) {
                            meta = 0;
                        }
                        if (!(position.getY() >= position.getY() + (double)i - 1.0) && meta == 0 || Block.solid[level.getBlockIdAt((blockPos = new Vector3(l1, l2, i2)).getFloorX(), blockPos.getFloorY(), blockPos.getFloorZ())]) continue;
                        ((Block)mushroom).setDamage(meta);
                        this.setBlockAndNotifyAdequately(level, blockPos, (Block)mushroom);
                    }
                }
                ++l2;
            }
            for (int i3 = 0; i3 < i; ++i3) {
                Vector3 pos = position.up(i3);
                int id = level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
                if (Block.solid[id]) continue;
                ((Block)mushroom).setDamage(10);
                this.setBlockAndNotifyAdequately(level, pos, (Block)mushroom);
            }
            return true;
        }
        return false;
    }
}

