/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLeaves;
import cn.nukkit.block.BlockVine;
import cn.nukkit.block.BlockWood;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class ObjectSwampTree
extends TreeGenerator {
    private final Block metaWood = new BlockWood(0);
    private final Block metaLeaves = new BlockLeaves(0);

    @Override
    public boolean generate(ChunkManager worldIn, NukkitRandom rand, Vector3 vectorPosition) {
        BlockVector3 position = new BlockVector3(vectorPosition.getFloorX(), vectorPosition.getFloorY(), vectorPosition.getFloorZ());
        int i = rand.nextBoundedInt(4) + 5;
        boolean flag = true;
        if (position.getY() >= 1 && position.getY() + i + 1 <= 256) {
            for (int j = position.getY(); j <= position.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == position.getY()) {
                    k = 0;
                }
                if (j >= position.getY() + 1 + i - 2) {
                    k = 3;
                }
                BlockVector3 pos2 = new BlockVector3();
                for (int l = position.getX() - k; l <= position.getX() + k && flag; ++l) {
                    for (int i1 = position.getZ() - k; i1 <= position.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            pos2.setComponents(l, j, i1);
                            if (this.canGrowInto(worldIn.getBlockIdAt(pos2.x, pos2.y, pos2.z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockVector3 down = position.down();
            int block = worldIn.getBlockIdAt(down.x, down.y, down.z);
            if ((block == 2 || block == 3) && position.getY() < 256 - i - 1) {
                this.setDirtAt(worldIn, down);
                for (int k1 = position.getY() - 3 + i; k1 <= position.getY() + i; ++k1) {
                    int j2 = k1 - (position.getY() + i);
                    int l2 = 2 - j2 / 2;
                    for (int j3 = position.getX() - l2; j3 <= position.getX() + l2; ++j3) {
                        int k3 = j3 - position.getX();
                        for (int i4 = position.getZ() - l2; i4 <= position.getZ() + l2; ++i4) {
                            int j1 = i4 - position.getZ();
                            if (Math.abs(k3) == l2 && Math.abs(j1) == l2 && (rand.nextBoundedInt(2) == 0 || j2 == 0)) continue;
                            BlockVector3 blockpos = new BlockVector3(j3, k1, i4);
                            int id = worldIn.getBlockIdAt(blockpos.x, blockpos.y, blockpos.z);
                            if (id != 0 && id != 18 && id != 106) continue;
                            this.setBlockAndNotifyAdequately(worldIn, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockVector3 up = position.up(l1);
                    int id = worldIn.getBlockIdAt(up.x, up.y, up.z);
                    if (id != 0 && id != 18 && id != 8 && id != 9) continue;
                    this.setBlockAndNotifyAdequately(worldIn, up, this.metaWood);
                }
                for (int i2 = position.getY() - 3 + i; i2 <= position.getY() + i; ++i2) {
                    int k2 = i2 - (position.getY() + i);
                    int i3 = 2 - k2 / 2;
                    BlockVector3 pos2 = new BlockVector3();
                    for (int l3 = position.getX() - i3; l3 <= position.getX() + i3; ++l3) {
                        for (int j4 = position.getZ() - i3; j4 <= position.getZ() + i3; ++j4) {
                            pos2.setComponents(l3, i2, j4);
                            if (worldIn.getBlockIdAt(pos2.x, pos2.y, pos2.z) != 18) continue;
                            BlockVector3 blockpos2 = pos2.west();
                            BlockVector3 blockpos3 = pos2.east();
                            BlockVector3 blockpos4 = pos2.north();
                            BlockVector3 blockpos1 = pos2.south();
                            if (rand.nextBoundedInt(4) == 0 && worldIn.getBlockIdAt(blockpos2.x, blockpos2.y, blockpos2.z) == 0) {
                                this.addHangingVine(worldIn, blockpos2, 8);
                            }
                            if (rand.nextBoundedInt(4) == 0 && worldIn.getBlockIdAt(blockpos3.x, blockpos3.y, blockpos3.z) == 0) {
                                this.addHangingVine(worldIn, blockpos3, 2);
                            }
                            if (rand.nextBoundedInt(4) == 0 && worldIn.getBlockIdAt(blockpos4.x, blockpos4.y, blockpos4.z) == 0) {
                                this.addHangingVine(worldIn, blockpos4, 1);
                            }
                            if (rand.nextBoundedInt(4) != 0 || worldIn.getBlockIdAt(blockpos1.x, blockpos1.y, blockpos1.z) != 0) continue;
                            this.addHangingVine(worldIn, blockpos1, 4);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(ChunkManager worldIn, BlockVector3 pos, int meta) {
        this.setBlockAndNotifyAdequately(worldIn, pos, (Block)new BlockVine(meta));
    }

    private void addHangingVine(ChunkManager worldIn, BlockVector3 pos, int meta) {
        this.addVine(worldIn, pos, meta);
        pos = pos.down();
        for (int i = 4; i > 0 && worldIn.getBlockIdAt(pos.x, pos.y, pos.z) == 0; --i) {
            this.addVine(worldIn, pos, meta);
            pos = pos.down();
        }
    }
}

