/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.command.data.CommandData;
import cn.nukkit.command.data.CommandDataVersions;
import cn.nukkit.command.data.CommandEnum;
import cn.nukkit.command.data.CommandOverload;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.BinaryStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;

public class AvailableCommandsPacket
extends DataPacket {
    public static final byte NETWORK_ID = 76;
    private static final ObjIntConsumer<BinaryStream> WRITE_BYTE = (s, v) -> s.putByte((byte)v);
    private static final ObjIntConsumer<BinaryStream> WRITE_SHORT = BinaryStream::putLShort;
    private static final ObjIntConsumer<BinaryStream> WRITE_INT = BinaryStream::putLInt;
    private static final ToIntFunction<BinaryStream> READ_BYTE = BinaryStream::getByte;
    private static final ToIntFunction<BinaryStream> READ_SHORT = BinaryStream::getLShort;
    private static final ToIntFunction<BinaryStream> READ_INT = BinaryStream::getLInt;
    public static final int ARG_FLAG_VALID = 0x100000;
    public static final int ARG_FLAG_ENUM = 0x200000;
    public static final int ARG_FLAG_POSTFIX = 0x1000000;
    public static final int ARG_FLAG_SOFT_ENUM = 0x4000000;
    public static final int ARG_TYPE_INT = 1;
    public static final int ARG_TYPE_FLOAT = 2;
    public static final int ARG_TYPE_VALUE = 3;
    public static final int ARG_TYPE_WILDCARD_INT = 4;
    public static final int ARG_TYPE_OPERATOR = 5;
    public static final int ARG_TYPE_TARGET = 6;
    public static final int ARG_TYPE_WILDCARD_TARGET = 7;
    public static final int ARG_TYPE_FILE_PATH = 14;
    public static final int ARG_TYPE_STRING = 29;
    public static final int ARG_TYPE_POSITION = 37;
    public static final int ARG_TYPE_MESSAGE = 41;
    public static final int ARG_TYPE_RAWTEXT = 43;
    public static final int ARG_TYPE_JSON = 47;
    public static final int ARG_TYPE_COMMAND = 54;
    public Map<String, CommandDataVersions> commands;
    public final Map<String, List<String>> softEnums = new HashMap<String, List<String>>();

    @Override
    public byte pid() {
        return 76;
    }

    @Override
    public void decode() {
        this.commands = new HashMap<String, CommandDataVersions>();
        ArrayList<String> enumValues = new ArrayList<String>();
        ArrayList<String> postFixes = new ArrayList<String>();
        ArrayList<CommandEnum> enums = new ArrayList<CommandEnum>();
        int len = (int)this.getUnsignedVarInt();
        while (len-- > 0) {
            enumValues.add(this.getString());
        }
        len = (int)this.getUnsignedVarInt();
        while (len-- > 0) {
            postFixes.add(this.getString());
        }
        ToIntFunction<BinaryStream> indexReader = enumValues.size() < 256 ? READ_BYTE : (enumValues.size() < 65536 ? READ_SHORT : READ_INT);
        len = (int)this.getUnsignedVarInt();
        while (len-- > 0) {
            String enumName = this.getString();
            int enumLength = (int)this.getUnsignedVarInt();
            ArrayList<String> values = new ArrayList<String>();
            while (enumLength-- > 0) {
                String enumValue;
                int index = indexReader.applyAsInt(this);
                if (index < 0 || (enumValue = (String)enumValues.get(index)) == null) {
                    throw new IllegalStateException("Enum value not found for index " + index);
                }
                values.add(enumValue);
            }
            enums.add(new CommandEnum(enumName, values));
        }
        len = (int)this.getUnsignedVarInt();
        while (len-- > 0) {
            String name = this.getString();
            String description = this.getString();
            int flags = this.getByte();
            int permission = this.getByte();
            CommandEnum alias = null;
            int aliasIndex = this.getLInt();
            if (aliasIndex >= 0) {
                alias = (CommandEnum)enums.get(aliasIndex);
            }
            HashMap<String, CommandOverload> overloads = new HashMap<String, CommandOverload>();
            int length = (int)this.getUnsignedVarInt();
            while (length-- > 0) {
                CommandOverload overload = new CommandOverload();
                int paramLen = (int)this.getUnsignedVarInt();
                overload.input.parameters = new CommandParameter[paramLen];
                for (int i = 0; i < paramLen; ++i) {
                    String paramName = this.getString();
                    int type = this.getLInt();
                    boolean optional = this.getBoolean();
                    CommandParameter parameter = new CommandParameter(paramName, optional);
                    if ((type & 0x1000000) != 0) {
                        parameter.postFix = (String)postFixes.get(type & 0xFFFF);
                    } else {
                        if ((type & 0x100000) == 0) {
                            throw new IllegalStateException("Invalid parameter type received");
                        }
                        int index = type & 0xFFFF;
                        if ((type & 0x200000) != 0) {
                            parameter.enumData = (CommandEnum)enums.get(index);
                        } else if ((type & 0x4000000) == 0) {
                            throw new IllegalStateException("Unknown parameter type!");
                        }
                    }
                    overload.input.parameters[i] = parameter;
                }
                overloads.put(Integer.toString(length), overload);
            }
            CommandData data = new CommandData();
            data.aliases = alias;
            data.overloads = overloads;
            data.description = description;
            data.flags = flags;
            data.permission = permission;
            CommandDataVersions versions = new CommandDataVersions();
            versions.versions.add(data);
            this.commands.put(name, versions);
        }
    }

    @Override
    public void encode() {
        this.reset();
        LinkedHashSet enumValuesSet = new LinkedHashSet();
        LinkedHashSet postFixesSet = new LinkedHashSet();
        LinkedHashSet enumsSet = new LinkedHashSet();
        this.commands.forEach((name, data) -> {
            CommandData cmdData = data.versions.get(0);
            if (cmdData.aliases != null) {
                enumsSet.add(cmdData.aliases);
                enumValuesSet.addAll(cmdData.aliases.getValues());
            }
            for (CommandOverload overload : cmdData.overloads.values()) {
                for (CommandParameter parameter : overload.input.parameters) {
                    if (parameter.enumData != null) {
                        enumsSet.add(parameter.enumData);
                        enumValuesSet.addAll(parameter.enumData.getValues());
                    }
                    if (parameter.postFix == null) continue;
                    postFixesSet.add(parameter.postFix);
                }
            }
        });
        ArrayList enumValues = new ArrayList(enumValuesSet);
        ArrayList enums = new ArrayList(enumsSet);
        ArrayList postFixes = new ArrayList(postFixesSet);
        this.putUnsignedVarInt(enumValues.size());
        enumValues.forEach(this::putString);
        this.putUnsignedVarInt(postFixes.size());
        postFixes.forEach(this::putString);
        ObjIntConsumer<BinaryStream> indexWriter = enumValues.size() < 256 ? WRITE_BYTE : (enumValues.size() < 65536 ? WRITE_SHORT : WRITE_INT);
        this.putUnsignedVarInt(enums.size());
        enums.forEach(cmdEnum -> {
            this.putString(cmdEnum.getName());
            List<String> values = cmdEnum.getValues();
            this.putUnsignedVarInt(values.size());
            for (String val : values) {
                int i = enumValues.indexOf(val);
                if (i < 0) {
                    throw new IllegalStateException("Enum value '" + val + "' not found");
                }
                indexWriter.accept(this, i);
            }
        });
        this.putUnsignedVarInt(this.commands.size());
        this.commands.forEach((name, cmdData) -> {
            CommandData data = cmdData.versions.get(0);
            this.putString((String)name);
            this.putString(data.description);
            this.putByte((byte)data.flags);
            this.putByte((byte)data.permission);
            this.putLInt(data.aliases == null ? -1 : enums.indexOf(data.aliases));
            this.putUnsignedVarInt(data.overloads.size());
            for (CommandOverload overload : data.overloads.values()) {
                this.putUnsignedVarInt(overload.input.parameters.length);
                for (CommandParameter parameter : overload.input.parameters) {
                    this.putString(parameter.name);
                    int type = 0;
                    if (parameter.postFix != null) {
                        int i = postFixes.indexOf(parameter.postFix);
                        if (i < 0) {
                            throw new IllegalStateException("Postfix '" + parameter.postFix + "' isn't in postfix array");
                        }
                        type = 0x1000000 | i;
                    } else {
                        type |= 0x100000;
                        type = parameter.enumData != null ? (type |= 0x200000 | enums.indexOf(parameter.enumData)) : (type |= parameter.type.getId());
                    }
                    this.putLInt(type);
                    this.putBoolean(parameter.optional);
                    this.putByte(parameter.options);
                }
            }
        });
        this.putUnsignedVarInt(this.softEnums.size());
        this.softEnums.forEach((name, values) -> {
            this.putString((String)name);
            this.putUnsignedVarInt(values.size());
            values.forEach(this::putString);
        });
    }

    public String toString() {
        return "AvailableCommandsPacket(commands=" + this.commands + ", softEnums=" + this.softEnums + ")";
    }
}

