/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;

public class MoveEntityDeltaPacket
extends DataPacket {
    public static final byte NETWORK_ID = 111;
    public static final int FLAG_HAS_X = 1;
    public static final int FLAG_HAS_Y = 2;
    public static final int FLAG_HAS_Z = 4;
    public static final int FLAG_HAS_YAW = 8;
    public static final int FLAG_HAS_HEAD_YAW = 16;
    public static final int FLAG_HAS_PITCH = 32;
    public int flags = 0;
    public int xDelta = 0;
    public int yDelta = 0;
    public int zDelta = 0;
    public double yawDelta = 0.0;
    public double headYawDelta = 0.0;
    public double pitchDelta = 0.0;

    @Override
    public byte pid() {
        return 111;
    }

    @Override
    public void decode() {
        this.flags = this.getByte();
        this.xDelta = this.getCoordinate(1);
        this.yDelta = this.getCoordinate(2);
        this.zDelta = this.getCoordinate(4);
        this.yawDelta = this.getRotation(8);
        this.headYawDelta = this.getRotation(16);
        this.pitchDelta = this.getRotation(32);
    }

    @Override
    public void encode() {
        this.putByte((byte)this.flags);
        this.putCoordinate(1, this.xDelta);
        this.putCoordinate(2, this.yDelta);
        this.putCoordinate(4, this.zDelta);
        this.putRotation(8, this.yawDelta);
        this.putRotation(16, this.headYawDelta);
        this.putRotation(32, this.pitchDelta);
    }

    private int getCoordinate(int flag) {
        if ((this.flags & flag) != 0) {
            return this.getVarInt();
        }
        return 0;
    }

    private double getRotation(int flag) {
        if ((this.flags & flag) != 0) {
            return (double)this.getByte() * 1.40625;
        }
        return 0.0;
    }

    private void putCoordinate(int flag, int value) {
        if ((this.flags & flag) != 0) {
            this.putVarInt(value);
        }
    }

    private void putRotation(int flag, double value) {
        if ((this.flags & flag) != 0) {
            this.putByte((byte)(value / 1.40625));
        }
    }

    public String toString() {
        return "MoveEntityDeltaPacket(flags=" + this.flags + ", xDelta=" + this.xDelta + ", yDelta=" + this.yDelta + ", zDelta=" + this.zDelta + ", yawDelta=" + this.yawDelta + ", headYawDelta=" + this.headYawDelta + ", pitchDelta=" + this.pitchDelta + ")";
    }
}

