/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.permission;

import cn.nukkit.Server;
import cn.nukkit.permission.Permission;

public abstract class DefaultPermissions {
    public static final String ROOT = "nukkit";

    public static Permission registerPermission(Permission perm) {
        return DefaultPermissions.registerPermission(perm, null);
    }

    public static Permission registerPermission(Permission perm, Permission parent) {
        if (parent != null) {
            parent.getChildren().put(perm.getName(), true);
        }
        Server.getInstance().getPluginManager().addPermission(perm);
        return Server.getInstance().getPluginManager().getPermission(perm.getName());
    }

    public static void registerCorePermissions() {
        Permission parent = DefaultPermissions.registerPermission(new Permission(ROOT, "Allows using all Nukkit commands and utilities"));
        Permission broadcasts = DefaultPermissions.registerPermission(new Permission("nukkit.broadcast", "Allows the user to receive all broadcast messages"), parent);
        DefaultPermissions.registerPermission(new Permission("nukkit.broadcast.admin", "Allows the user to receive administrative broadcasts", "op"), broadcasts);
        DefaultPermissions.registerPermission(new Permission("nukkit.broadcast.user", "Allows the user to receive user broadcasts", "true"), broadcasts);
        broadcasts.recalculatePermissibles();
        Permission commands = DefaultPermissions.registerPermission(new Permission("nukkit.command", "Allows using all Nukkit commands"), parent);
        Permission whitelist = DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist", "Allows the user to modify the server whitelist", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.add", "Allows the user to add a player to the server whitelist"), whitelist);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.remove", "Allows the user to remove a player to the server whitelist"), whitelist);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.reload", "Allows the user to reload the server whitelist"), whitelist);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.enable", "Allows the user to enable the server whitelist"), whitelist);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.disable", "Allows the user to disable the server whitelist"), whitelist);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.whitelist.list", "Allows the user to list all the players on the server whitelist"), whitelist);
        whitelist.recalculatePermissibles();
        Permission ban = DefaultPermissions.registerPermission(new Permission("nukkit.command.ban", "Allows the user to ban people", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.ban.player", "Allows the user to ban players"), ban);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.ban.ip", "Allows the user to ban IP addresses"), ban);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.ban.list", "Allows the user to list all the banned ips or players"), ban);
        ban.recalculatePermissibles();
        Permission unban = DefaultPermissions.registerPermission(new Permission("nukkit.command.unban", "Allows the user to unban people", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.unban.player", "Allows the user to unban players"), unban);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.unban.ip", "Allows the user to unban IP addresses"), unban);
        unban.recalculatePermissibles();
        Permission op = DefaultPermissions.registerPermission(new Permission("nukkit.command.op", "Allows the user to change operators", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.op.give", "Allows the user to give a player operator status"), op);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.op.take", "Allows the user to take a players operator status"), op);
        op.recalculatePermissibles();
        Permission save = DefaultPermissions.registerPermission(new Permission("nukkit.command.save", "Allows the user to save the worlds", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.save.enable", "Allows the user to enable automatic saving"), save);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.save.disable", "Allows the user to disable automatic saving"), save);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.save.perform", "Allows the user to perform a manual save"), save);
        save.recalculatePermissibles();
        Permission time = DefaultPermissions.registerPermission(new Permission("nukkit.command.time", "Allows the user to alter the time", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.time.add", "Allows the user to fast-forward time"), time);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.time.set", "Allows the user to change the time"), time);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.time.start", "Allows the user to restart the time"), time);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.time.stop", "Allows the user to stop the time"), time);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.time.query", "Allows the user query the time"), time);
        time.recalculatePermissibles();
        Permission kill = DefaultPermissions.registerPermission(new Permission("nukkit.command.kill", "Allows the user to kill players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.kill.self", "Allows the user to commit suicide", "true"), kill);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.kill.other", "Allows the user to kill other players"), kill);
        kill.recalculatePermissibles();
        Permission gamemode = DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode", "Allows the user to change the gamemode of players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode.survival", "Allows the user to change the gamemode to survival", "op"), gamemode);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode.creative", "Allows the user to change the gamemode to creative", "op"), gamemode);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode.adventure", "Allows the user to change the gamemode to adventure", "op"), gamemode);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode.spectator", "Allows the user to change the gamemode to spectator", "op"), gamemode);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamemode.other", "Allows the user to change the gamemode of other players", "op"), gamemode);
        gamemode.recalculatePermissibles();
        DefaultPermissions.registerPermission(new Permission("nukkit.command.me", "Allows the user to perform a chat action", "true"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.tell", "Allows the user to privately message another player", "true"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.say", "Allows the user to talk as the console", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.give", "Allows the user to give items to players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.effect", "Allows the user to give/take potion effects", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.particle", "Allows the user to create particle effects", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.teleport", "Allows the user to teleport players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.kick", "Allows the user to kick players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.stop", "Allows the user to stop the server", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.list", "Allows the user to list all online players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.help", "Allows the user to view the help menu", "true"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.plugins", "Allows the user to view the list of plugins", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.reload", "Allows the user to reload the server settings", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.version", "Allows the user to view the version of the server", "true"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.defaultgamemode", "Allows the user to change the default gamemode", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.seed", "Allows the user to view the seed of the world", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.status", "Allows the user to view the server performance", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gc", "Allows the user to fire garbage collection tasks", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.dumpmemory", "Allows the user to dump memory contents", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.gamerule", "Sets or queries a game rule value", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.timings", "Allows the user to records timings for all plugin events", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.title", "Allows the user to send titles to players", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.spawnpoint", "Allows the user to change player's spawnpoint", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.setworldspawn", "Allows the user to change the world spawn", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.weather", "Allows the user to change the weather", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.command.xp", "Allows the user to give experience", "op"), commands);
        DefaultPermissions.registerPermission(new Permission("nukkit.textcolor", "Allows the user to write colored text", "op"), commands);
        commands.recalculatePermissibles();
        parent.recalculatePermissibles();
    }
}

