/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.DyeColor;

public class BlockColor {
    public static final BlockColor TRANSPARENT_BLOCK_COLOR = new BlockColor(0, 0, 0, 0);
    public static final BlockColor VOID_BLOCK_COLOR = new BlockColor(0, 0, 0, 0);
    public static final BlockColor AIR_BLOCK_COLOR = new BlockColor(0, 0, 0);
    public static final BlockColor GRASS_BLOCK_COLOR = new BlockColor(127, 178, 56);
    public static final BlockColor SAND_BLOCK_COLOR = new BlockColor(241, 233, 163);
    public static final BlockColor CLOTH_BLOCK_COLOR = new BlockColor(167, 167, 167);
    public static final BlockColor TNT_BLOCK_COLOR = new BlockColor(255, 0, 0);
    public static final BlockColor ICE_BLOCK_COLOR = new BlockColor(160, 160, 255);
    public static final BlockColor IRON_BLOCK_COLOR = new BlockColor(167, 167, 167);
    public static final BlockColor FOLIAGE_BLOCK_COLOR = new BlockColor(0, 124, 0);
    public static final BlockColor SNOW_BLOCK_COLOR = new BlockColor(255, 255, 255);
    public static final BlockColor CLAY_BLOCK_COLOR = new BlockColor(164, 168, 184);
    public static final BlockColor DIRT_BLOCK_COLOR = new BlockColor(183, 106, 47);
    public static final BlockColor STONE_BLOCK_COLOR = new BlockColor(112, 112, 112);
    public static final BlockColor WATER_BLOCK_COLOR = new BlockColor(64, 64, 255);
    public static final BlockColor LAVA_BLOCK_COLOR = TNT_BLOCK_COLOR;
    public static final BlockColor WOOD_BLOCK_COLOR = new BlockColor(104, 83, 50);
    public static final BlockColor QUARTZ_BLOCK_COLOR = new BlockColor(255, 252, 245);
    public static final BlockColor ADOBE_BLOCK_COLOR = new BlockColor(216, 127, 51);
    public static final BlockColor WHITE_BLOCK_COLOR = SNOW_BLOCK_COLOR;
    public static final BlockColor ORANGE_BLOCK_COLOR = ADOBE_BLOCK_COLOR;
    public static final BlockColor MAGENTA_BLOCK_COLOR = new BlockColor(178, 76, 216);
    public static final BlockColor LIGHT_BLUE_BLOCK_COLOR = new BlockColor(102, 153, 216);
    public static final BlockColor YELLOW_BLOCK_COLOR = new BlockColor(229, 229, 51);
    public static final BlockColor LIME_BLOCK_COLOR = new BlockColor(127, 204, 25);
    public static final BlockColor PINK_BLOCK_COLOR = new BlockColor(242, 127, 165);
    public static final BlockColor GRAY_BLOCK_COLOR = new BlockColor(76, 76, 76);
    public static final BlockColor LIGHT_GRAY_BLOCK_COLOR = new BlockColor(153, 153, 153);
    public static final BlockColor CYAN_BLOCK_COLOR = new BlockColor(76, 127, 153);
    public static final BlockColor PURPLE_BLOCK_COLOR = new BlockColor(127, 63, 178);
    public static final BlockColor BLUE_BLOCK_COLOR = new BlockColor(51, 76, 178);
    public static final BlockColor BROWN_BLOCK_COLOR = new BlockColor(102, 76, 51);
    public static final BlockColor GREEN_BLOCK_COLOR = new BlockColor(102, 127, 51);
    public static final BlockColor RED_BLOCK_COLOR = new BlockColor(153, 51, 51);
    public static final BlockColor BLACK_BLOCK_COLOR = new BlockColor(25, 25, 25);
    public static final BlockColor GOLD_BLOCK_COLOR = new BlockColor(250, 238, 77);
    public static final BlockColor DIAMOND_BLOCK_COLOR = new BlockColor(92, 219, 213);
    public static final BlockColor LAPIS_BLOCK_COLOR = new BlockColor(74, 128, 255);
    public static final BlockColor EMERALD_BLOCK_COLOR = new BlockColor(0, 217, 58);
    public static final BlockColor OBSIDIAN_BLOCK_COLOR = new BlockColor(21, 20, 31);
    public static final BlockColor SPRUCE_BLOCK_COLOR = new BlockColor(129, 86, 49);
    public static final BlockColor NETHERRACK_BLOCK_COLOR = new BlockColor(112, 2, 0);
    public static final BlockColor REDSTONE_BLOCK_COLOR = TNT_BLOCK_COLOR;
    public static final BlockColor WHITE_TERRACOTA_BLOCK_COLOR = new BlockColor(209, 177, 161);
    public static final BlockColor ORANGE_TERRACOTA_BLOCK_COLOR = new BlockColor(159, 82, 36);
    public static final BlockColor MAGENTA_TERRACOTA_BLOCK_COLOR = new BlockColor(149, 87, 108);
    public static final BlockColor LIGHT_BLUE_TERRACOTA_BLOCK_COLOR = new BlockColor(112, 108, 138);
    public static final BlockColor YELLOW_TERRACOTA_BLOCK_COLOR = new BlockColor(186, 133, 36);
    public static final BlockColor LIME_TERRACOTA_BLOCK_COLOR = new BlockColor(103, 117, 53);
    public static final BlockColor PINK_TERRACOTA_BLOCK_COLOR = new BlockColor(160, 77, 78);
    public static final BlockColor GRAY_TERRACOTA_BLOCK_COLOR = new BlockColor(57, 41, 35);
    public static final BlockColor LIGHT_GRAY_TERRACOTA_BLOCK_COLOR = new BlockColor(135, 107, 98);
    public static final BlockColor CYAN_TERRACOTA_BLOCK_COLOR = new BlockColor(87, 92, 92);
    public static final BlockColor PURPLE_TERRACOTA_BLOCK_COLOR = new BlockColor(122, 73, 88);
    public static final BlockColor BLUE_TERRACOTA_BLOCK_COLOR = new BlockColor(76, 62, 92);
    public static final BlockColor BROWN_TERRACOTA_BLOCK_COLOR = new BlockColor(76, 50, 35);
    public static final BlockColor GREEN_TERRACOTA_BLOCK_COLOR = new BlockColor(76, 82, 42);
    public static final BlockColor RED_TERRACOTA_BLOCK_COLOR = new BlockColor(142, 60, 46);
    public static final BlockColor BLACK_TERRACOTA_BLOCK_COLOR = new BlockColor(37, 2838, 16);
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public BlockColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public BlockColor(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public BlockColor(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.alpha = 255;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockColor)) {
            return false;
        }
        BlockColor other = (BlockColor)obj;
        return this.red == other.red && this.green == other.green && this.blue == other.blue && this.alpha == other.alpha;
    }

    public String toString() {
        return "BlockColor[r=" + this.red + ",g=" + this.green + ",b=" + this.blue + ",a=" + this.alpha + "]";
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRGB() {
        return (this.red << 16 | this.green << 8 | this.blue) & 0xFFFFFF;
    }

    @Deprecated
    public static BlockColor getDyeColor(int dyeColorMeta) {
        return DyeColor.getByDyeData(dyeColorMeta).getColor();
    }
}

