/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.ZlibOriginal;
import cn.nukkit.utils.ZlibProvider;
import cn.nukkit.utils.ZlibSingleThreadLowMem;
import cn.nukkit.utils.ZlibThreadLocal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class Zlib {
    private static ZlibProvider[] providers = new ZlibProvider[3];
    private static ZlibProvider provider;

    public static void setProvider(int providerIndex) {
        MainLogger.getLogger().info("Selected Zlib Provider: " + providerIndex + " (" + provider.getClass().getCanonicalName() + ")");
        switch (providerIndex) {
            case 0: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibOriginal();
                break;
            }
            case 1: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibSingleThreadLowMem();
                break;
            }
            case 2: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibThreadLocal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid provider: " + providerIndex);
            }
        }
        if (providerIndex != 2) {
            MainLogger.getLogger().warning(" - This Zlib will negatively affect performance");
        }
        provider = providers[providerIndex];
    }

    public static byte[] deflate(byte[] data) throws Exception {
        return Zlib.deflate(data, -1);
    }

    public static byte[] deflate(byte[] data, int level) throws Exception {
        return provider.deflate(data, level);
    }

    public static byte[] deflate(byte[][] data, int level) throws Exception {
        return provider.deflate(data, level);
    }

    public static byte[] inflate(InputStream stream) throws IOException {
        return provider.inflate(stream);
    }

    public static byte[] inflate(byte[] data) throws IOException {
        return Zlib.inflate(new ByteArrayInputStream(data));
    }

    public static byte[] inflate(byte[] data, int maxSize) throws IOException {
        return Zlib.inflate(new ByteArrayInputStream(data, 0, maxSize));
    }

    static {
        Zlib.providers[2] = new ZlibThreadLocal();
        provider = providers[2];
    }
}

