/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.ZlibProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;

public class ZlibSingleThreadLowMem
implements ZlibProvider {
    static final int BUFFER_SIZE = 8192;
    Deflater deflater = new Deflater(9);
    byte[] buffer = new byte[8192];

    @Override
    public synchronized byte[] deflate(byte[][] datas, int level) throws Exception {
        Deflater deflater = this.deflater;
        if (deflater == null) {
            throw new IllegalArgumentException("No deflate for level " + level + " !");
        }
        deflater.reset();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(datas.length);
        for (byte[] data : datas) {
            deflater.setInput(data);
            while (!deflater.needsInput()) {
                int i = deflater.deflate(this.buffer);
                bos.write(this.buffer, 0, i);
            }
        }
        deflater.finish();
        while (!deflater.finished()) {
            int i = deflater.deflate(this.buffer);
            bos.write(this.buffer, 0, i);
        }
        return bos.toByteArray();
    }

    @Override
    public synchronized byte[] deflate(byte[] data, int level) throws Exception {
        this.deflater.reset();
        this.deflater.setInput(data);
        this.deflater.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        while (!this.deflater.finished()) {
            int i = this.deflater.deflate(this.buffer);
            bos.write(this.buffer, 0, i);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] inflate(InputStream stream) throws IOException {
        byte[] bufferOut;
        InflaterInputStream inputStream = new InflaterInputStream(stream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);
        try {
            int length;
            while ((length = inputStream.read(this.buffer)) != -1) {
                outputStream.write(this.buffer, 0, length);
            }
        }
        finally {
            outputStream.flush();
            bufferOut = outputStream.toByteArray();
            outputStream.close();
            inputStream.close();
        }
        return bufferOut;
    }
}

